/*
 * Decompiled with CFR 0.152.
 */
package ai.olami.cloudService;

import ai.olami.cloudService.APIConfiguration;
import ai.olami.cloudService.APIRequestBase;
import ai.olami.cloudService.APIResponse;
import ai.olami.cloudService.APIResponseBuilder;
import ai.olami.cloudService.NLIConfig;
import ai.olami.util.GsonFactory;
import ai.olami.util.HttpClient;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.NoSuchAlgorithmException;

public class TextRecognizer
extends APIRequestBase {
    public static final String RQ_DATA_TYPE_STT = "stt";
    public static final int RQ_DATA_INPUT_TYPE_FROM_SPEECH = 0;
    public static final int RQ_DATA_INPUT_TYPE_FROM_TEXT = 1;
    private int mRqDataInputType = 0;
    private Gson mGson = GsonFactory.getNormalGson();

    public TextRecognizer(APIConfiguration configuration) {
        super(configuration);
    }

    public void setNLIDataInputType(int inputType) {
        this.mRqDataInputType = inputType;
    }

    public APIResponse requestWordSegmentation(String text) throws NoSuchAlgorithmException, IOException {
        return this.sendRequest("seg", text, null);
    }

    public APIResponse requestNLI(String text) throws NoSuchAlgorithmException, IOException {
        return this.requestNLI(text, null);
    }

    public APIResponse requestNLI(String text, NLIConfig nliConfig) throws NoSuchAlgorithmException, IOException {
        return this.sendRequest("nli", text, nliConfig);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private APIResponse sendRequest(String apiName, String text, NLIConfig nliConfig) throws NoSuchAlgorithmException, IOException {
        String response;
        block8: {
            StringBuffer httpQueryStringBuffer = new StringBuffer();
            if (apiName == "seg") {
                httpQueryStringBuffer.append("rq=");
                httpQueryStringBuffer.append(text);
            } else if (apiName == "nli") {
                JsonObject data = new JsonObject();
                data.addProperty("input_type", (Number)this.mRqDataInputType);
                data.addProperty("text", text);
                JsonObject rq = new JsonObject();
                rq.addProperty("data_type", RQ_DATA_TYPE_STT);
                rq.add("data", (JsonElement)data);
                if (nliConfig != null) {
                    rq.add("nli_config", nliConfig.toJsonElement());
                }
                httpQueryStringBuffer.append("rq=");
                httpQueryStringBuffer.append(this.mGson.toJson((JsonElement)rq));
            }
            URL url = new URL(this.getConfiguration().getBaseRequestURL(apiName));
            HttpURLConnection httpConnection = (HttpURLConnection)url.openConnection();
            httpConnection.setRequestMethod("POST");
            httpConnection.setRequestProperty("contentType", "utf-8");
            httpConnection.setConnectTimeout(this.getTimeout());
            response = null;
            try (HttpClient httpClient = null;){
                httpClient = new HttpClient(httpConnection);
                httpClient.postQueryConnect(httpQueryStringBuffer.toString());
                if (httpClient.getResponseCode() == 200) {
                    response = httpClient.getResponseContent();
                    break block8;
                }
                throw new IOException(httpClient.getResponseMessage());
            }
        }
        return APIResponseBuilder.create(response);
    }
}

