/*
 * Decompiled with CFR 0.152.
 */
package ai.olami.ids;

import ai.olami.ids.BaikeData;
import ai.olami.ids.CookingData;
import ai.olami.ids.ExchangeRateData;
import ai.olami.ids.JokeData;
import ai.olami.ids.MathData;
import ai.olami.ids.NewsData;
import ai.olami.ids.OpenWebData;
import ai.olami.ids.PoemData;
import ai.olami.ids.StockMarketData;
import ai.olami.ids.TVProgramData;
import ai.olami.ids.UnitConvertData;
import ai.olami.ids.WeatherData;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.ArrayList;

public class IDSResult {

    public static enum Types {
        QUESTION("question", null),
        CONFIRMATION("confirmation", null),
        SELECTION("selection", null),
        DATE("date", null),
        NONSENSE("nonsense", null),
        ZIP_CODE("zipcode", null),
        MATH_24("math24", null),
        WEATHER("weather", new TypeToken<ArrayList<WeatherData>>(){}.getType()),
        BAIKE("baike", new TypeToken<ArrayList<BaikeData>>(){}.getType()),
        NEWS("news", new TypeToken<ArrayList<NewsData>>(){}.getType()),
        TV_PROGRAM("tvprogram", new TypeToken<ArrayList<TVProgramData>>(){}.getType()),
        POEM("poem", new TypeToken<ArrayList<PoemData>>(){}.getType()),
        JOKE("joke", new TypeToken<ArrayList<JokeData>>(){}.getType()),
        STOCK_MARKET("stock", new TypeToken<ArrayList<StockMarketData>>(){}.getType()),
        MATH("math", new TypeToken<ArrayList<MathData>>(){}.getType()),
        UNIT_CONVERT("unitconvert", new TypeToken<ArrayList<UnitConvertData>>(){}.getType()),
        EXCHANGE_RATE("exchangerate", new TypeToken<ArrayList<ExchangeRateData>>(){}.getType()),
        COOKING("cooking", new TypeToken<ArrayList<CookingData>>(){}.getType()),
        OPEN_WEB("openweb", new TypeToken<ArrayList<OpenWebData>>(){}.getType());

        private String name;
        private Type dataObjArrayListType;

        private Types(String name, Type dataObjArrayListType) {
            this.name = name;
            this.dataObjArrayListType = dataObjArrayListType;
        }

        public String getName() {
            return this.name;
        }

        public Type getDataArrayListType() {
            return this.dataObjArrayListType;
        }

        public static boolean contains(String moduleName) {
            T[] list;
            for (Object t : list = Types.class.getEnumConstants()) {
                if (!((Types)((Object)t)).getName().equals(moduleName)) continue;
                return true;
            }
            return false;
        }

        public static Types getByName(String moduleName) {
            T[] list;
            for (Object t : list = Types.class.getEnumConstants()) {
                if (!((Types)((Object)t)).getName().equals(moduleName)) continue;
                return (Types)((Object)t);
            }
            return null;
        }

        public static Type getDataArrayListType(String moduleName) {
            T[] list;
            for (Object t : list = Types.class.getEnumConstants()) {
                if (!((Types)((Object)t)).getName().equals(moduleName)) continue;
                return ((Types)((Object)t)).getDataArrayListType();
            }
            return null;
        }
    }
}

