/*
 * Decompiled with CFR 0.152.
 */
package ai.olami.nli;

import ai.olami.ids.IDSResult;
import ai.olami.nli.DescObject;
import ai.olami.nli.Semantic;
import ai.olami.util.GsonFactory;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import java.util.ArrayList;

public class NLIResult {
    private Gson mGson = GsonFactory.getNormalGson();
    @Expose
    @SerializedName(value="desc_obj")
    private DescObject mDescObject = null;
    @Expose
    @SerializedName(value="semantic")
    private Semantic[] mSemantics = null;
    @Expose
    @SerializedName(value="type")
    private String mType = null;
    @Expose
    @SerializedName(value="data_obj")
    private JsonElement mDataObjs = null;

    public DescObject getDescObject() {
        return this.mDescObject;
    }

    public boolean hasDescObject() {
        return this.mDescObject != null;
    }

    public Semantic[] getSemantics() {
        return this.mSemantics;
    }

    public boolean hasSemantics() {
        return this.mSemantics != null && this.mSemantics.length > 0;
    }

    public String getType() {
        return this.mType;
    }

    public boolean hasType() {
        return this.mType != null && !this.mType.equals("");
    }

    public boolean isFromIDS() {
        return IDSResult.Types.contains(this.mType);
    }

    public <T> ArrayList<T> getDataObjects() {
        if (this.isFromIDS()) {
            String typeName = this.mType;
            switch (IDSResult.Types.getByName(this.mType)) {
                case QUESTION: {
                    typeName = this.getDescObject().getType();
                    break;
                }
                case CONFIRMATION: {
                    typeName = this.getDescObject().getType();
                    break;
                }
                case SELECTION: {
                    typeName = this.getDescObject().getType();
                    break;
                }
            }
            return (ArrayList)this.mGson.fromJson(this.mDataObjs, IDSResult.Types.getDataArrayListType(typeName));
        }
        if (this.hasDataObjects()) {
            return (ArrayList)this.mGson.fromJson(this.mDataObjs, new TypeToken<ArrayList<JsonElement>>(){}.getType());
        }
        return null;
    }

    public boolean hasDataObjects() {
        return this.mDataObjs != null;
    }
}

