/*
 * Decompiled with CFR 0.152.
 */
package ai.olami.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;

public class HttpClient {
    private final HttpURLConnection mHttpConnection;
    private OutputStream mOutStream = null;

    public HttpClient(HttpURLConnection httpConnection) {
        if (httpConnection == null) {
            throw new IllegalArgumentException("HttpURLConnection is null.");
        }
        this.mHttpConnection = httpConnection;
    }

    public void normalConnect() throws IOException {
        this.mHttpConnection.connect();
    }

    public void postQueryConnect(String queryParams) throws IOException {
        this.mHttpConnection.setDoOutput(true);
        this.mOutStream = this.mHttpConnection.getOutputStream();
        if (!queryParams.startsWith("&")) {
            this.mOutStream.write("&".getBytes("utf-8"));
        }
        this.mOutStream.write(queryParams.getBytes("utf-8"));
        this.mOutStream.flush();
        this.mOutStream.close();
    }

    public void postQueryConnect(Map<String, String> queryParams) throws IOException {
        StringBuffer queryParamsStringBuffer = new StringBuffer();
        if (queryParams != null) {
            for (String key : queryParams.keySet()) {
                queryParamsStringBuffer.append("&");
                queryParamsStringBuffer.append(key.toString());
                queryParamsStringBuffer.append("=");
                queryParamsStringBuffer.append(queryParams.get(key));
            }
        }
        this.postQueryConnect(queryParamsStringBuffer.toString());
    }

    public void octetStreamConnect(byte[] streamBuffer, int writeBytes) throws IOException {
        this.mHttpConnection.setDoOutput(true);
        this.mHttpConnection.setRequestProperty("Connection", "Keep-Alive");
        this.mHttpConnection.setRequestProperty("Content-Type", "application/octet-stream");
        this.mOutStream = this.mHttpConnection.getOutputStream();
        this.mOutStream.write(streamBuffer, 0, writeBytes);
        this.mOutStream.flush();
        this.mOutStream.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getResponseContent() throws IOException {
        StringBuffer inputStringBuffer = new StringBuffer();
        try (BufferedReader inputReader = null;){
            String inputLine;
            inputReader = new BufferedReader(new InputStreamReader(this.mHttpConnection.getInputStream(), StandardCharsets.UTF_8));
            while ((inputLine = inputReader.readLine()) != null) {
                inputStringBuffer.append(inputLine);
            }
            inputReader.close();
        }
        return inputStringBuffer.toString();
    }

    public int getResponseCode() throws IOException {
        return this.mHttpConnection.getResponseCode();
    }

    public String getResponseMessage() throws IOException {
        return this.mHttpConnection.getResponseMessage();
    }

    public List<String> getCookies() {
        return this.mHttpConnection.getHeaderFields().get("Set-Cookie");
    }

    public void close() throws IOException {
        if (this.mOutStream != null) {
            this.mOutStream.close();
        }
        if (this.mHttpConnection != null) {
            this.mHttpConnection.disconnect();
        }
    }
}

