/*
 * Decompiled with CFR 0.152.
 */
package org.xiph.speex;

import org.xiph.speex.Bits;
import org.xiph.speex.Filters;
import org.xiph.speex.Ltp;

public class Ltp3Tap
extends Ltp {
    private float[] gain = new float[3];
    private int[] gain_cdbk;
    private int gain_bits;
    private int pitch_bits;
    private float[][] e;

    public Ltp3Tap(int[] gain_cdbk, int gain_bits, int pitch_bits) {
        this.gain_cdbk = gain_cdbk;
        this.gain_bits = gain_bits;
        this.pitch_bits = pitch_bits;
        this.e = new float[3][128];
    }

    @Override
    public final int quant(float[] target, float[] sw, int sws, float[] ak, float[] awk1, float[] awk2, float[] exc, int es, int start, int end, float pitch_coef, int p, int nsf, Bits bits, float[] exc2, int e2s, float[] r, int complexity) {
        int i;
        int[] cdbk_index = new int[1];
        int pitch = 0;
        int best_gain_index = 0;
        int best_pitch = 0;
        float best_err = -1.0f;
        int N = complexity;
        if (N > 10) {
            N = 10;
        }
        int[] nbest = new int[N];
        float[] gains = new float[N];
        if (N == 0 || end < start) {
            bits.pack(0, this.pitch_bits);
            bits.pack(0, this.gain_bits);
            for (int i2 = 0; i2 < nsf; ++i2) {
                exc[es + i2] = 0.0f;
            }
            return start;
        }
        float[] best_exc = new float[nsf];
        if (N > end - start + 1) {
            N = end - start + 1;
        }
        Ltp3Tap.open_loop_nbest_pitch(sw, sws, start, end, nsf, nbest, gains, N);
        for (i = 0; i < N; ++i) {
            int j;
            pitch = nbest[i];
            for (j = 0; j < nsf; ++j) {
                exc[es + j] = 0.0f;
            }
            float err = this.pitch_gain_search_3tap(target, ak, awk1, awk2, exc, es, pitch, p, nsf, bits, exc2, e2s, r, cdbk_index);
            if (!(err < best_err) && !(best_err < 0.0f)) continue;
            for (j = 0; j < nsf; ++j) {
                best_exc[j] = exc[es + j];
            }
            best_err = err;
            best_pitch = pitch;
            best_gain_index = cdbk_index[0];
        }
        bits.pack(best_pitch - start, this.pitch_bits);
        bits.pack(best_gain_index, this.gain_bits);
        for (i = 0; i < nsf; ++i) {
            exc[es + i] = best_exc[i];
        }
        return pitch;
    }

    @Override
    public final int unquant(float[] exc, int es, int start, float pitch_coef, int nsf, float[] gain_val, Bits bits, int count_lost, int subframe_offset, float last_pitch_gain) {
        int i;
        int pitch = bits.unpack(this.pitch_bits);
        int gain_index = bits.unpack(this.gain_bits);
        this.gain[0] = 0.015625f * (float)this.gain_cdbk[gain_index * 3] + 0.5f;
        this.gain[1] = 0.015625f * (float)this.gain_cdbk[gain_index * 3 + 1] + 0.5f;
        this.gain[2] = 0.015625f * (float)this.gain_cdbk[gain_index * 3 + 2] + 0.5f;
        if (count_lost != 0 && (pitch += start) > subframe_offset) {
            float tmp;
            float gain_sum = Math.abs(this.gain[1]);
            float f = tmp = count_lost < 4 ? last_pitch_gain : 0.4f * last_pitch_gain;
            if (tmp > 0.95f) {
                tmp = 0.95f;
            }
            gain_sum = this.gain[0] > 0.0f ? (gain_sum += this.gain[0]) : (gain_sum -= 0.5f * this.gain[0]);
            gain_sum = this.gain[2] > 0.0f ? (gain_sum += this.gain[2]) : (gain_sum -= 0.5f * this.gain[0]);
            if (gain_sum > tmp) {
                float fact = tmp / gain_sum;
                i = 0;
                while (i < 3) {
                    int n = i++;
                    this.gain[n] = this.gain[n] * fact;
                }
            }
        }
        gain_val[0] = this.gain[0];
        gain_val[1] = this.gain[1];
        gain_val[2] = this.gain[2];
        for (i = 0; i < 3; ++i) {
            int j;
            int tmp2;
            int tmp1 = nsf;
            int pp = pitch + 1 - i;
            if (tmp1 > pp) {
                tmp1 = pp;
            }
            if ((tmp2 = nsf) > pp + pitch) {
                tmp2 = pp + pitch;
            }
            for (j = 0; j < tmp1; ++j) {
                this.e[i][j] = exc[es + j - pp];
            }
            for (j = tmp1; j < tmp2; ++j) {
                this.e[i][j] = exc[es + j - pp - pitch];
            }
            for (j = tmp2; j < nsf; ++j) {
                this.e[i][j] = 0.0f;
            }
        }
        for (i = 0; i < nsf; ++i) {
            exc[es + i] = this.gain[0] * this.e[2][i] + this.gain[1] * this.e[1][i] + this.gain[2] * this.e[0][i];
        }
        return pitch;
    }

    private float pitch_gain_search_3tap(float[] target, float[] ak, float[] awk1, float[] awk2, float[] exc, int es, int pitch, int p, int nsf, Bits bits, float[] exc2, int e2s, float[] r, int[] cdbk_index) {
        int j;
        int i;
        float[] corr = new float[3];
        float[][] A = new float[3][3];
        int gain_cdbk_size = 1 << this.gain_bits;
        float[][] x = new float[3][nsf];
        this.e = new float[3][nsf];
        for (i = 2; i >= 0; --i) {
            int pp = pitch + 1 - i;
            for (j = 0; j < nsf; ++j) {
                this.e[i][j] = j - pp < 0 ? exc2[e2s + j - pp] : (j - pp - pitch < 0 ? exc2[e2s + j - pp - pitch] : 0.0f);
            }
            if (i == 2) {
                Filters.syn_percep_zero(this.e[i], 0, ak, awk1, awk2, x[i], nsf, p);
                continue;
            }
            for (j = 0; j < nsf - 1; ++j) {
                x[i][j + 1] = x[i + 1][j];
            }
            x[i][0] = 0.0f;
            for (j = 0; j < nsf; ++j) {
                float[] fArray = x[i];
                int n = j;
                fArray[n] = fArray[n] + this.e[i][0] * r[j];
            }
        }
        for (i = 0; i < 3; ++i) {
            corr[i] = Ltp3Tap.inner_prod(x[i], 0, target, 0, nsf);
        }
        for (i = 0; i < 3; ++i) {
            for (j = 0; j <= i; ++j) {
                float f = Ltp3Tap.inner_prod(x[i], 0, x[j], 0, nsf);
                A[j][i] = f;
                A[i][j] = f;
            }
        }
        float[] C = new float[9];
        int ptr = 0;
        int best_cdbk = 0;
        float best_sum = 0.0f;
        C[0] = corr[2];
        C[1] = corr[1];
        C[2] = corr[0];
        C[3] = A[1][2];
        C[4] = A[0][1];
        C[5] = A[0][2];
        C[6] = A[2][2];
        C[7] = A[1][1];
        C[8] = A[0][0];
        for (i = 0; i < gain_cdbk_size; ++i) {
            float sum = 0.0f;
            ptr = 3 * i;
            float g0 = 0.015625f * (float)this.gain_cdbk[ptr] + 0.5f;
            float g1 = 0.015625f * (float)this.gain_cdbk[ptr + 1] + 0.5f;
            float g2 = 0.015625f * (float)this.gain_cdbk[ptr + 2] + 0.5f;
            sum += C[0] * g0;
            sum += C[1] * g1;
            sum += C[2] * g2;
            sum -= C[3] * g0 * g1;
            sum -= C[4] * g2 * g1;
            sum -= C[5] * g2 * g0;
            sum -= 0.5f * C[6] * g0 * g0;
            sum -= 0.5f * C[7] * g1 * g1;
            if (!((sum -= 0.5f * C[8] * g2 * g2) > best_sum) && i != 0) continue;
            best_sum = sum;
            best_cdbk = i;
        }
        this.gain[0] = 0.015625f * (float)this.gain_cdbk[best_cdbk * 3] + 0.5f;
        this.gain[1] = 0.015625f * (float)this.gain_cdbk[best_cdbk * 3 + 1] + 0.5f;
        this.gain[2] = 0.015625f * (float)this.gain_cdbk[best_cdbk * 3 + 2] + 0.5f;
        cdbk_index[0] = best_cdbk;
        for (i = 0; i < nsf; ++i) {
            exc[es + i] = this.gain[0] * this.e[2][i] + this.gain[1] * this.e[1][i] + this.gain[2] * this.e[0][i];
        }
        float err1 = 0.0f;
        float err2 = 0.0f;
        for (i = 0; i < nsf; ++i) {
            err1 += target[i] * target[i];
        }
        for (i = 0; i < nsf; ++i) {
            err2 += (target[i] - this.gain[2] * x[0][i] - this.gain[1] * x[1][i] - this.gain[0] * x[2][i]) * (target[i] - this.gain[2] * x[0][i] - this.gain[1] * x[1][i] - this.gain[0] * x[2][i]);
        }
        return err2;
    }
}

