/*
 * Decompiled with CFR 0.152.
 */
package ai.optfor.springopenaiapi;

import ai.optfor.springopenaiapi.model.ChatCompletionRequest;
import ai.optfor.springopenaiapi.model.ChatCompletionResponse;
import ai.optfor.springopenaiapi.model.ChatMessage;
import ai.optfor.springopenaiapi.model.EmbeddingData;
import ai.optfor.springopenaiapi.model.EmbeddingRequest;
import ai.optfor.springopenaiapi.model.EmbeddingResponse;
import java.util.List;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.ClientHttpRequestInterceptor;
import org.springframework.http.client.SimpleClientHttpRequestFactory;
import org.springframework.web.client.RestTemplate;

public class OpenAIApi {
    public final RestTemplate restTemplate = new RestTemplate();

    public OpenAIApi(String openaiKey) {
        SimpleClientHttpRequestFactory requestFactory = new SimpleClientHttpRequestFactory();
        requestFactory.setConnectTimeout(5000);
        requestFactory.setReadTimeout(120000);
        this.restTemplate.setRequestFactory((ClientHttpRequestFactory)requestFactory);
        ClientHttpRequestInterceptor interceptor = (request, body, execution) -> {
            request.getHeaders().add("Authorization", "Bearer " + openaiKey);
            return execution.execute(request, body);
        };
        this.restTemplate.setInterceptors(List.of(interceptor));
    }

    public ChatCompletionResponse chatCompletion(String model, String prompt, String role, Integer maxTokens, double temperature) {
        return this.chatCompletion(model, List.of(ChatMessage.roleMessage(role), ChatMessage.contentMessage(prompt)), maxTokens, temperature);
    }

    public ChatCompletionResponse chatCompletion(String model, List<ChatMessage> chats, int maxTokens, double temperature) {
        String url = "https://api.openai.com/v1/chat/completions";
        return (ChatCompletionResponse)this.restTemplate.postForObject(url, (Object)new ChatCompletionRequest(model, chats, temperature, maxTokens), ChatCompletionResponse.class, new Object[0]);
    }

    public EmbeddingData embedding(String model, String content) {
        return this.embedding(model, List.of(content)).data().get(0);
    }

    public EmbeddingResponse embedding(String model, List<String> content) {
        String url = "https://api.openai.com/v1/embeddings";
        return (EmbeddingResponse)this.restTemplate.postForObject(url, (Object)new EmbeddingRequest(model, content), EmbeddingResponse.class, new Object[0]);
    }
}

