/*
 * Decompiled with CFR 0.152.
 */
package ai.optfor.springopenaiapi;

import ai.optfor.springopenaiapi.model.ChatCompletionRequest;
import ai.optfor.springopenaiapi.model.ChatCompletionResponse;
import ai.optfor.springopenaiapi.model.ChatMessage;
import ai.optfor.springopenaiapi.model.EmbeddingData;
import ai.optfor.springopenaiapi.model.EmbeddingRequest;
import ai.optfor.springopenaiapi.model.EmbeddingResponse;
import java.util.List;
import org.springframework.cache.Cache;
import org.springframework.cache.CacheManager;
import org.springframework.cache.concurrent.ConcurrentMapCacheManager;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.ClientHttpRequestInterceptor;
import org.springframework.http.client.SimpleClientHttpRequestFactory;
import org.springframework.web.client.RestTemplate;

public class OpenAIApi {
    public final RestTemplate restTemplate;
    public final Cache cache;

    public OpenAIApi(String openaiKey, RestTemplate restTemplate, CacheManager cacheManager) {
        this.restTemplate = restTemplate == null ? new RestTemplate() : restTemplate;
        CacheManager usedCacheManager = cacheManager == null ? new ConcurrentMapCacheManager() : cacheManager;
        this.cache = usedCacheManager.getCache("promptCache");
        SimpleClientHttpRequestFactory requestFactory = new SimpleClientHttpRequestFactory();
        requestFactory.setConnectTimeout(5000);
        requestFactory.setReadTimeout(120000);
        this.restTemplate.setRequestFactory((ClientHttpRequestFactory)requestFactory);
        ClientHttpRequestInterceptor interceptor = (request, body, execution) -> {
            request.getHeaders().add("Authorization", "Bearer " + openaiKey);
            return execution.execute(request, body);
        };
        this.restTemplate.setInterceptors(List.of(interceptor));
    }

    public ChatCompletionResponse chat(String model, String prompt, String role, Integer maxTokens, double temperature) {
        return this.chat(model, List.of(ChatMessage.roleMessage(role), ChatMessage.contentMessage(prompt)), maxTokens, temperature);
    }

    public ChatCompletionResponse chat(String model, List<ChatMessage> chats, int maxTokens, double temperature) {
        Cache.ValueWrapper value;
        if (this.shouldCacheResponse(temperature) && (value = this.cache.get((Object)this.createKey(model, chats, maxTokens))) != null) {
            return (ChatCompletionResponse)value.get();
        }
        ChatCompletionResponse response = (ChatCompletionResponse)this.restTemplate.postForObject("https://api.openai.com/v1/chat/completions", (Object)new ChatCompletionRequest(model, chats, temperature, maxTokens), ChatCompletionResponse.class, new Object[0]);
        if (this.shouldCacheResponse(temperature)) {
            this.cache.put((Object)this.createKey(model, chats, maxTokens), (Object)response);
        }
        return response;
    }

    public EmbeddingData embedding(String model, String content) {
        return this.embedding(model, List.of(content)).data().get(0);
    }

    public EmbeddingResponse embedding(String model, List<String> content) {
        Cache.ValueWrapper value;
        if (this.cache != null && (value = this.cache.get((Object)(model + content))) != null) {
            return (EmbeddingResponse)value.get();
        }
        String url = "https://api.openai.com/v1/embeddings";
        EmbeddingResponse response = (EmbeddingResponse)this.restTemplate.postForObject(url, (Object)new EmbeddingRequest(model, content), EmbeddingResponse.class, new Object[0]);
        if (this.cache != null) {
            this.cache.put((Object)(model + content), (Object)response);
        }
        return response;
    }

    private String createKey(String model, List<ChatMessage> chats, int maxTokens) {
        return model + chats + maxTokens;
    }

    private boolean shouldCacheResponse(double temperature) {
        return this.cache != null && Double.compare(temperature, 0.0) == 0;
    }
}

