/*
 * Decompiled with CFR 0.152.
 */
package ai.optfor.springopenaiapi;

import ai.optfor.springopenaiapi.cache.DefaultPromptCache;
import ai.optfor.springopenaiapi.cache.PromptCache;
import ai.optfor.springopenaiapi.model.ChatCompletionRequest;
import ai.optfor.springopenaiapi.model.ChatCompletionResponse;
import ai.optfor.springopenaiapi.model.ChatMessage;
import ai.optfor.springopenaiapi.model.EmbeddingRequest;
import ai.optfor.springopenaiapi.model.EmbeddingResponse;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.ClientHttpRequestInterceptor;
import org.springframework.http.client.SimpleClientHttpRequestFactory;
import org.springframework.web.client.RestTemplate;

public class OpenAIApi {
    private static final Logger log = LoggerFactory.getLogger(OpenAIApi.class);
    private final ObjectMapper mapper = new ObjectMapper();
    private final RestTemplate restTemplate;
    private final PromptCache promptCache;
    private final ExecutorService executorService;

    public OpenAIApi(String openaiKey, RestTemplate restTemplate, PromptCache promptCache) {
        this.restTemplate = restTemplate == null ? new RestTemplate() : restTemplate;
        this.promptCache = promptCache == null ? new DefaultPromptCache() : promptCache;
        SimpleClientHttpRequestFactory requestFactory = new SimpleClientHttpRequestFactory();
        requestFactory.setConnectTimeout(5000);
        requestFactory.setReadTimeout(600000);
        this.restTemplate.setRequestFactory((ClientHttpRequestFactory)requestFactory);
        ClientHttpRequestInterceptor interceptor = (request, body, execution) -> {
            request.getHeaders().add("Authorization", "Bearer " + openaiKey);
            return execution.execute(request, body);
        };
        this.restTemplate.setInterceptors(List.of(interceptor));
        this.mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        this.executorService = Executors.newFixedThreadPool(3);
    }

    public ChatCompletionResponse chat(String model, String prompt, String role, Integer maxTokens, double temperature) {
        return this.chat(model, List.of(ChatMessage.roleMessage(role), ChatMessage.contentMessage(prompt)), maxTokens, temperature);
    }

    public ChatCompletionResponse chat(String model, List<ChatMessage> chats, int maxTokens, double temperature) {
        Future<ChatCompletionResponse> future = this.executorService.submit(() -> this.chatInternal(model, chats, maxTokens, temperature));
        try {
            return future.get();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private ChatCompletionResponse chatInternal(String model, List<ChatMessage> chats, int maxTokens, double temperature) {
        int retryCount = 0;
        while (true) {
            try {
                String cached;
                ChatCompletionRequest request = new ChatCompletionRequest(model, chats, temperature, maxTokens);
                log.info("Sending request to OpenAI API: {}", (Object)this.mapper.writeValueAsString((Object)request));
                if (Double.compare(temperature, 0.0) == 0 && (cached = this.promptCache.get(this.createKey(model, chats, maxTokens))) != null) {
                    ChatCompletionResponse response = (ChatCompletionResponse)this.mapper.readValue(cached, ChatCompletionResponse.class);
                    log.info("Returning cached response: {}", (Object)this.mapper.writeValueAsString((Object)response));
                    return response;
                }
                ChatCompletionResponse response = (ChatCompletionResponse)this.restTemplate.postForObject("https://api.openai.com/v1/chat/completions", (Object)request, ChatCompletionResponse.class, new Object[0]);
                log.info("Received response from OpenAI API: {}", (Object)this.mapper.writeValueAsString((Object)response));
                if (Double.compare(temperature, 0.0) == 0) {
                    this.promptCache.put(this.createKey(model, chats, maxTokens), this.mapper.writeValueAsString((Object)response));
                }
                return response;
            }
            catch (Exception e) {
                if (++retryCount != 3) continue;
                throw new RuntimeException(e);
            }
            break;
        }
    }

    public EmbeddingResponse embedding(String model, String content) {
        return this.embedding(model, List.of(content));
    }

    public EmbeddingResponse embedding(String model, List<String> content) {
        EmbeddingRequest request = new EmbeddingRequest(model, content);
        try {
            log.info("Sending request to OpenAI API: {}", (Object)this.mapper.writeValueAsString((Object)request));
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
        EmbeddingResponse response = (EmbeddingResponse)this.restTemplate.postForObject("https://api.openai.com/v1/embeddings", (Object)request, EmbeddingResponse.class, new Object[0]);
        return response;
    }

    private String createKey(String model, List<ChatMessage> chats, int maxTokens) {
        return model + chats + maxTokens;
    }
}

