/*
 * Decompiled with CFR 0.152.
 */
package ai.optfor.springopenaiapi.model;

import ai.optfor.springopenaiapi.model.ChatChoice;
import ai.optfor.springopenaiapi.model.Usage;
import java.math.BigDecimal;
import java.math.MathContext;
import java.util.List;

public record ChatCompletionResponse(String model, List<ChatChoice> choices, Usage usage) {
    public String getFirstCompletion() {
        return this.choices.get(0).message().content();
    }

    public BigDecimal getCost() {
        int promptLength = this.usage.prompt_tokens();
        int completionLength = this.usage.completion_tokens();
        if (this.model.startsWith("gpt-4")) {
            return this.computeCost(promptLength, "0.03").add(this.computeCost(completionLength, "0.06"));
        }
        if (this.model.startsWith("gpt-3.5-turbo")) {
            return this.computeCost(promptLength, "0.0015").add(this.computeCost(completionLength, "0.002"));
        }
        if (this.model.startsWith("gpt-3.5-turbo-16k")) {
            return this.computeCost(promptLength, "0.003").add(this.computeCost(completionLength, "0.004"));
        }
        return null;
    }

    private BigDecimal computeCost(int promptLength, String costPer1000) {
        return new BigDecimal(costPer1000).multiply(new BigDecimal(promptLength).divide(new BigDecimal(1000), MathContext.DECIMAL32));
    }
}

