/*
 * Decompiled with CFR 0.152.
 */
package ai.optfor.springopenaiapi.model;

import ai.optfor.springopenaiapi.model.ChatChoice;
import ai.optfor.springopenaiapi.model.Usage;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.math.BigDecimal;
import java.math.MathContext;
import java.util.List;

public record ChatCompletionResponse(String model, List<ChatChoice> choices, Usage usage) {
    @JsonIgnore
    public String getFirstCompletion() {
        if (this.choices.get(0).message() != null) {
            return this.choices.get(0).message().content();
        }
        return null;
    }

    @JsonIgnore
    public String getDelta() {
        if (this.choices.get(0).delta() != null) {
            return this.choices.get(0).delta().content();
        }
        return null;
    }

    public BigDecimal getCost() {
        int promptLength = this.usage.prompt_tokens();
        int completionLength = this.usage.completion_tokens();
        if (this.model == null) {
            return BigDecimal.ZERO;
        }
        if (this.model.startsWith("gpt-4")) {
            return this.computeCost(promptLength, "0.03").add(this.computeCost(completionLength, "0.06"));
        }
        if (this.model.startsWith("gpt-3.5-turbo")) {
            return this.computeCost(promptLength, "0.001").add(this.computeCost(completionLength, "0.002"));
        }
        if (this.model.startsWith("gpt-3.5-turbo-16k")) {
            return this.computeCost(promptLength, "0.0015").add(this.computeCost(completionLength, "0.002"));
        }
        if (this.model.startsWith("gpt-4-1106-preview")) {
            return this.computeCost(promptLength, "0.01").add(this.computeCost(completionLength, "0.03"));
        }
        return null;
    }

    private BigDecimal computeCost(int promptLength, String costPer1000) {
        return new BigDecimal(costPer1000).multiply(new BigDecimal(promptLength).divide(new BigDecimal(1000), MathContext.DECIMAL32));
    }
}

