/*
 * Decompiled with CFR 0.152.
 */
package ai.optfor.springopenaiapi.utils;

import ai.optfor.springopenaiapi.enums.LLMModel;
import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;

public class StreamCostEstimate {
    private static final BigDecimal AVERAGE_CHARS_PER_TOKEN = new BigDecimal("3.0315");

    public static BigDecimal estimateCost(LLMModel model, Integer inputLength, Integer outputLength) {
        BigDecimal inputTokens = new BigDecimal(inputLength).divide(AVERAGE_CHARS_PER_TOKEN, MathContext.DECIMAL32);
        BigDecimal outputTokens = new BigDecimal(outputLength).divide(AVERAGE_CHARS_PER_TOKEN, MathContext.DECIMAL32);
        BigDecimal promptCost = new BigDecimal(model.getPromptCost()).multiply(inputTokens.divide(new BigDecimal(1000), MathContext.DECIMAL32)).setScale(4, RoundingMode.HALF_UP);
        BigDecimal completionCost = new BigDecimal(model.getCompletionCost()).multiply(outputTokens.divide(new BigDecimal(1000), MathContext.DECIMAL32)).setScale(4, RoundingMode.HALF_UP);
        return promptCost.add(completionCost);
    }
}

