/*
 * Decompiled with CFR 0.152.
 */
package ai.optfor.springopenaiapi.model;

import ai.optfor.springopenaiapi.enums.LLMModel;
import ai.optfor.springopenaiapi.model.ChatChoice;
import ai.optfor.springopenaiapi.model.Usage;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.micrometer.common.util.StringUtils;
import java.math.BigDecimal;
import java.math.MathContext;
import java.util.List;

public record ChatCompletionResponse(String model, List<ChatChoice> choices, Usage usage) {
    @JsonIgnore
    public String getFirstCompletion() {
        if (this.choices.get(0).message() != null) {
            return this.choices.get(0).message().content();
        }
        return null;
    }

    @JsonIgnore
    public String getDelta() {
        if (this.choices.get(0).delta() != null) {
            return this.choices.get(0).delta().content();
        }
        return null;
    }

    public BigDecimal getCost() {
        int promptLength = this.usage.prompt_tokens();
        int completionLength = this.usage.completion_tokens();
        if (StringUtils.isBlank((String)this.model)) {
            return BigDecimal.ZERO;
        }
        LLMModel modelEnum = LLMModel.apiValueOf(this.model);
        return this.computeCost(promptLength, modelEnum.getPromptCost()).add(this.computeCost(completionLength, modelEnum.getCompletionCost()));
    }

    private BigDecimal computeCost(int length, String costPer1000) {
        return new BigDecimal(costPer1000).multiply(new BigDecimal(length).divide(new BigDecimal(1000), MathContext.DECIMAL32));
    }
}

