/*
 * Decompiled with CFR 0.152.
 */
package ai.philterd.phileas.services;

import ai.philterd.phileas.model.configuration.PhileasConfiguration;
import ai.philterd.phileas.model.enums.FilterType;
import ai.philterd.phileas.model.enums.SensitivityLevel;
import ai.philterd.phileas.model.filter.Filter;
import ai.philterd.phileas.model.filter.FilterConfiguration;
import ai.philterd.phileas.model.filter.rules.dictionary.BloomFilterDictionaryFilter;
import ai.philterd.phileas.model.filter.rules.dictionary.FuzzyDictionaryFilter;
import ai.philterd.phileas.model.filter.rules.regex.RegexFilter;
import ai.philterd.phileas.model.policy.Policy;
import ai.philterd.phileas.model.policy.filters.CustomDictionary;
import ai.philterd.phileas.model.policy.filters.Identifier;
import ai.philterd.phileas.model.policy.filters.Section;
import ai.philterd.phileas.model.services.AlertService;
import ai.philterd.phileas.model.services.AnonymizationService;
import ai.philterd.phileas.model.services.CacheService;
import ai.philterd.phileas.model.services.MetricsService;
import ai.philterd.phileas.model.services.SpanValidator;
import ai.philterd.phileas.services.anonymization.AgeAnonymizationService;
import ai.philterd.phileas.services.anonymization.AlphanumericAnonymizationService;
import ai.philterd.phileas.services.anonymization.BitcoinAddressAnonymizationService;
import ai.philterd.phileas.services.anonymization.CityAnonymizationService;
import ai.philterd.phileas.services.anonymization.CountyAnonymizationService;
import ai.philterd.phileas.services.anonymization.CreditCardAnonymizationService;
import ai.philterd.phileas.services.anonymization.CurrencyAnonymizationService;
import ai.philterd.phileas.services.anonymization.DateAnonymizationService;
import ai.philterd.phileas.services.anonymization.EmailAddressAnonymizationService;
import ai.philterd.phileas.services.anonymization.HospitalAbbreviationAnonymizationService;
import ai.philterd.phileas.services.anonymization.HospitalAnonymizationService;
import ai.philterd.phileas.services.anonymization.IbanCodeAnonymizationService;
import ai.philterd.phileas.services.anonymization.IpAddressAnonymizationService;
import ai.philterd.phileas.services.anonymization.MacAddressAnonymizationService;
import ai.philterd.phileas.services.anonymization.PassportNumberAnonymizationService;
import ai.philterd.phileas.services.anonymization.PersonsAnonymizationService;
import ai.philterd.phileas.services.anonymization.StateAbbreviationAnonymizationService;
import ai.philterd.phileas.services.anonymization.StateAnonymizationService;
import ai.philterd.phileas.services.anonymization.StreetAddressAnonymizationService;
import ai.philterd.phileas.services.anonymization.SurnameAnonymizationService;
import ai.philterd.phileas.services.anonymization.UrlAnonymizationService;
import ai.philterd.phileas.services.anonymization.ZipCodeAnonymizationService;
import ai.philterd.phileas.services.filters.ai.pheye.PhEyeConfiguration;
import ai.philterd.phileas.services.filters.ai.pheye.PhEyeFilter;
import ai.philterd.phileas.services.filters.custom.PhoneNumberRulesFilter;
import ai.philterd.phileas.services.filters.regex.AgeFilter;
import ai.philterd.phileas.services.filters.regex.BankRoutingNumberFilter;
import ai.philterd.phileas.services.filters.regex.BitcoinAddressFilter;
import ai.philterd.phileas.services.filters.regex.CreditCardFilter;
import ai.philterd.phileas.services.filters.regex.CurrencyFilter;
import ai.philterd.phileas.services.filters.regex.DateFilter;
import ai.philterd.phileas.services.filters.regex.DriversLicenseFilter;
import ai.philterd.phileas.services.filters.regex.EmailAddressFilter;
import ai.philterd.phileas.services.filters.regex.IbanCodeFilter;
import ai.philterd.phileas.services.filters.regex.IdentifierFilter;
import ai.philterd.phileas.services.filters.regex.IpAddressFilter;
import ai.philterd.phileas.services.filters.regex.MacAddressFilter;
import ai.philterd.phileas.services.filters.regex.PassportNumberFilter;
import ai.philterd.phileas.services.filters.regex.PhoneNumberExtensionFilter;
import ai.philterd.phileas.services.filters.regex.PhysicianNameFilter;
import ai.philterd.phileas.services.filters.regex.SectionFilter;
import ai.philterd.phileas.services.filters.regex.SsnFilter;
import ai.philterd.phileas.services.filters.regex.StateAbbreviationFilter;
import ai.philterd.phileas.services.filters.regex.StreetAddressFilter;
import ai.philterd.phileas.services.filters.regex.TrackingNumberFilter;
import ai.philterd.phileas.services.filters.regex.UrlFilter;
import ai.philterd.phileas.services.filters.regex.VinFilter;
import ai.philterd.phileas.services.filters.regex.ZipCodeFilter;
import ai.philterd.phileas.services.validators.DateSpanValidator;
import java.io.File;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.math3.stat.descriptive.DescriptiveStatistics;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FilterPolicyLoader {
    private static final Logger LOGGER = LogManager.getLogger(FilterPolicyLoader.class);
    private final CacheService anonymizationCacheService;
    private final AlertService alertService;
    private final MetricsService metricsService;
    private final Map<String, DescriptiveStatistics> stats;
    private final PhileasConfiguration phileasConfiguration;

    public FilterPolicyLoader(AlertService alertService, CacheService anonymizationCacheService, MetricsService metricsService, Map<String, DescriptiveStatistics> stats, PhileasConfiguration phileasConfiguration) {
        this.alertService = alertService;
        this.anonymizationCacheService = anonymizationCacheService;
        this.metricsService = metricsService;
        this.stats = new HashMap<String, DescriptiveStatistics>();
        this.phileasConfiguration = phileasConfiguration;
    }

    public List<Filter> getFiltersForPolicy(Policy policy, Map<String, Map<FilterType, Filter>> filterCache) throws Exception {
        RegexFilter filter;
        RegexFilter filter2;
        Object filterConfiguration;
        int windowSize;
        LOGGER.debug("Getting filters for policy [{}]", (Object)policy.getName());
        filterCache.putIfAbsent(policy.getName(), new ConcurrentHashMap());
        Map<FilterType, Filter> cache = filterCache.get(policy.getName());
        LinkedList<Filter> enabledFilters = new LinkedList<Filter>();
        if (policy.getIdentifiers().hasFilter(FilterType.AGE) && policy.getIdentifiers().getAge().isEnabled()) {
            if (cache.containsKey(FilterType.AGE)) {
                enabledFilters.add(cache.get(FilterType.AGE));
            } else {
                windowSize = policy.getIdentifiers().getAge().getWindowSizeOrDefault(this.phileasConfiguration.spanWindowSize());
                filterConfiguration = new FilterConfiguration.FilterConfigurationBuilder().withStrategies(policy.getIdentifiers().getAge().getAgeFilterStrategies()).withAnonymizationService((AnonymizationService)new AgeAnonymizationService(this.anonymizationCacheService)).withAlertService(this.alertService).withIgnored(policy.getIdentifiers().getAge().getIgnored()).withIgnoredFiles(policy.getIdentifiers().getAge().getIgnoredFiles()).withIgnoredPatterns(policy.getIdentifiers().getAge().getIgnoredPatterns()).withCrypto(policy.getCrypto()).withWindowSize(windowSize).withPriority(policy.getIdentifiers().getAge().getPriority()).build();
                filter2 = new AgeFilter((FilterConfiguration)filterConfiguration);
                enabledFilters.add((Filter)filter2);
                filterCache.get(policy.getName()).put(FilterType.AGE, (Filter)filter2);
            }
        }
        if (policy.getIdentifiers().hasFilter(FilterType.BANK_ROUTING_NUMBER) && policy.getIdentifiers().getBankRoutingNumber().isEnabled()) {
            if (cache.containsKey(FilterType.BANK_ROUTING_NUMBER)) {
                enabledFilters.add(cache.get(FilterType.BANK_ROUTING_NUMBER));
            } else {
                windowSize = policy.getIdentifiers().getBankRoutingNumber().getWindowSizeOrDefault(this.phileasConfiguration.spanWindowSize());
                filterConfiguration = new FilterConfiguration.FilterConfigurationBuilder().withStrategies(policy.getIdentifiers().getBankRoutingNumber().getBankRoutingNumberFilterStrategies()).withAnonymizationService((AnonymizationService)new AlphanumericAnonymizationService(this.anonymizationCacheService)).withAlertService(this.alertService).withIgnored(policy.getIdentifiers().getBankRoutingNumber().getIgnored()).withIgnoredFiles(policy.getIdentifiers().getBankRoutingNumber().getIgnoredFiles()).withIgnoredPatterns(policy.getIdentifiers().getBankRoutingNumber().getIgnoredPatterns()).withCrypto(policy.getCrypto()).withFPE(policy.getFpe()).withWindowSize(windowSize).withPriority(policy.getIdentifiers().getBankRoutingNumber().getPriority()).build();
                filter2 = new BankRoutingNumberFilter((FilterConfiguration)filterConfiguration);
                enabledFilters.add((Filter)filter2);
                filterCache.get(policy.getName()).put(FilterType.BANK_ROUTING_NUMBER, (Filter)filter2);
            }
        }
        if (policy.getIdentifiers().hasFilter(FilterType.BITCOIN_ADDRESS) && policy.getIdentifiers().getBitcoinAddress().isEnabled()) {
            if (cache.containsKey(FilterType.BITCOIN_ADDRESS)) {
                enabledFilters.add(cache.get(FilterType.BITCOIN_ADDRESS));
            } else {
                windowSize = policy.getIdentifiers().getBitcoinAddress().getWindowSizeOrDefault(this.phileasConfiguration.spanWindowSize());
                filterConfiguration = new FilterConfiguration.FilterConfigurationBuilder().withStrategies(policy.getIdentifiers().getBitcoinAddress().getBitcoinFilterStrategies()).withAnonymizationService((AnonymizationService)new BitcoinAddressAnonymizationService(this.anonymizationCacheService)).withAlertService(this.alertService).withIgnored(policy.getIdentifiers().getBitcoinAddress().getIgnored()).withIgnoredFiles(policy.getIdentifiers().getBitcoinAddress().getIgnoredFiles()).withIgnoredPatterns(policy.getIdentifiers().getBitcoinAddress().getIgnoredPatterns()).withCrypto(policy.getCrypto()).withFPE(policy.getFpe()).withWindowSize(windowSize).withPriority(policy.getIdentifiers().getBitcoinAddress().getPriority()).build();
                filter2 = new BitcoinAddressFilter((FilterConfiguration)filterConfiguration);
                enabledFilters.add((Filter)filter2);
                filterCache.get(policy.getName()).put(FilterType.BITCOIN_ADDRESS, (Filter)filter2);
            }
        }
        if (policy.getIdentifiers().hasFilter(FilterType.CREDIT_CARD) && policy.getIdentifiers().getCreditCard().isEnabled()) {
            if (cache.containsKey(FilterType.CREDIT_CARD)) {
                enabledFilters.add(cache.get(FilterType.CREDIT_CARD));
            } else {
                windowSize = policy.getIdentifiers().getCreditCard().getWindowSizeOrDefault(this.phileasConfiguration.spanWindowSize());
                filterConfiguration = new FilterConfiguration.FilterConfigurationBuilder().withStrategies(policy.getIdentifiers().getCreditCard().getCreditCardFilterStrategies()).withAnonymizationService((AnonymizationService)new CreditCardAnonymizationService(this.anonymizationCacheService)).withAlertService(this.alertService).withIgnored(policy.getIdentifiers().getCreditCard().getIgnored()).withIgnoredFiles(policy.getIdentifiers().getCreditCard().getIgnoredFiles()).withIgnoredPatterns(policy.getIdentifiers().getCreditCard().getIgnoredPatterns()).withCrypto(policy.getCrypto()).withFPE(policy.getFpe()).withWindowSize(windowSize).withPriority(policy.getIdentifiers().getCreditCard().getPriority()).build();
                boolean onlyValidCreditCardNumbers = policy.getIdentifiers().getCreditCard().isOnlyValidCreditCardNumbers();
                boolean ignoreWhenInUnixTimestamp = policy.getIdentifiers().getCreditCard().isIgnoreWhenInUnixTimestamp();
                boolean onlyWordBoundaries = policy.getIdentifiers().getCreditCard().isOnlyWordBoundaries();
                filter = new CreditCardFilter((FilterConfiguration)filterConfiguration, onlyValidCreditCardNumbers, ignoreWhenInUnixTimestamp, onlyWordBoundaries);
                enabledFilters.add((Filter)filter);
                filterCache.get(policy.getName()).put(FilterType.CREDIT_CARD, (Filter)filter);
            }
        }
        if (policy.getIdentifiers().hasFilter(FilterType.CURRENCY) && policy.getIdentifiers().getCurrency().isEnabled()) {
            if (cache.containsKey(FilterType.CURRENCY)) {
                enabledFilters.add(cache.get(FilterType.CURRENCY));
            } else {
                windowSize = policy.getIdentifiers().getCurrency().getWindowSizeOrDefault(this.phileasConfiguration.spanWindowSize());
                filterConfiguration = new FilterConfiguration.FilterConfigurationBuilder().withStrategies(policy.getIdentifiers().getCurrency().getCurrencyFilterStrategies()).withAnonymizationService((AnonymizationService)new CurrencyAnonymizationService(this.anonymizationCacheService)).withAlertService(this.alertService).withIgnored(policy.getIdentifiers().getCurrency().getIgnored()).withIgnoredFiles(policy.getIdentifiers().getCurrency().getIgnoredFiles()).withIgnoredPatterns(policy.getIdentifiers().getCurrency().getIgnoredPatterns()).withCrypto(policy.getCrypto()).withWindowSize(windowSize).withPriority(policy.getIdentifiers().getCurrency().getPriority()).build();
                CurrencyFilter filter3 = new CurrencyFilter((FilterConfiguration)filterConfiguration);
                enabledFilters.add((Filter)filter3);
                filterCache.get(policy.getName()).put(FilterType.CURRENCY, (Filter)filter3);
            }
        }
        if (policy.getIdentifiers().hasFilter(FilterType.DATE) && policy.getIdentifiers().getDate().isEnabled()) {
            if (cache.containsKey(FilterType.DATE)) {
                enabledFilters.add(cache.get(FilterType.DATE));
            } else {
                windowSize = policy.getIdentifiers().getDate().getWindowSizeOrDefault(this.phileasConfiguration.spanWindowSize());
                filterConfiguration = new FilterConfiguration.FilterConfigurationBuilder().withStrategies(policy.getIdentifiers().getDate().getDateFilterStrategies()).withAnonymizationService((AnonymizationService)new DateAnonymizationService(this.anonymizationCacheService)).withAlertService(this.alertService).withIgnored(policy.getIdentifiers().getDate().getIgnored()).withIgnoredFiles(policy.getIdentifiers().getDate().getIgnoredFiles()).withIgnoredPatterns(policy.getIdentifiers().getDate().getIgnoredPatterns()).withCrypto(policy.getCrypto()).withWindowSize(windowSize).withPriority(policy.getIdentifiers().getDate().getPriority()).build();
                boolean onlyValidDates = policy.getIdentifiers().getDate().isOnlyValidDates();
                SpanValidator dateSpanValidator = DateSpanValidator.getInstance();
                DateFilter filter4 = new DateFilter((FilterConfiguration)filterConfiguration, onlyValidDates, dateSpanValidator);
                enabledFilters.add((Filter)filter4);
                filterCache.get(policy.getName()).put(FilterType.DATE, (Filter)filter4);
            }
        }
        if (policy.getIdentifiers().hasFilter(FilterType.DRIVERS_LICENSE_NUMBER) && policy.getIdentifiers().getDriversLicense().isEnabled()) {
            if (cache.containsKey(FilterType.DRIVERS_LICENSE_NUMBER)) {
                enabledFilters.add(cache.get(FilterType.DRIVERS_LICENSE_NUMBER));
            } else {
                windowSize = policy.getIdentifiers().getDriversLicense().getWindowSizeOrDefault(this.phileasConfiguration.spanWindowSize());
                filterConfiguration = new FilterConfiguration.FilterConfigurationBuilder().withStrategies(policy.getIdentifiers().getDriversLicense().getDriversLicenseFilterStrategies()).withAnonymizationService((AnonymizationService)new AlphanumericAnonymizationService(this.anonymizationCacheService)).withAlertService(this.alertService).withIgnored(policy.getIdentifiers().getDriversLicense().getIgnored()).withIgnoredFiles(policy.getIdentifiers().getDriversLicense().getIgnoredFiles()).withIgnoredPatterns(policy.getIdentifiers().getDriversLicense().getIgnoredPatterns()).withCrypto(policy.getCrypto()).withFPE(policy.getFpe()).withWindowSize(windowSize).withPriority(policy.getIdentifiers().getDriversLicense().getPriority()).build();
                DriversLicenseFilter filter5 = new DriversLicenseFilter((FilterConfiguration)filterConfiguration);
                enabledFilters.add((Filter)filter5);
                filterCache.get(policy.getName()).put(FilterType.DRIVERS_LICENSE_NUMBER, (Filter)filter5);
            }
        }
        if (policy.getIdentifiers().hasFilter(FilterType.EMAIL_ADDRESS) && policy.getIdentifiers().getEmailAddress().isEnabled()) {
            if (cache.containsKey(FilterType.EMAIL_ADDRESS)) {
                enabledFilters.add(cache.get(FilterType.EMAIL_ADDRESS));
            } else {
                windowSize = policy.getIdentifiers().getEmailAddress().getWindowSizeOrDefault(this.phileasConfiguration.spanWindowSize());
                filterConfiguration = new FilterConfiguration.FilterConfigurationBuilder().withStrategies(policy.getIdentifiers().getEmailAddress().getEmailAddressFilterStrategies()).withAnonymizationService((AnonymizationService)new EmailAddressAnonymizationService(this.anonymizationCacheService)).withAlertService(this.alertService).withIgnored(policy.getIdentifiers().getEmailAddress().getIgnored()).withIgnoredFiles(policy.getIdentifiers().getEmailAddress().getIgnoredFiles()).withIgnoredPatterns(policy.getIdentifiers().getEmailAddress().getIgnoredPatterns()).withCrypto(policy.getCrypto()).withWindowSize(windowSize).withPriority(policy.getIdentifiers().getEmailAddress().getPriority()).build();
                boolean isStrict = policy.getIdentifiers().getEmailAddress().isOnlyStrictMatches();
                boolean onlyValidTLDs = policy.getIdentifiers().getEmailAddress().isOnlyValidTLDs();
                EmailAddressFilter filter6 = new EmailAddressFilter((FilterConfiguration)filterConfiguration, isStrict, onlyValidTLDs);
                enabledFilters.add((Filter)filter6);
                filterCache.get(policy.getName()).put(FilterType.EMAIL_ADDRESS, (Filter)filter6);
            }
        }
        if (policy.getIdentifiers().hasFilter(FilterType.IBAN_CODE) && policy.getIdentifiers().getIbanCode().isEnabled()) {
            if (cache.containsKey(FilterType.IBAN_CODE)) {
                enabledFilters.add(cache.get(FilterType.IBAN_CODE));
            } else {
                windowSize = policy.getIdentifiers().getIbanCode().getWindowSizeOrDefault(this.phileasConfiguration.spanWindowSize());
                filterConfiguration = new FilterConfiguration.FilterConfigurationBuilder().withStrategies(policy.getIdentifiers().getIbanCode().getIbanCodeFilterStrategies()).withAnonymizationService((AnonymizationService)new IbanCodeAnonymizationService(this.anonymizationCacheService)).withAlertService(this.alertService).withIgnored(policy.getIdentifiers().getIbanCode().getIgnored()).withIgnoredFiles(policy.getIdentifiers().getIbanCode().getIgnoredFiles()).withIgnoredPatterns(policy.getIdentifiers().getIbanCode().getIgnoredPatterns()).withCrypto(policy.getCrypto()).withFPE(policy.getFpe()).withWindowSize(windowSize).withPriority(policy.getIdentifiers().getIbanCode().getPriority()).build();
                boolean onlyValidIBANCodes = policy.getIdentifiers().getIbanCode().isOnlyValidIBANCodes();
                boolean allowSpaces = policy.getIdentifiers().getIbanCode().isAllowSpaces();
                IbanCodeFilter filter7 = new IbanCodeFilter((FilterConfiguration)filterConfiguration, onlyValidIBANCodes, allowSpaces);
                enabledFilters.add((Filter)filter7);
                filterCache.get(policy.getName()).put(FilterType.IBAN_CODE, (Filter)filter7);
            }
        }
        if (policy.getIdentifiers().hasFilter(FilterType.IP_ADDRESS) && policy.getIdentifiers().getIpAddress().isEnabled()) {
            if (cache.containsKey(FilterType.IP_ADDRESS)) {
                enabledFilters.add(cache.get(FilterType.IP_ADDRESS));
            } else {
                windowSize = policy.getIdentifiers().getIpAddress().getWindowSizeOrDefault(this.phileasConfiguration.spanWindowSize());
                filterConfiguration = new FilterConfiguration.FilterConfigurationBuilder().withStrategies(policy.getIdentifiers().getIpAddress().getIpAddressFilterStrategies()).withAnonymizationService((AnonymizationService)new IpAddressAnonymizationService(this.anonymizationCacheService)).withAlertService(this.alertService).withIgnored(policy.getIdentifiers().getIpAddress().getIgnored()).withIgnoredFiles(policy.getIdentifiers().getIpAddress().getIgnoredFiles()).withIgnoredPatterns(policy.getIdentifiers().getIpAddress().getIgnoredPatterns()).withCrypto(policy.getCrypto()).withWindowSize(windowSize).withPriority(policy.getIdentifiers().getIpAddress().getPriority()).build();
                IpAddressFilter filter8 = new IpAddressFilter((FilterConfiguration)filterConfiguration);
                enabledFilters.add((Filter)filter8);
                filterCache.get(policy.getName()).put(FilterType.IP_ADDRESS, (Filter)filter8);
            }
        }
        if (policy.getIdentifiers().hasFilter(FilterType.MAC_ADDRESS) && policy.getIdentifiers().getMacAddress().isEnabled()) {
            if (cache.containsKey(FilterType.MAC_ADDRESS)) {
                enabledFilters.add(cache.get(FilterType.MAC_ADDRESS));
            } else {
                windowSize = policy.getIdentifiers().getMacAddress().getWindowSizeOrDefault(this.phileasConfiguration.spanWindowSize());
                filterConfiguration = new FilterConfiguration.FilterConfigurationBuilder().withStrategies(policy.getIdentifiers().getMacAddress().getMacAddressFilterStrategies()).withAnonymizationService((AnonymizationService)new MacAddressAnonymizationService(this.anonymizationCacheService)).withAlertService(this.alertService).withIgnored(policy.getIdentifiers().getMacAddress().getIgnored()).withIgnoredFiles(policy.getIdentifiers().getMacAddress().getIgnoredFiles()).withIgnoredPatterns(policy.getIdentifiers().getMacAddress().getIgnoredPatterns()).withCrypto(policy.getCrypto()).withWindowSize(windowSize).withPriority(policy.getIdentifiers().getMacAddress().getPriority()).build();
                MacAddressFilter filter9 = new MacAddressFilter((FilterConfiguration)filterConfiguration);
                enabledFilters.add((Filter)filter9);
                filterCache.get(policy.getName()).put(FilterType.MAC_ADDRESS, (Filter)filter9);
            }
        }
        if (policy.getIdentifiers().hasFilter(FilterType.PASSPORT_NUMBER) && policy.getIdentifiers().getPassportNumber().isEnabled()) {
            if (cache.containsKey(FilterType.PASSPORT_NUMBER)) {
                enabledFilters.add(cache.get(FilterType.PASSPORT_NUMBER));
            } else {
                windowSize = policy.getIdentifiers().getPassportNumber().getWindowSizeOrDefault(this.phileasConfiguration.spanWindowSize());
                filterConfiguration = new FilterConfiguration.FilterConfigurationBuilder().withStrategies(policy.getIdentifiers().getPassportNumber().getPassportNumberFilterStrategies()).withAnonymizationService((AnonymizationService)new PassportNumberAnonymizationService(this.anonymizationCacheService)).withAlertService(this.alertService).withIgnored(policy.getIdentifiers().getPassportNumber().getIgnored()).withIgnoredFiles(policy.getIdentifiers().getPassportNumber().getIgnoredFiles()).withIgnoredPatterns(policy.getIdentifiers().getPassportNumber().getIgnoredPatterns()).withCrypto(policy.getCrypto()).withFPE(policy.getFpe()).withWindowSize(windowSize).withPriority(policy.getIdentifiers().getPassportNumber().getPriority()).build();
                PassportNumberFilter filter10 = new PassportNumberFilter((FilterConfiguration)filterConfiguration);
                enabledFilters.add((Filter)filter10);
                filterCache.get(policy.getName()).put(FilterType.PASSPORT_NUMBER, (Filter)filter10);
            }
        }
        if (policy.getIdentifiers().hasFilter(FilterType.PHONE_NUMBER_EXTENSION) && policy.getIdentifiers().getPhoneNumberExtension().isEnabled()) {
            if (cache.containsKey(FilterType.PHONE_NUMBER_EXTENSION)) {
                enabledFilters.add(cache.get(FilterType.PHONE_NUMBER_EXTENSION));
            } else {
                windowSize = policy.getIdentifiers().getPhoneNumberExtension().getWindowSizeOrDefault(this.phileasConfiguration.spanWindowSize());
                filterConfiguration = new FilterConfiguration.FilterConfigurationBuilder().withStrategies(policy.getIdentifiers().getPhoneNumberExtension().getPhoneNumberExtensionFilterStrategies()).withAnonymizationService((AnonymizationService)new AlphanumericAnonymizationService(this.anonymizationCacheService)).withAlertService(this.alertService).withIgnored(policy.getIdentifiers().getPhoneNumberExtension().getIgnored()).withIgnoredFiles(policy.getIdentifiers().getPhoneNumberExtension().getIgnoredFiles()).withIgnoredPatterns(policy.getIdentifiers().getPhoneNumberExtension().getIgnoredPatterns()).withCrypto(policy.getCrypto()).withWindowSize(windowSize).withPriority(policy.getIdentifiers().getPhoneNumberExtension().getPriority()).build();
                PhoneNumberExtensionFilter filter11 = new PhoneNumberExtensionFilter((FilterConfiguration)filterConfiguration);
                enabledFilters.add((Filter)filter11);
                filterCache.get(policy.getName()).put(FilterType.PHONE_NUMBER_EXTENSION, (Filter)filter11);
            }
        }
        if (policy.getIdentifiers().hasFilter(FilterType.PHONE_NUMBER) && policy.getIdentifiers().getPhoneNumber().isEnabled()) {
            if (cache.containsKey(FilterType.PHONE_NUMBER)) {
                enabledFilters.add(cache.get(FilterType.PHONE_NUMBER));
            } else {
                windowSize = policy.getIdentifiers().getPhoneNumber().getWindowSizeOrDefault(this.phileasConfiguration.spanWindowSize());
                filterConfiguration = new FilterConfiguration.FilterConfigurationBuilder().withStrategies(policy.getIdentifiers().getPhoneNumber().getPhoneNumberFilterStrategies()).withAnonymizationService((AnonymizationService)new AlphanumericAnonymizationService(this.anonymizationCacheService)).withAlertService(this.alertService).withIgnored(policy.getIdentifiers().getPhoneNumber().getIgnored()).withIgnoredFiles(policy.getIdentifiers().getPhoneNumber().getIgnoredFiles()).withIgnoredPatterns(policy.getIdentifiers().getPhoneNumber().getIgnoredPatterns()).withCrypto(policy.getCrypto()).withWindowSize(windowSize).withPriority(policy.getIdentifiers().getPhoneNumber().getPriority()).build();
                PhoneNumberRulesFilter filter12 = new PhoneNumberRulesFilter((FilterConfiguration)filterConfiguration);
                enabledFilters.add((Filter)filter12);
                filterCache.get(policy.getName()).put(FilterType.PHONE_NUMBER, (Filter)filter12);
            }
        }
        if (policy.getIdentifiers().hasFilter(FilterType.PHYSICIAN_NAME) && policy.getIdentifiers().getPhysicianName().isEnabled()) {
            if (cache.containsKey(FilterType.PHYSICIAN_NAME)) {
                enabledFilters.add(cache.get(FilterType.PHYSICIAN_NAME));
            } else {
                windowSize = policy.getIdentifiers().getPhysicianName().getWindowSizeOrDefault(this.phileasConfiguration.spanWindowSize());
                filterConfiguration = new FilterConfiguration.FilterConfigurationBuilder().withStrategies(policy.getIdentifiers().getPhysicianName().getPhysicianNameFilterStrategies()).withAnonymizationService((AnonymizationService)new PersonsAnonymizationService(this.anonymizationCacheService)).withAlertService(this.alertService).withIgnored(policy.getIdentifiers().getPhysicianName().getIgnored()).withIgnoredFiles(policy.getIdentifiers().getPhysicianName().getIgnoredFiles()).withIgnoredPatterns(policy.getIdentifiers().getPhysicianName().getIgnoredPatterns()).withCrypto(policy.getCrypto()).withWindowSize(windowSize).withPriority(policy.getIdentifiers().getPhysicianName().getPriority()).build();
                PhysicianNameFilter filter13 = new PhysicianNameFilter((FilterConfiguration)filterConfiguration);
                enabledFilters.add((Filter)filter13);
                filterCache.get(policy.getName()).put(FilterType.PHYSICIAN_NAME, (Filter)filter13);
            }
        }
        if (policy.getIdentifiers().hasFilter(FilterType.SECTION)) {
            List sections = policy.getIdentifiers().getSections();
            for (Section section : sections) {
                if (!section.isEnabled()) continue;
                int windowSize2 = section.getWindowSizeOrDefault(this.phileasConfiguration.spanWindowSize());
                FilterConfiguration filterConfiguration2 = new FilterConfiguration.FilterConfigurationBuilder().withStrategies(section.getSectionFilterStrategies()).withAnonymizationService((AnonymizationService)new AlphanumericAnonymizationService(this.anonymizationCacheService)).withAlertService(this.alertService).withIgnored(section.getIgnored()).withIgnoredFiles(section.getIgnoredFiles()).withIgnoredPatterns(section.getIgnoredPatterns()).withCrypto(policy.getCrypto()).withWindowSize(windowSize2).withPriority(section.getPriority()).build();
                String startPattern = section.getStartPattern();
                String endPattern = section.getEndPattern();
                enabledFilters.add((Filter)new SectionFilter(filterConfiguration2, startPattern, endPattern));
            }
        }
        if (policy.getIdentifiers().hasFilter(FilterType.SSN) && policy.getIdentifiers().getSsn().isEnabled()) {
            if (cache.containsKey(FilterType.SSN)) {
                enabledFilters.add(cache.get(FilterType.SSN));
            } else {
                int windowSize3 = policy.getIdentifiers().getSsn().getWindowSizeOrDefault(this.phileasConfiguration.spanWindowSize());
                filterConfiguration = new FilterConfiguration.FilterConfigurationBuilder().withStrategies(policy.getIdentifiers().getSsn().getSsnFilterStrategies()).withAnonymizationService((AnonymizationService)new AlphanumericAnonymizationService(this.anonymizationCacheService)).withAlertService(this.alertService).withIgnored(policy.getIdentifiers().getSsn().getIgnored()).withIgnoredFiles(policy.getIdentifiers().getSsn().getIgnoredFiles()).withIgnoredPatterns(policy.getIdentifiers().getSsn().getIgnoredPatterns()).withCrypto(policy.getCrypto()).withFPE(policy.getFpe()).withWindowSize(windowSize3).withPriority(policy.getIdentifiers().getSsn().getPriority()).build();
                SsnFilter filter14 = new SsnFilter((FilterConfiguration)filterConfiguration);
                enabledFilters.add((Filter)filter14);
                filterCache.get(policy.getName()).put(FilterType.SSN, (Filter)filter14);
            }
        }
        if (policy.getIdentifiers().hasFilter(FilterType.STATE_ABBREVIATION) && policy.getIdentifiers().getStateAbbreviation().isEnabled()) {
            if (cache.containsKey(FilterType.STATE_ABBREVIATION)) {
                enabledFilters.add(cache.get(FilterType.STATE_ABBREVIATION));
            } else {
                int windowSize4 = policy.getIdentifiers().getStateAbbreviation().getWindowSizeOrDefault(this.phileasConfiguration.spanWindowSize());
                filterConfiguration = new FilterConfiguration.FilterConfigurationBuilder().withStrategies(policy.getIdentifiers().getStateAbbreviation().getStateAbbreviationsFilterStrategies()).withAnonymizationService((AnonymizationService)new StateAbbreviationAnonymizationService(this.anonymizationCacheService)).withAlertService(this.alertService).withIgnored(policy.getIdentifiers().getStateAbbreviation().getIgnored()).withIgnoredFiles(policy.getIdentifiers().getStateAbbreviation().getIgnoredFiles()).withIgnoredPatterns(policy.getIdentifiers().getStateAbbreviation().getIgnoredPatterns()).withCrypto(policy.getCrypto()).withWindowSize(windowSize4).withPriority(policy.getIdentifiers().getStateAbbreviation().getPriority()).build();
                StateAbbreviationFilter filter15 = new StateAbbreviationFilter((FilterConfiguration)filterConfiguration);
                enabledFilters.add((Filter)filter15);
                filterCache.get(policy.getName()).put(FilterType.STATE_ABBREVIATION, (Filter)filter15);
            }
        }
        if (policy.getIdentifiers().hasFilter(FilterType.STREET_ADDRESS) && policy.getIdentifiers().getStreetAddress().isEnabled()) {
            if (cache.containsKey(FilterType.STREET_ADDRESS)) {
                enabledFilters.add(cache.get(FilterType.STREET_ADDRESS));
            } else {
                int windowSize5 = policy.getIdentifiers().getStreetAddress().getWindowSizeOrDefault(this.phileasConfiguration.spanWindowSize());
                filterConfiguration = new FilterConfiguration.FilterConfigurationBuilder().withStrategies(policy.getIdentifiers().getStreetAddress().getStreetAddressFilterStrategies()).withAnonymizationService((AnonymizationService)new StreetAddressAnonymizationService(this.anonymizationCacheService)).withAlertService(this.alertService).withIgnored(policy.getIdentifiers().getStreetAddress().getIgnored()).withIgnoredFiles(policy.getIdentifiers().getStreetAddress().getIgnoredFiles()).withIgnoredPatterns(policy.getIdentifiers().getStreetAddress().getIgnoredPatterns()).withCrypto(policy.getCrypto()).withWindowSize(windowSize5).withPriority(policy.getIdentifiers().getStreetAddress().getPriority()).build();
                StreetAddressFilter filter16 = new StreetAddressFilter((FilterConfiguration)filterConfiguration);
                enabledFilters.add((Filter)filter16);
                filterCache.get(policy.getName()).put(FilterType.STREET_ADDRESS, (Filter)filter16);
            }
        }
        if (policy.getIdentifiers().hasFilter(FilterType.TRACKING_NUMBER) && policy.getIdentifiers().getTrackingNumber().isEnabled()) {
            if (cache.containsKey(FilterType.TRACKING_NUMBER)) {
                enabledFilters.add(cache.get(FilterType.TRACKING_NUMBER));
            } else {
                int windowSize6 = policy.getIdentifiers().getTrackingNumber().getWindowSizeOrDefault(this.phileasConfiguration.spanWindowSize());
                filterConfiguration = new FilterConfiguration.FilterConfigurationBuilder().withStrategies(policy.getIdentifiers().getTrackingNumber().getTrackingNumberFilterStrategies()).withAnonymizationService((AnonymizationService)new AlphanumericAnonymizationService(this.anonymizationCacheService)).withAlertService(this.alertService).withIgnored(policy.getIdentifiers().getTrackingNumber().getIgnored()).withIgnoredFiles(policy.getIdentifiers().getTrackingNumber().getIgnoredFiles()).withIgnoredPatterns(policy.getIdentifiers().getTrackingNumber().getIgnoredPatterns()).withCrypto(policy.getCrypto()).withFPE(policy.getFpe()).withWindowSize(windowSize6).withPriority(policy.getIdentifiers().getTrackingNumber().getPriority()).build();
                boolean ups = policy.getIdentifiers().getTrackingNumber().isUps();
                boolean fedex = policy.getIdentifiers().getTrackingNumber().isFedex();
                boolean usps = policy.getIdentifiers().getTrackingNumber().isUsps();
                filter = new TrackingNumberFilter((FilterConfiguration)filterConfiguration, ups, fedex, usps);
                enabledFilters.add((Filter)filter);
                filterCache.get(policy.getName()).put(FilterType.TRACKING_NUMBER, (Filter)filter);
            }
        }
        if (policy.getIdentifiers().hasFilter(FilterType.URL) && policy.getIdentifiers().getUrl().isEnabled()) {
            if (cache.containsKey(FilterType.URL)) {
                enabledFilters.add(cache.get(FilterType.URL));
            } else {
                int windowSize7 = policy.getIdentifiers().getUrl().getWindowSizeOrDefault(this.phileasConfiguration.spanWindowSize());
                filterConfiguration = new FilterConfiguration.FilterConfigurationBuilder().withStrategies(policy.getIdentifiers().getUrl().getUrlFilterStrategies()).withAnonymizationService((AnonymizationService)new UrlAnonymizationService(this.anonymizationCacheService)).withAlertService(this.alertService).withIgnored(policy.getIdentifiers().getUrl().getIgnored()).withIgnoredFiles(policy.getIdentifiers().getUrl().getIgnoredFiles()).withIgnoredPatterns(policy.getIdentifiers().getUrl().getIgnoredPatterns()).withCrypto(policy.getCrypto()).withWindowSize(windowSize7).withPriority(policy.getIdentifiers().getUrl().getPriority()).build();
                boolean requireHttpWwwPrefix = policy.getIdentifiers().getUrl().isRequireHttpWwwPrefix();
                UrlFilter filter17 = new UrlFilter((FilterConfiguration)filterConfiguration, requireHttpWwwPrefix);
                enabledFilters.add((Filter)filter17);
                filterCache.get(policy.getName()).put(FilterType.URL, (Filter)filter17);
            }
        }
        if (policy.getIdentifiers().hasFilter(FilterType.VIN) && policy.getIdentifiers().getVin().isEnabled()) {
            if (cache.containsKey(FilterType.VIN)) {
                enabledFilters.add(cache.get(FilterType.VIN));
            } else {
                int windowSize8 = policy.getIdentifiers().getVin().getWindowSizeOrDefault(this.phileasConfiguration.spanWindowSize());
                filterConfiguration = new FilterConfiguration.FilterConfigurationBuilder().withStrategies(policy.getIdentifiers().getVin().getVinFilterStrategies()).withAnonymizationService((AnonymizationService)new AlphanumericAnonymizationService(this.anonymizationCacheService)).withAlertService(this.alertService).withIgnored(policy.getIdentifiers().getVin().getIgnored()).withIgnoredFiles(policy.getIdentifiers().getVin().getIgnoredFiles()).withIgnoredPatterns(policy.getIdentifiers().getVin().getIgnoredPatterns()).withCrypto(policy.getCrypto()).withFPE(policy.getFpe()).withWindowSize(windowSize8).withPriority(policy.getIdentifiers().getVin().getPriority()).build();
                VinFilter filter18 = new VinFilter((FilterConfiguration)filterConfiguration);
                enabledFilters.add((Filter)filter18);
                filterCache.get(policy.getName()).put(FilterType.VIN, (Filter)filter18);
            }
        }
        if (policy.getIdentifiers().hasFilter(FilterType.ZIP_CODE) && policy.getIdentifiers().getZipCode().isEnabled()) {
            if (cache.containsKey(FilterType.ZIP_CODE)) {
                enabledFilters.add(cache.get(FilterType.ZIP_CODE));
            } else {
                int windowSize9 = policy.getIdentifiers().getZipCode().getWindowSizeOrDefault(this.phileasConfiguration.spanWindowSize());
                filterConfiguration = new FilterConfiguration.FilterConfigurationBuilder().withStrategies(policy.getIdentifiers().getZipCode().getZipCodeFilterStrategies()).withAnonymizationService((AnonymizationService)new ZipCodeAnonymizationService(this.anonymizationCacheService)).withAlertService(this.alertService).withIgnored(policy.getIdentifiers().getZipCode().getIgnored()).withIgnoredFiles(policy.getIdentifiers().getZipCode().getIgnoredFiles()).withIgnoredPatterns(policy.getIdentifiers().getZipCode().getIgnoredPatterns()).withCrypto(policy.getCrypto()).withWindowSize(windowSize9).withPriority(policy.getIdentifiers().getZipCode().getPriority()).build();
                boolean requireDelimiter = policy.getIdentifiers().getZipCode().isRequireDelimiter();
                boolean validate = policy.getIdentifiers().getZipCode().isValidate();
                ZipCodeFilter filter19 = new ZipCodeFilter((FilterConfiguration)filterConfiguration, requireDelimiter, validate);
                enabledFilters.add((Filter)filter19);
                filterCache.get(policy.getName()).put(FilterType.ZIP_CODE, (Filter)filter19);
            }
        }
        if (policy.getIdentifiers().hasFilter(FilterType.CUSTOM_DICTIONARY)) {
            LOGGER.info("Policy {} has {} custom dictionaries.", (Object)policy.getName(), (Object)policy.getIdentifiers().getCustomDictionaries().size());
            int index = 0;
            for (CustomDictionary customDictionary : policy.getIdentifiers().getCustomDictionaries()) {
                if (customDictionary.isEnabled()) {
                    LinkedHashSet terms = new LinkedHashSet();
                    if (CollectionUtils.isNotEmpty((Collection)customDictionary.getTerms())) {
                        terms.addAll(customDictionary.getTerms());
                    }
                    if (CollectionUtils.isNotEmpty((Collection)customDictionary.getFiles())) {
                        for (String file : customDictionary.getFiles()) {
                            terms.addAll(FileUtils.readLines((File)new File(file), (Charset)Charset.defaultCharset()));
                        }
                    }
                    int windowSize10 = customDictionary.getWindowSizeOrDefault(this.phileasConfiguration.spanWindowSize());
                    FilterConfiguration filterConfiguration3 = new FilterConfiguration.FilterConfigurationBuilder().withStrategies(customDictionary.getCustomDictionaryFilterStrategies()).withAnonymizationService((AnonymizationService)new ZipCodeAnonymizationService(this.anonymizationCacheService)).withAlertService(this.alertService).withIgnored(customDictionary.getIgnored()).withIgnoredFiles(customDictionary.getIgnoredFiles()).withIgnoredPatterns(customDictionary.getIgnoredPatterns()).withCrypto(policy.getCrypto()).withWindowSize(windowSize10).withPriority(customDictionary.getPriority()).build();
                    if (!terms.isEmpty()) {
                        String classification = customDictionary.getClassification();
                        boolean capitalized = customDictionary.isCapitalized();
                        LOGGER.info("Custom dictionary contains {} terms.", (Object)terms.size());
                        if (customDictionary.isFuzzy()) {
                            SensitivityLevel sensitivityLevel = SensitivityLevel.fromName((String)customDictionary.getSensitivity());
                            enabledFilters.add((Filter)new FuzzyDictionaryFilter(FilterType.CUSTOM_DICTIONARY, filterConfiguration3, sensitivityLevel, terms, capitalized));
                        } else {
                            enabledFilters.add((Filter)new BloomFilterDictionaryFilter(FilterType.CUSTOM_DICTIONARY, filterConfiguration3, terms, classification));
                        }
                    } else {
                        LOGGER.warn("Custom dictionary contains no terms and will not be enabled.");
                    }
                }
                ++index;
            }
        } else {
            LOGGER.debug("Policy {} has no custom dictionaries.", (Object)policy.getName());
        }
        if (policy.getIdentifiers().hasFilter(FilterType.LOCATION_CITY) && policy.getIdentifiers().getCity().isEnabled()) {
            if (cache.containsKey(FilterType.LOCATION_CITY)) {
                enabledFilters.add(cache.get(FilterType.LOCATION_CITY));
            } else {
                int windowSize11 = policy.getIdentifiers().getCity().getWindowSizeOrDefault(this.phileasConfiguration.spanWindowSize());
                filterConfiguration = new FilterConfiguration.FilterConfigurationBuilder().withStrategies(policy.getIdentifiers().getCity().getCityFilterStrategies()).withAnonymizationService((AnonymizationService)new CityAnonymizationService(this.anonymizationCacheService)).withAlertService(this.alertService).withIgnored(policy.getIdentifiers().getCity().getIgnored()).withIgnoredFiles(policy.getIdentifiers().getCity().getIgnoredFiles()).withIgnoredPatterns(policy.getIdentifiers().getCity().getIgnoredPatterns()).withCrypto(policy.getCrypto()).withWindowSize(windowSize11).withPriority(policy.getIdentifiers().getCity().getPriority()).build();
                SensitivityLevel sensitivityLevel = policy.getIdentifiers().getCity().getSensitivityLevel();
                boolean capitalized = policy.getIdentifiers().getCity().isCapitalized();
                FuzzyDictionaryFilter filter20 = new FuzzyDictionaryFilter(FilterType.LOCATION_CITY, (FilterConfiguration)filterConfiguration, sensitivityLevel, capitalized);
                enabledFilters.add((Filter)filter20);
                filterCache.get(policy.getName()).put(FilterType.LOCATION_CITY, (Filter)filter20);
            }
        }
        if (policy.getIdentifiers().hasFilter(FilterType.LOCATION_COUNTY) && policy.getIdentifiers().getCounty().isEnabled()) {
            if (cache.containsKey(FilterType.LOCATION_COUNTY)) {
                enabledFilters.add(cache.get(FilterType.LOCATION_COUNTY));
            } else {
                int windowSize12 = policy.getIdentifiers().getCounty().getWindowSizeOrDefault(this.phileasConfiguration.spanWindowSize());
                filterConfiguration = new FilterConfiguration.FilterConfigurationBuilder().withStrategies(policy.getIdentifiers().getCounty().getCountyFilterStrategies()).withAnonymizationService((AnonymizationService)new CountyAnonymizationService(this.anonymizationCacheService)).withAlertService(this.alertService).withIgnored(policy.getIdentifiers().getCounty().getIgnored()).withIgnoredFiles(policy.getIdentifiers().getCounty().getIgnoredFiles()).withIgnoredPatterns(policy.getIdentifiers().getCounty().getIgnoredPatterns()).withCrypto(policy.getCrypto()).withWindowSize(windowSize12).withPriority(policy.getIdentifiers().getCounty().getPriority()).build();
                SensitivityLevel sensitivityLevel = policy.getIdentifiers().getCounty().getSensitivityLevel();
                boolean capitalized = policy.getIdentifiers().getCounty().isCapitalized();
                FuzzyDictionaryFilter filter21 = new FuzzyDictionaryFilter(FilterType.LOCATION_COUNTY, (FilterConfiguration)filterConfiguration, sensitivityLevel, capitalized);
                enabledFilters.add((Filter)filter21);
                filterCache.get(policy.getName()).put(FilterType.LOCATION_COUNTY, (Filter)filter21);
            }
        }
        if (policy.getIdentifiers().hasFilter(FilterType.LOCATION_STATE) && policy.getIdentifiers().getState().isEnabled()) {
            if (cache.containsKey(FilterType.LOCATION_STATE)) {
                enabledFilters.add(cache.get(FilterType.LOCATION_STATE));
            } else {
                int windowSize13 = policy.getIdentifiers().getState().getWindowSizeOrDefault(this.phileasConfiguration.spanWindowSize());
                filterConfiguration = new FilterConfiguration.FilterConfigurationBuilder().withStrategies(policy.getIdentifiers().getState().getStateFilterStrategies()).withAnonymizationService((AnonymizationService)new StateAnonymizationService(this.anonymizationCacheService)).withAlertService(this.alertService).withIgnored(policy.getIdentifiers().getState().getIgnored()).withIgnoredFiles(policy.getIdentifiers().getState().getIgnoredFiles()).withIgnoredPatterns(policy.getIdentifiers().getState().getIgnoredPatterns()).withCrypto(policy.getCrypto()).withWindowSize(windowSize13).withPriority(policy.getIdentifiers().getState().getPriority()).build();
                SensitivityLevel sensitivityLevel = policy.getIdentifiers().getState().getSensitivityLevel();
                boolean capitalized = policy.getIdentifiers().getState().isCapitalized();
                FuzzyDictionaryFilter filter22 = new FuzzyDictionaryFilter(FilterType.LOCATION_STATE, (FilterConfiguration)filterConfiguration, sensitivityLevel, capitalized);
                enabledFilters.add((Filter)filter22);
                filterCache.get(policy.getName()).put(FilterType.LOCATION_STATE, (Filter)filter22);
            }
        }
        if (policy.getIdentifiers().hasFilter(FilterType.HOSPITAL) && policy.getIdentifiers().getHospital().isEnabled()) {
            if (cache.containsKey(FilterType.HOSPITAL)) {
                enabledFilters.add(cache.get(FilterType.HOSPITAL));
            } else {
                int windowSize14 = policy.getIdentifiers().getHospital().getWindowSizeOrDefault(this.phileasConfiguration.spanWindowSize());
                filterConfiguration = new FilterConfiguration.FilterConfigurationBuilder().withStrategies(policy.getIdentifiers().getHospital().getHospitalFilterStrategies()).withAnonymizationService((AnonymizationService)new HospitalAnonymizationService(this.anonymizationCacheService)).withAlertService(this.alertService).withIgnored(policy.getIdentifiers().getHospital().getIgnored()).withIgnoredFiles(policy.getIdentifiers().getHospital().getIgnoredFiles()).withIgnoredPatterns(policy.getIdentifiers().getHospital().getIgnoredPatterns()).withCrypto(policy.getCrypto()).withWindowSize(windowSize14).withPriority(policy.getIdentifiers().getHospital().getPriority()).build();
                SensitivityLevel sensitivityLevel = policy.getIdentifiers().getHospital().getSensitivityLevel();
                boolean capitalized = policy.getIdentifiers().getHospital().isCapitalized();
                FuzzyDictionaryFilter filter23 = new FuzzyDictionaryFilter(FilterType.HOSPITAL, (FilterConfiguration)filterConfiguration, sensitivityLevel, capitalized);
                enabledFilters.add((Filter)filter23);
                filterCache.get(policy.getName()).put(FilterType.HOSPITAL, (Filter)filter23);
            }
        }
        if (policy.getIdentifiers().hasFilter(FilterType.HOSPITAL_ABBREVIATION) && policy.getIdentifiers().getHospitalAbbreviation().isEnabled()) {
            if (cache.containsKey(FilterType.HOSPITAL_ABBREVIATION)) {
                enabledFilters.add(cache.get(FilterType.HOSPITAL_ABBREVIATION));
            } else {
                int windowSize15 = policy.getIdentifiers().getHospitalAbbreviation().getWindowSizeOrDefault(this.phileasConfiguration.spanWindowSize());
                filterConfiguration = new FilterConfiguration.FilterConfigurationBuilder().withStrategies(policy.getIdentifiers().getHospitalAbbreviation().getHospitalAbbreviationFilterStrategies()).withAnonymizationService((AnonymizationService)new HospitalAbbreviationAnonymizationService(this.anonymizationCacheService)).withAlertService(this.alertService).withIgnored(policy.getIdentifiers().getHospitalAbbreviation().getIgnored()).withIgnoredFiles(policy.getIdentifiers().getHospitalAbbreviation().getIgnoredFiles()).withIgnoredPatterns(policy.getIdentifiers().getHospitalAbbreviation().getIgnoredPatterns()).withCrypto(policy.getCrypto()).withWindowSize(windowSize15).withPriority(policy.getIdentifiers().getHospitalAbbreviation().getPriority()).build();
                SensitivityLevel sensitivityLevel = policy.getIdentifiers().getHospitalAbbreviation().getSensitivityLevel();
                boolean capitalized = policy.getIdentifiers().getHospitalAbbreviation().isCapitalized();
                FuzzyDictionaryFilter filter24 = new FuzzyDictionaryFilter(FilterType.HOSPITAL_ABBREVIATION, (FilterConfiguration)filterConfiguration, sensitivityLevel, capitalized);
                enabledFilters.add((Filter)filter24);
                filterCache.get(policy.getName()).put(FilterType.HOSPITAL_ABBREVIATION, (Filter)filter24);
            }
        }
        if (policy.getIdentifiers().hasFilter(FilterType.FIRST_NAME) && policy.getIdentifiers().getFirstName().isEnabled()) {
            if (cache.containsKey(FilterType.FIRST_NAME)) {
                enabledFilters.add(cache.get(FilterType.FIRST_NAME));
            } else {
                int windowSize16 = policy.getIdentifiers().getFirstName().getWindowSizeOrDefault(this.phileasConfiguration.spanWindowSize());
                filterConfiguration = new FilterConfiguration.FilterConfigurationBuilder().withStrategies(policy.getIdentifiers().getFirstName().getFirstNameFilterStrategies()).withAnonymizationService((AnonymizationService)new PersonsAnonymizationService(this.anonymizationCacheService)).withAlertService(this.alertService).withIgnored(policy.getIdentifiers().getFirstName().getIgnored()).withIgnoredFiles(policy.getIdentifiers().getFirstName().getIgnoredFiles()).withIgnoredPatterns(policy.getIdentifiers().getFirstName().getIgnoredPatterns()).withCrypto(policy.getCrypto()).withWindowSize(windowSize16).withPriority(policy.getIdentifiers().getFirstName().getPriority()).build();
                SensitivityLevel sensitivityLevel = policy.getIdentifiers().getFirstName().getSensitivityLevel();
                boolean capitalized = policy.getIdentifiers().getFirstName().isCapitalized();
                FuzzyDictionaryFilter filter25 = new FuzzyDictionaryFilter(FilterType.FIRST_NAME, (FilterConfiguration)filterConfiguration, sensitivityLevel, capitalized);
                enabledFilters.add((Filter)filter25);
                filterCache.get(policy.getName()).put(FilterType.FIRST_NAME, (Filter)filter25);
            }
        }
        if (policy.getIdentifiers().hasFilter(FilterType.SURNAME) && policy.getIdentifiers().getSurname().isEnabled()) {
            if (cache.containsKey(FilterType.SURNAME)) {
                enabledFilters.add(cache.get(FilterType.SURNAME));
            } else {
                int windowSize17 = policy.getIdentifiers().getSurname().getWindowSizeOrDefault(this.phileasConfiguration.spanWindowSize());
                filterConfiguration = new FilterConfiguration.FilterConfigurationBuilder().withStrategies(policy.getIdentifiers().getSurname().getSurnameFilterStrategies()).withAnonymizationService((AnonymizationService)new SurnameAnonymizationService(this.anonymizationCacheService)).withAlertService(this.alertService).withIgnored(policy.getIdentifiers().getSurname().getIgnored()).withIgnoredFiles(policy.getIdentifiers().getSurname().getIgnoredFiles()).withIgnoredPatterns(policy.getIdentifiers().getSurname().getIgnoredPatterns()).withCrypto(policy.getCrypto()).withWindowSize(windowSize17).withPriority(policy.getIdentifiers().getSurname().getPriority()).build();
                SensitivityLevel sensitivityLevel = policy.getIdentifiers().getSurname().getSensitivityLevel();
                boolean capitalized = policy.getIdentifiers().getSurname().isCapitalized();
                FuzzyDictionaryFilter filter26 = new FuzzyDictionaryFilter(FilterType.SURNAME, (FilterConfiguration)filterConfiguration, sensitivityLevel, capitalized);
                enabledFilters.add((Filter)filter26);
                filterCache.get(policy.getName()).put(FilterType.SURNAME, (Filter)filter26);
            }
        }
        if (policy.getIdentifiers().hasFilter(FilterType.IDENTIFIER)) {
            List identifiers = policy.getIdentifiers().getIdentifiers();
            for (Identifier identifier : identifiers) {
                if (!identifier.isEnabled()) continue;
                int windowSize18 = identifier.getWindowSizeOrDefault(this.phileasConfiguration.spanWindowSize());
                FilterConfiguration filterConfiguration4 = new FilterConfiguration.FilterConfigurationBuilder().withStrategies(identifier.getIdentifierFilterStrategies()).withAnonymizationService((AnonymizationService)new AlphanumericAnonymizationService(this.anonymizationCacheService)).withAlertService(this.alertService).withIgnored(identifier.getIgnored()).withIgnoredFiles(identifier.getIgnoredFiles()).withIgnoredPatterns(identifier.getIgnoredPatterns()).withCrypto(policy.getCrypto()).withWindowSize(windowSize18).withPriority(identifier.getPriority()).build();
                String classification = identifier.getClassification();
                String pattern = identifier.getPattern();
                boolean caseSensitive = identifier.isCaseSensitive();
                int groupNumber = identifier.getGroupNumber();
                IdentifierFilter identifierFilter = new IdentifierFilter(filterConfiguration4, classification, pattern, caseSensitive, groupNumber);
                enabledFilters.add((Filter)identifierFilter);
            }
        }
        if (policy.getIdentifiers().hasFilter(FilterType.PERSON) && policy.getIdentifiers().getPhEye().isEnabled()) {
            if (cache.containsKey(FilterType.PERSON)) {
                enabledFilters.add(cache.get(FilterType.PERSON));
            } else {
                int windowSize19 = policy.getIdentifiers().getPhEye().getWindowSizeOrDefault(this.phileasConfiguration.spanWindowSize());
                filterConfiguration = new FilterConfiguration.FilterConfigurationBuilder().withStrategies(policy.getIdentifiers().getPhEye().getPhEyeFilterStrategies()).withAnonymizationService((AnonymizationService)new PersonsAnonymizationService(this.anonymizationCacheService)).withAlertService(this.alertService).withIgnored(policy.getIdentifiers().getPhEye().getIgnored()).withIgnoredFiles(policy.getIdentifiers().getPhEye().getIgnoredFiles()).withIgnoredPatterns(policy.getIdentifiers().getPhEye().getIgnoredPatterns()).withCrypto(policy.getCrypto()).withWindowSize(windowSize19).withPriority(policy.getIdentifiers().getPhEye().getPriority()).build();
                PhEyeConfiguration phEyeConfiguration = new PhEyeConfiguration(policy.getIdentifiers().getPhEye().getPhEyeConfiguration().getEndpoint());
                phEyeConfiguration.setTimeout(policy.getIdentifiers().getPhEye().getPhEyeConfiguration().getTimeout());
                phEyeConfiguration.setKeepAliveDurationMs(policy.getIdentifiers().getPhEye().getPhEyeConfiguration().getKeepAliveDurationMs());
                phEyeConfiguration.setMaxIdleConnections(policy.getIdentifiers().getPhEye().getPhEyeConfiguration().getMaxIdleConnections());
                phEyeConfiguration.setBearerToken(policy.getIdentifiers().getPhEye().getPhEyeConfiguration().getBearerToken());
                PhEyeFilter filter27 = new PhEyeFilter((FilterConfiguration)filterConfiguration, phEyeConfiguration, this.stats, this.metricsService, policy.getIdentifiers().getPhEye().isRemovePunctuation(), policy.getIdentifiers().getPhEye().getThresholds());
                enabledFilters.add((Filter)filter27);
                filterCache.get(policy.getName()).put(FilterType.PERSON, (Filter)filter27);
            }
        }
        return enabledFilters;
    }
}

