/*
 * Decompiled with CFR 0.152.
 */
package ai.philterd.phileas.services;

import ai.philterd.phileas.model.configuration.PhileasConfiguration;
import ai.philterd.phileas.model.enums.FilterType;
import ai.philterd.phileas.model.enums.MimeType;
import ai.philterd.phileas.model.filter.Filter;
import ai.philterd.phileas.model.objects.Explanation;
import ai.philterd.phileas.model.objects.PdfRedactionOptions;
import ai.philterd.phileas.model.objects.Span;
import ai.philterd.phileas.model.policy.Ignored;
import ai.philterd.phileas.model.policy.Policy;
import ai.philterd.phileas.model.policy.config.Pdf;
import ai.philterd.phileas.model.policy.graphical.BoundingBox;
import ai.philterd.phileas.model.responses.BinaryDocumentFilterResponse;
import ai.philterd.phileas.model.responses.FilterResponse;
import ai.philterd.phileas.model.serializers.PlaceholderDeserializer;
import ai.philterd.phileas.model.services.AlertService;
import ai.philterd.phileas.model.services.CacheService;
import ai.philterd.phileas.model.services.Classification;
import ai.philterd.phileas.model.services.DocumentProcessor;
import ai.philterd.phileas.model.services.FilterService;
import ai.philterd.phileas.model.services.MetricsService;
import ai.philterd.phileas.model.services.PolicyService;
import ai.philterd.phileas.model.services.PostFilter;
import ai.philterd.phileas.model.services.SpanDisambiguationService;
import ai.philterd.phileas.model.services.SplitService;
import ai.philterd.phileas.processors.unstructured.UnstructuredDocumentProcessor;
import ai.philterd.phileas.service.ai.sentiment.OpenNLPSentimentDetector;
import ai.philterd.phileas.services.FilterPolicyLoader;
import ai.philterd.phileas.services.alerts.DefaultAlertService;
import ai.philterd.phileas.services.disambiguation.VectorBasedSpanDisambiguationService;
import ai.philterd.phileas.services.metrics.NoOpMetricsService;
import ai.philterd.phileas.services.policies.InMemoryPolicyService;
import ai.philterd.phileas.services.policies.LocalPolicyService;
import ai.philterd.phileas.services.policies.utils.PolicyUtils;
import ai.philterd.phileas.services.postfilters.IgnoredPatternsFilter;
import ai.philterd.phileas.services.postfilters.IgnoredTermsFilter;
import ai.philterd.phileas.services.postfilters.TrailingNewLinePostFilter;
import ai.philterd.phileas.services.postfilters.TrailingPeriodPostFilter;
import ai.philterd.phileas.services.postfilters.TrailingSpacePostFilter;
import ai.philterd.phileas.services.split.SplitFactory;
import ai.philterd.services.pdf.PdfRedacter;
import ai.philterd.services.pdf.PdfTextExtractor;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.math3.stat.descriptive.DescriptiveStatistics;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PhileasFilterService
implements FilterService {
    private static final Logger LOGGER = LogManager.getLogger(PhileasFilterService.class);
    private final PolicyService policyService;
    private final PolicyUtils policyUtils;
    private final AlertService alertService;
    private final DocumentProcessor unstructuredDocumentProcessor;
    private final FilterPolicyLoader filterPolicyLoader;
    private final Map<String, Map<FilterType, Filter>> filterCache;

    public PhileasFilterService(PhileasConfiguration phileasConfiguration, CacheService cacheService) throws IOException {
        this(phileasConfiguration, new NoOpMetricsService(), cacheService);
    }

    public PhileasFilterService(PhileasConfiguration phileasConfiguration, MetricsService metricsService, CacheService cacheService) throws IOException {
        LOGGER.info("Initializing Phileas engine.");
        this.filterCache = new ConcurrentHashMap<String, Map<FilterType, Filter>>();
        Gson gson = new GsonBuilder().registerTypeAdapter(String.class, (Object)new PlaceholderDeserializer()).create();
        this.policyService = this.buildPolicyService(phileasConfiguration, cacheService);
        this.policyUtils = new PolicyUtils(this.policyService, gson);
        this.alertService = new DefaultAlertService(cacheService);
        HashMap<String, DescriptiveStatistics> stats = new HashMap<String, DescriptiveStatistics>();
        this.filterPolicyLoader = new FilterPolicyLoader(this.alertService, cacheService, metricsService, stats, phileasConfiguration);
        this.unstructuredDocumentProcessor = new UnstructuredDocumentProcessor(metricsService, (SpanDisambiguationService)new VectorBasedSpanDisambiguationService(phileasConfiguration, cacheService));
    }

    public PolicyService getPolicyService() {
        return this.policyService;
    }

    public AlertService getAlertService() {
        return this.alertService;
    }

    public FilterResponse filter(Policy policy, String context, String documentId, String input, MimeType mimeType) throws Exception {
        FilterResponse filterResponse;
        OpenNLPSentimentDetector sentimentDetector;
        Classification classification;
        HashMap<String, String> attributes = new HashMap<String, String>();
        List<Filter> filters = this.filterPolicyLoader.getFiltersForPolicy(policy, this.filterCache);
        List<PostFilter> postFilters = this.getPostFiltersForPolicy(policy);
        if (policy.getConfig().getAnalysis().getSentiment().isEnabled() && (classification = (sentimentDetector = new OpenNLPSentimentDetector()).classify(policy, input)) != null) {
            attributes.put("sentiment", classification.label());
            attributes.put("sentiment-confidence", String.valueOf(classification.confidence()));
        }
        if (policy.getConfig().getAnalysis().getOffensiveness().isEnabled() && (classification = (sentimentDetector = new OpenNLPSentimentDetector()).classify(policy, input)) != null) {
            attributes.put("offensiveness", classification.label());
            attributes.put("offensiveness-confidence", String.valueOf(classification.confidence()));
        }
        if (StringUtils.isEmpty((CharSequence)documentId)) {
            documentId = DigestUtils.md5Hex((String)(String.valueOf(UUID.randomUUID()) + "-" + context + "-" + policy.getName() + "-" + input));
            LOGGER.debug("Generated document ID {}", (Object)documentId);
        }
        if (mimeType == MimeType.TEXT_PLAIN) {
            if (policy.getConfig().getSplitting().isEnabled() && input.length() >= policy.getConfig().getSplitting().getThreshold()) {
                SplitService splitService = SplitFactory.getSplitService((String)policy.getConfig().getSplitting().getMethod());
                LinkedList<FilterResponse> filterResponses = new LinkedList<FilterResponse>();
                List splits = splitService.split(input);
                for (int i = 0; i < splits.size(); ++i) {
                    FilterResponse fr = this.unstructuredDocumentProcessor.process(policy, filters, postFilters, context, documentId, i, (String)splits.get(i), attributes);
                    filterResponses.add(fr);
                }
                filterResponse = FilterResponse.combine(filterResponses, (String)context, (String)documentId, (String)splitService.getSeparator());
            } else {
                filterResponse = this.unstructuredDocumentProcessor.process(policy, filters, postFilters, context, documentId, 0, input, attributes);
            }
        } else {
            throw new Exception("Unknown mime type.");
        }
        return filterResponse;
    }

    public FilterResponse filter(List<String> policyNames, String context, String documentId, String input, MimeType mimeType) throws Exception {
        Policy policy = this.policyUtils.getCombinedPolicies(policyNames);
        return this.filter(policy, context, documentId, input, mimeType);
    }

    public BinaryDocumentFilterResponse filter(List<String> policyNames, String context, String documentId, byte[] input, MimeType mimeType, MimeType outputMimeType) throws Exception {
        LinkedHashSet<Span> nonRelativeSpans;
        LinkedHashSet spans;
        Policy policy = this.policyUtils.getCombinedPolicies(policyNames);
        HashMap attributes = new HashMap();
        if (StringUtils.isEmpty((CharSequence)documentId)) {
            documentId = DigestUtils.md5Hex((String)(String.valueOf(UUID.randomUUID()) + "-" + context + "-" + policy.getName() + "-" + Arrays.toString(input)));
            LOGGER.debug("Generated document ID {}", (Object)documentId);
        }
        if (mimeType == MimeType.APPLICATION_PDF) {
            PdfTextExtractor pdfTextExtractor = new PdfTextExtractor();
            List lines = pdfTextExtractor.getLines(input);
            spans = new LinkedHashSet();
            nonRelativeSpans = new LinkedHashSet<Span>();
            int offset = 0;
            List<Filter> filters = this.filterPolicyLoader.getFiltersForPolicy(policy, this.filterCache);
            List<PostFilter> postFilters = this.getPostFiltersForPolicy(policy);
            for (String line : lines) {
                boolean piece = false;
                FilterResponse filterResponse = this.unstructuredDocumentProcessor.process(policy, filters, postFilters, context, documentId, 0, line, attributes);
                spans.addAll(filterResponse.getExplanation().appliedSpans());
                for (Span span : filterResponse.getExplanation().appliedSpans()) {
                    span.setCharacterStart(span.getCharacterStart() + offset);
                    span.setCharacterEnd(span.getCharacterEnd() + offset);
                    nonRelativeSpans.add(span);
                }
                offset += line.length();
            }
        } else {
            throw new Exception("Unknown mime type.");
        }
        Pdf policyPdfConfig = policy.getConfig().getPdf();
        PdfRedactionOptions pdfRedactionOptions = new PdfRedactionOptions(policyPdfConfig.getDpi(), policyPdfConfig.getCompressionQuality(), policyPdfConfig.getScale(), policyPdfConfig.getPreserveUnredactedPages());
        List<BoundingBox> boundingBoxes = this.getBoundingBoxes(policy, mimeType);
        PdfRedacter redacter = new PdfRedacter(policy, spans, pdfRedactionOptions, boundingBoxes);
        byte[] redacted = redacter.process(input, outputMimeType);
        ArrayList spansList = new ArrayList(nonRelativeSpans);
        Explanation explanation = new Explanation(spansList, spansList);
        BinaryDocumentFilterResponse binaryDocumentFilterResponse = new BinaryDocumentFilterResponse(redacted, context, documentId, explanation);
        return binaryDocumentFilterResponse;
    }

    private PolicyService buildPolicyService(PhileasConfiguration phileasConfiguration, CacheService cacheService) {
        if (StringUtils.equalsIgnoreCase((CharSequence)phileasConfiguration.policyService(), (CharSequence)"memory")) {
            return new InMemoryPolicyService();
        }
        return new LocalPolicyService(phileasConfiguration, cacheService);
    }

    private List<BoundingBox> getBoundingBoxes(Policy policy, MimeType mimeType) {
        LinkedList<BoundingBox> boundingBoxes = new LinkedList<BoundingBox>();
        for (BoundingBox boundingBox : policy.getGraphical().getBoundingBoxes()) {
            if (!StringUtils.equalsIgnoreCase((CharSequence)boundingBox.getMimeType(), (CharSequence)mimeType.toString())) continue;
            boundingBoxes.add(boundingBox);
        }
        return boundingBoxes;
    }

    private List<PostFilter> getPostFiltersForPolicy(Policy policy) throws IOException {
        LinkedList<PostFilter> postFilters = new LinkedList<PostFilter>();
        if (CollectionUtils.isNotEmpty((Collection)policy.getIgnored())) {
            for (Ignored ignored : policy.getIgnored()) {
                postFilters.add(new IgnoredTermsFilter(ignored));
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)policy.getIgnoredPatterns())) {
            postFilters.add(new IgnoredPatternsFilter(policy.getIgnoredPatterns()));
        }
        if (policy.getConfig().getPostFilters().isRemoveTrailingPeriods()) {
            postFilters.add(TrailingPeriodPostFilter.getInstance());
        }
        if (policy.getConfig().getPostFilters().isRemoveTrailingSpaces()) {
            postFilters.add(TrailingSpacePostFilter.getInstance());
        }
        if (policy.getConfig().getPostFilters().isRemoveTrailingNewLines()) {
            postFilters.add(TrailingNewLinePostFilter.getInstance());
        }
        return postFilters;
    }
}

