/*
 * Decompiled with CFR 0.152.
 */
package ai.philterd.phileas.services.filters.ai.pheye;

import ai.philterd.phileas.model.enums.FilterType;
import ai.philterd.phileas.model.filter.FilterConfiguration;
import ai.philterd.phileas.model.filter.dynamic.NerFilter;
import ai.philterd.phileas.model.objects.FilterResult;
import ai.philterd.phileas.model.objects.Replacement;
import ai.philterd.phileas.model.objects.Span;
import ai.philterd.phileas.model.policy.Policy;
import ai.philterd.phileas.model.services.MetricsService;
import ai.philterd.phileas.services.filters.ai.pheye.PhEyeConfiguration;
import ai.philterd.phileas.services.filters.ai.pheye.PhEyeRequest;
import ai.philterd.phileas.services.filters.ai.pheye.PhEyeSpan;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.lang.reflect.Type;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.math3.stat.descriptive.DescriptiveStatistics;
import org.apache.hc.client5.http.classic.methods.HttpPost;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.HttpClientBuilder;
import org.apache.hc.client5.http.impl.classic.HttpClients;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManager;
import org.apache.hc.client5.http.io.HttpClientConnectionManager;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.io.HttpClientResponseHandler;
import org.apache.hc.core5.http.io.entity.EntityUtils;
import org.apache.hc.core5.http.io.entity.StringEntity;
import org.apache.hc.core5.net.URIBuilder;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PhEyeFilter
extends NerFilter {
    private static final Logger LOGGER = LogManager.getLogger(PhEyeFilter.class);
    private final boolean removePunctuation;
    private final PhEyeConfiguration phEyeConfiguration;
    private final Collection<String> labels;
    private final Gson gson;
    final PoolingHttpClientConnectionManager connectionManager;

    public PhEyeFilter(FilterConfiguration filterConfiguration, PhEyeConfiguration phEyeConfiguration, Map<String, DescriptiveStatistics> stats, MetricsService metricsService, boolean removePunctuation, Map<String, Double> thresholds) {
        super(filterConfiguration, stats, metricsService, thresholds, FilterType.AGE);
        this.phEyeConfiguration = phEyeConfiguration;
        this.removePunctuation = removePunctuation;
        this.labels = phEyeConfiguration.getLabels();
        this.gson = new Gson();
        this.connectionManager = new PoolingHttpClientConnectionManager();
        if (phEyeConfiguration.getMaxIdleConnections() > 0) {
            this.connectionManager.setMaxTotal(phEyeConfiguration.getMaxIdleConnections());
            this.connectionManager.setDefaultMaxPerRoute(phEyeConfiguration.getMaxIdleConnections());
        }
    }

    public FilterResult filter(Policy policy, String context, String documentId, int piece, String input, Map<String, String> attributes) throws Exception {
        HttpClientResponseHandler responseHandler;
        HttpClientBuilder httpClientBuilder;
        CloseableHttpClient httpClient;
        String responseBody;
        LinkedList<Span> spans = new LinkedList<Span>();
        String formattedInput = this.removePunctuation ? input.replaceAll("\\p{Punct}", " ") : input;
        PhEyeRequest phEyeRequest = new PhEyeRequest();
        phEyeRequest.setText(input);
        phEyeRequest.setContext(context);
        phEyeRequest.setDocumentId(documentId);
        phEyeRequest.setPiece(piece);
        phEyeRequest.setLabels(this.labels);
        String json = this.gson.toJson((Object)phEyeRequest);
        URI uri = new URIBuilder(this.phEyeConfiguration.getEndpoint() + "/find").build();
        RequestConfig requestConfig = RequestConfig.custom().setConnectionRequestTimeout((long)this.phEyeConfiguration.getTimeout(), TimeUnit.SECONDS).setResponseTimeout((long)this.phEyeConfiguration.getTimeout(), TimeUnit.SECONDS).build();
        HttpPost httpPost = new HttpPost(uri);
        httpPost.setConfig(requestConfig);
        httpPost.setEntity((HttpEntity)new StringEntity(json));
        httpPost.setHeader("Content-Type", (Object)"application/json");
        httpPost.setHeader("Accept", (Object)"application/json");
        if (StringUtils.isNotEmpty((CharSequence)this.phEyeConfiguration.getBearerToken())) {
            httpPost.setHeader("Authorization", (Object)("Bearer " + this.phEyeConfiguration.getBearerToken()));
        }
        if ((responseBody = (String)(httpClient = (httpClientBuilder = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)this.connectionManager)).build()).execute((ClassicHttpRequest)httpPost, responseHandler = response -> {
            if (response.getCode() == 200) {
                HttpEntity responseEntity = response.getEntity();
                return responseEntity != null ? EntityUtils.toString((HttpEntity)responseEntity) : null;
            }
            LOGGER.error("PhEyeFilter failed with code {}", (Object)response.getCode());
            throw new IOException("Unable to process document. Received error response from philter-ner.");
        })) != null) {
            Type listType = new TypeToken<ArrayList<PhEyeSpan>>(){}.getType();
            List phEyeSpans = (List)new Gson().fromJson(responseBody, listType);
            if (CollectionUtils.isNotEmpty((Collection)phEyeSpans)) {
                for (PhEyeSpan phEyeSpan : phEyeSpans) {
                    if (!this.labels.contains(phEyeSpan.getLabel()) || this.thresholds.containsKey(phEyeSpan.getLabel().toUpperCase()) && !(phEyeSpan.getScore() >= (Double)this.thresholds.get(phEyeSpan.getLabel().toUpperCase()))) continue;
                    String[] window = this.getWindow(formattedInput, phEyeSpan.getStart(), phEyeSpan.getEnd());
                    Span span = this.createSpan(policy, context, documentId, phEyeSpan.getText(), window, phEyeSpan.getLabel(), phEyeSpan.getStart(), phEyeSpan.getEnd(), phEyeSpan.getScore(), attributes);
                    if (span == null) continue;
                    spans.add(span);
                }
            }
            LOGGER.debug("Returning {} NER spans from ph-eye.", (Object)spans.size());
            return new FilterResult(context, documentId, piece, spans);
        }
        throw new IOException("Unable to process document. Received error response from philter-ner.");
    }

    public int getOccurrences(Policy policy, String input, Map<String, String> attributes) throws Exception {
        return this.filter(policy, "none", "none", 0, input, attributes).getSpans().size();
    }

    private Span createSpan(Policy policy, String context, String documentId, String text, String[] window, String classification, int start, int end, double confidence, Map<String, String> attributes) throws Exception {
        Replacement replacement = this.getReplacement(policy, context, documentId, text, window, confidence, classification, attributes, null);
        if (StringUtils.equals((CharSequence)replacement.getReplacement(), (CharSequence)text)) {
            return null;
        }
        boolean ignored = this.isIgnored(text);
        return Span.make((int)start, (int)end, (FilterType)FilterType.AGE, (String)context, (String)documentId, (double)confidence, (String)text, (String)replacement.getReplacement(), (String)replacement.getSalt(), (boolean)ignored, (boolean)replacement.isApplied(), (String[])window, (int)this.priority);
    }
}

