/*
 * Decompiled with CFR 0.152.
 */
package ai.philterd.phileas.services.filters.custom;

import ai.philterd.phileas.model.enums.FilterType;
import ai.philterd.phileas.model.filter.FilterConfiguration;
import ai.philterd.phileas.model.filter.rules.RulesFilter;
import ai.philterd.phileas.model.objects.FilterResult;
import ai.philterd.phileas.model.objects.Replacement;
import ai.philterd.phileas.model.objects.Span;
import ai.philterd.phileas.model.policy.Policy;
import com.google.i18n.phonenumbers.PhoneNumberMatch;
import com.google.i18n.phonenumbers.PhoneNumberUtil;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.regex.Pattern;

public class PhoneNumberRulesFilter
extends RulesFilter {
    private final PhoneNumberUtil phoneUtil;
    private final Pattern pattern = Pattern.compile("^(\\+\\d{1,2}\\s)?\\(?\\d{3}\\)?[\\s.-]\\d{3}[\\s.-]\\d{4}$");

    public PhoneNumberRulesFilter(FilterConfiguration filterConfiguration) {
        super(FilterType.PHONE_NUMBER, filterConfiguration);
        this.phoneUtil = PhoneNumberUtil.getInstance();
        this.contextualTerms = new HashSet();
        this.contextualTerms.add("phone");
        this.contextualTerms.add("telephone");
        this.contextualTerms.add("fax");
        this.contextualTerms.add("cell");
        this.contextualTerms.add("mobile");
    }

    public FilterResult filter(Policy policy, String context, String documentId, int piece, String input, Map<String, String> attributes) throws Exception {
        LinkedList<Span> spans = new LinkedList<Span>();
        if (policy.getIdentifiers().hasFilter(this.filterType)) {
            Iterable matches = this.phoneUtil.findNumbers((CharSequence)input, "US", PhoneNumberUtil.Leniency.POSSIBLE, 1L);
            for (PhoneNumberMatch match : matches) {
                String text = match.rawString();
                double confidence = 0.0;
                confidence = text.matches(this.pattern.pattern()) ? 0.95 : (text.length() > 14 ? 0.75 : 0.6);
                String[] window = this.getWindow(input, match.start(), match.end());
                String classification = "";
                Replacement replacement = this.getReplacement(policy, context, documentId, text, window, confidence, "", attributes, null);
                boolean isIgnored = this.ignored.contains(text);
                spans.add(Span.make((int)match.start(), (int)match.end(), (FilterType)this.getFilterType(), (String)context, (String)documentId, (double)confidence, (String)text, (String)replacement.getReplacement(), (String)replacement.getSalt(), (boolean)isIgnored, (boolean)replacement.isApplied(), (String[])window, (int)this.priority));
            }
        }
        return new FilterResult(context, documentId, spans);
    }
}

