/*
 * Decompiled with CFR 0.152.
 */
package ai.philterd.phileas.services.filters.regex;

import ai.philterd.phileas.model.enums.FilterType;
import ai.philterd.phileas.model.filter.FilterConfiguration;
import ai.philterd.phileas.model.filter.rules.regex.RegexFilter;
import ai.philterd.phileas.model.objects.Analyzer;
import ai.philterd.phileas.model.objects.FilterPattern;
import ai.philterd.phileas.model.objects.FilterResult;
import ai.philterd.phileas.model.objects.Span;
import ai.philterd.phileas.model.policy.Policy;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;

public class AgeFilter
extends RegexFilter {
    public AgeFilter(FilterConfiguration filterConfiguration) {
        super(FilterType.AGE, filterConfiguration);
        Pattern agePattern1 = Pattern.compile("\\b[0-9.]+[\\s]*(year|years|yrs|yr|yo)(.?)(\\s)*(old)?\\b", 2);
        FilterPattern age1 = new FilterPattern.FilterPatternBuilder(agePattern1, 0.9).build();
        Pattern agePattern2 = Pattern.compile("\\b(age)(d)?(\\s)*[0-9.]+\\b", 2);
        FilterPattern age2 = new FilterPattern.FilterPatternBuilder(agePattern2, 0.9).build();
        Pattern agePattern3 = Pattern.compile("\\b[0-9.]+[-]*(year|years|yrs|yr|yo)(.?)(-)*(old)?\\b", 2);
        FilterPattern age3 = new FilterPattern.FilterPatternBuilder(agePattern3, 0.9).build();
        Pattern agePattern4 = Pattern.compile("\\b([0-9]{1,3}) (y\\/o)\\b", 2);
        FilterPattern age4 = new FilterPattern.FilterPatternBuilder(agePattern4, 0.9).build();
        this.contextualTerms = new HashSet();
        this.contextualTerms.add("age");
        this.contextualTerms.add("years");
        this.analyzer = new Analyzer(this.contextualTerms, new FilterPattern[]{age1, age2, age3, age4});
    }

    public FilterResult filter(Policy policy, String context, String documentId, int piece, String input, Map<String, String> attributes) throws Exception {
        List spans = this.findSpans(policy, this.analyzer, input, context, documentId, attributes);
        List nonOverlappingSpans = Span.dropOverlappingSpans((List)spans);
        return new FilterResult(context, documentId, nonOverlappingSpans);
    }

    public List<Span> postFilter(List<Span> spans) {
        LinkedList<Span> postFilteredSpans = new LinkedList<Span>();
        for (Span span : spans) {
            List<String> window = Arrays.stream(span.getWindow()).map(String::toLowerCase).toList();
            if (!window.contains("age") && !span.getText().contains("aged") && !span.getText().contains("old") && !span.getText().contains("y/o") && !span.getText().contains("yo")) continue;
            postFilteredSpans.add(span);
        }
        return postFilteredSpans;
    }
}

