/*
 * Decompiled with CFR 0.152.
 */
package ai.philterd.phileas.services.filters.regex;

import ai.philterd.phileas.model.enums.FilterType;
import ai.philterd.phileas.model.filter.FilterConfiguration;
import ai.philterd.phileas.model.filter.rules.regex.RegexFilter;
import ai.philterd.phileas.model.objects.Analyzer;
import ai.philterd.phileas.model.objects.FilterPattern;
import ai.philterd.phileas.model.objects.FilterResult;
import ai.philterd.phileas.model.objects.Span;
import ai.philterd.phileas.model.policy.Policy;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;

public class BankRoutingNumberFilter
extends RegexFilter {
    public BankRoutingNumberFilter(FilterConfiguration filterConfiguration) {
        super(FilterType.BANK_ROUTING_NUMBER, filterConfiguration);
        Pattern routingNumberPattern = Pattern.compile("\\b[0-9]{9}\\b", 2);
        FilterPattern routingNumber = new FilterPattern.FilterPatternBuilder(routingNumberPattern, 0.95).build();
        this.contextualTerms = new HashSet();
        this.contextualTerms.add("routing");
        this.contextualTerms.add("bank");
        this.analyzer = new Analyzer(this.contextualTerms, new FilterPattern[]{routingNumber});
    }

    public FilterResult filter(Policy policy, String context, String documentId, int piece, String input, Map<String, String> attributes) throws Exception {
        List spans = this.findSpans(policy, this.analyzer, input, context, documentId, attributes);
        List nonOverlappingSpans = Span.dropOverlappingSpans((List)spans);
        LinkedList<Span> validSpans = new LinkedList<Span>();
        for (Span span : nonOverlappingSpans) {
            String digits = span.getText();
            int checksum = (3 * (Character.getNumericValue(digits.charAt(0)) + Character.getNumericValue(digits.charAt(3)) + Character.getNumericValue(digits.charAt(6))) + 7 * (Character.getNumericValue(digits.charAt(1)) + Character.getNumericValue(digits.charAt(4)) + Character.getNumericValue(digits.charAt(7))) + 1 * (Character.getNumericValue(digits.charAt(2)) + Character.getNumericValue(digits.charAt(5)) + Character.getNumericValue(digits.charAt(8)))) % 10;
            if (checksum != 0) continue;
            validSpans.add(span);
        }
        return new FilterResult(context, documentId, validSpans);
    }
}

