/*
 * Decompiled with CFR 0.152.
 */
package ai.philterd.phileas.services.filters.regex;

import ai.philterd.phileas.model.enums.FilterType;
import ai.philterd.phileas.model.filter.FilterConfiguration;
import ai.philterd.phileas.model.filter.rules.regex.RegexFilter;
import ai.philterd.phileas.model.objects.Analyzer;
import ai.philterd.phileas.model.objects.FilterPattern;
import ai.philterd.phileas.model.objects.FilterResult;
import ai.philterd.phileas.model.policy.Policy;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;

public class BitcoinAddressFilter
extends RegexFilter {
    public BitcoinAddressFilter(FilterConfiguration filterConfiguration) {
        super(FilterType.BITCOIN_ADDRESS, filterConfiguration);
        Pattern bitcoinPattern = Pattern.compile("\\b[13][a-km-zA-HJ-NP-Z1-9]{25,34}\\b", 2);
        FilterPattern bitcoin1 = new FilterPattern.FilterPatternBuilder(bitcoinPattern, 0.9).build();
        this.contextualTerms = new HashSet();
        this.contextualTerms.add("bitcoin");
        this.contextualTerms.add("wallet");
        this.contextualTerms.add("btc");
        this.contextualTerms.add("crypto");
        this.analyzer = new Analyzer(this.contextualTerms, new FilterPattern[]{bitcoin1});
    }

    public FilterResult filter(Policy policy, String context, String documentId, int piece, String input, Map<String, String> attributes) throws Exception {
        List spans = this.findSpans(policy, this.analyzer, input, context, documentId, attributes);
        return new FilterResult(context, documentId, spans);
    }
}

