/*
 * Decompiled with CFR 0.152.
 */
package ai.philterd.phileas.services.filters.regex;

import ai.philterd.phileas.model.enums.FilterType;
import ai.philterd.phileas.model.filter.FilterConfiguration;
import ai.philterd.phileas.model.filter.rules.regex.RegexFilter;
import ai.philterd.phileas.model.objects.Analyzer;
import ai.philterd.phileas.model.objects.ConfidenceModifier;
import ai.philterd.phileas.model.objects.FilterPattern;
import ai.philterd.phileas.model.objects.FilterResult;
import ai.philterd.phileas.model.objects.Span;
import ai.philterd.phileas.model.policy.Policy;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.validator.routines.checkdigit.LuhnCheckDigit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CreditCardFilter
extends RegexFilter {
    private final boolean onlyValidCreditCardNumbers;
    private final LuhnCheckDigit luhnCheckDigit;
    private final boolean ignoreWhenInUnixTimestamp;
    protected static final Logger LOGGER = LogManager.getLogger(CreditCardFilter.class);
    private final String UNIX_TIMESTAMP_REGEX = "1[5-8][0-9]{11}";
    final Pattern detailedSearch = Pattern.compile("    (\n        4[0-9]{12}(?:[0-9]{3})?             # Visa\n        |  (?:5[1-5][0-9]{2}                # MasterCard\n            | 222[1-9]|22[3-9][0-9]|2[3-6][0-9]{2}|27[01][0-9]|2720)[0-9]{12}\n        |  3[47][0-9]{13}                   # American Express\n        |  3(?:0[0-5]|[68][0-9])[0-9]{11}   # Diners Club\n        |  6(?:011|5[0-9]{2})[0-9]{12}      # Discover\n        |  (?:2131|1800|35\\d{3})\\d{11}    # JCB\n    )\n", 6);

    public CreditCardFilter(FilterConfiguration filterConfiguration, boolean onlyValidCreditCardNumbers, boolean ignoreWhenInUnixTimestamp, boolean onlyWordBoundaries) {
        super(FilterType.CREDIT_CARD, filterConfiguration);
        FilterPattern creditCardPattern;
        this.onlyValidCreditCardNumbers = onlyValidCreditCardNumbers;
        this.luhnCheckDigit = new LuhnCheckDigit();
        this.ignoreWhenInUnixTimestamp = ignoreWhenInUnixTimestamp;
        ArrayList<ConfidenceModifier> confidenceModifiers = new ArrayList<ConfidenceModifier>(List.of(new ConfidenceModifier(0.6, ConfidenceModifier.ConfidenceCondition.CHARACTER_SEQUENCE_BEFORE, "-"), new ConfidenceModifier(0.6, ConfidenceModifier.ConfidenceCondition.CHARACTER_SEQUENCE_AFTER, "-"), new ConfidenceModifier(0.5, ConfidenceModifier.ConfidenceCondition.CHARACTER_SEQUENCE_SURROUNDING, "-")));
        String genericCards = "(?:\\d[ -]*?){13,16}";
        if (onlyWordBoundaries) {
            Pattern creditCard = Pattern.compile("\\b(?:\\d[ -]*?){13,16}\\b", 2);
            double initialConfidence = 0.9;
            creditCardPattern = new FilterPattern.FilterPatternBuilder(creditCard, initialConfidence).withConfidenceModifiers(confidenceModifiers).build();
        } else {
            Pattern creditCard = Pattern.compile("(?=((?:\\d[ -]*?){13,16}))", 2);
            double initialConfidence = 0.7;
            confidenceModifiers.add(new ConfidenceModifier(ConfidenceModifier.ConfidenceCondition.CHARACTER_REGEX_SURROUNDING, 0.2, Pattern.compile("[\\s\\-]")));
            creditCardPattern = new FilterPattern.FilterPatternBuilder(creditCard, initialConfidence).withConfidenceModifiers(confidenceModifiers).withGroupNumber(1).build();
        }
        this.contextualTerms = new HashSet();
        this.contextualTerms.add("credit");
        this.contextualTerms.add("card");
        this.contextualTerms.add("american express");
        this.contextualTerms.add("amex");
        this.contextualTerms.add("discover");
        this.contextualTerms.add("jcb");
        this.contextualTerms.add("diners");
        this.analyzer = new Analyzer(this.contextualTerms, new FilterPattern[]{creditCardPattern});
    }

    public FilterResult filter(Policy policy, String context, String documentId, int piece, String input, Map<String, String> attributes) throws Exception {
        List spans = this.findSpans(policy, this.analyzer, input, context, documentId, attributes);
        LOGGER.debug("Found " + spans.size() + " spans");
        Iterator iterator = spans.iterator();
        while (iterator.hasNext()) {
            String creditCardNumber;
            Span span = (Span)iterator.next();
            if (this.ignoreWhenInUnixTimestamp && span.getText().matches("1[5-8][0-9]{11}")) {
                LOGGER.debug("Ignoring unix timestamp");
                iterator.remove();
            }
            if (!this.onlyValidCreditCardNumbers || this.detailedSearch.matcher(creditCardNumber = input.substring(span.getCharacterStart(), span.getCharacterEnd()).replaceAll(" ", "").replaceAll("-", "")).matches() && this.luhnCheckDigit.isValid(creditCardNumber)) continue;
            LOGGER.debug("Ignoring a number that doesn't quite fit the credit card number patterns or LUHN");
            iterator.remove();
        }
        return new FilterResult(context, documentId, spans);
    }
}

