/*
 * Decompiled with CFR 0.152.
 */
package ai.philterd.phileas.services.filters.regex;

import ai.philterd.phileas.model.enums.FilterType;
import ai.philterd.phileas.model.filter.FilterConfiguration;
import ai.philterd.phileas.model.filter.rules.regex.RegexFilter;
import ai.philterd.phileas.model.objects.Analyzer;
import ai.philterd.phileas.model.objects.FilterPattern;
import ai.philterd.phileas.model.objects.FilterResult;
import ai.philterd.phileas.model.objects.Span;
import ai.philterd.phileas.model.policy.Policy;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;

public class CurrencyFilter
extends RegexFilter {
    public CurrencyFilter(FilterConfiguration filterConfiguration) {
        super(FilterType.CURRENCY, filterConfiguration);
        Pattern currencyPattern1 = Pattern.compile("\\$\\d*(?:.(\\d+))?", 2);
        FilterPattern currency1 = new FilterPattern.FilterPatternBuilder(currencyPattern1, 0.8).build();
        this.contextualTerms = new HashSet();
        this.contextualTerms.add("dollars");
        this.contextualTerms.add("amount");
        this.analyzer = new Analyzer(this.contextualTerms, new FilterPattern[]{currency1});
    }

    public FilterResult filter(Policy policy, String context, String documentId, int piece, String input, Map<String, String> attributes) throws Exception {
        List spans = this.findSpans(policy, this.analyzer, input, context, documentId, attributes);
        List nonOverlappingSpans = Span.dropOverlappingSpans((List)spans);
        return new FilterResult(context, documentId, nonOverlappingSpans);
    }
}

