/*
 * Decompiled with CFR 0.152.
 */
package ai.philterd.phileas.services.filters.regex;

import ai.philterd.phileas.model.enums.FilterType;
import ai.philterd.phileas.model.filter.FilterConfiguration;
import ai.philterd.phileas.model.filter.rules.regex.RegexFilter;
import ai.philterd.phileas.model.objects.Analyzer;
import ai.philterd.phileas.model.objects.FilterPattern;
import ai.philterd.phileas.model.objects.FilterResult;
import ai.philterd.phileas.model.policy.Policy;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;

public class EmailAddressFilter
extends RegexFilter {
    private final boolean onlyValidTLDs;
    private Collection<String> tlds = null;

    public EmailAddressFilter(FilterConfiguration filterConfiguration, boolean onlyStrictMatches, boolean onlyValidTLDs) throws IOException {
        super(FilterType.EMAIL_ADDRESS, filterConfiguration);
        Pattern emailAddressPattern = onlyStrictMatches ? Pattern.compile("\\b(?:[a-z\\d!#$%&'*+/=?^_`{|}~-]+(?:\\.[a-z\\d!#$%&'*+/=?^_`{|}~-]+)*|\"(?:[\\x01-\\x08\\x0b\\x0c\\x0e-\\x1f\\x21\\x23-\\x5b\\x5d-\\x7f]|\\\\[\\x01-\\x09\\x0b\\x0c\\x0e-\\x7f])*\")@(?:(?:[a-z\\d](?:[a-z\\d-]*[a-z\\d])?\\.)+[a-z\\d](?:[a-z\\d-]*[a-z\\d])?|\\[(?:(?:25[0-5]|2[0-4][\\d]|[01]?[\\d][\\d]?)\\.){3}(?:25[0-5]|2[0-4][\\d]|[01]?[\\d][\\d]?|[a-z\\d-]*[a-z\\d]:(?:[\\x01-\\x08\\x0b\\x0c\\x0e-\\x1f\\x21-\\x5a\\x53-\\x7f]|\\\\[\\x01-\\x09\\x0b\\x0c\\x0e-\\x7f])+)\\b])", 2) : Pattern.compile("\\b[\\w.-]+?@(?:([a-zA-Z\\d\\-])+?\\.)+(?:[a-zA-Z\\d]{2,4})+\\b");
        FilterPattern email1 = new FilterPattern.FilterPatternBuilder(emailAddressPattern, 0.9).build();
        this.contextualTerms = new HashSet();
        this.contextualTerms.add("email");
        this.contextualTerms.add("e-mail");
        this.analyzer = new Analyzer(this.contextualTerms, new FilterPattern[]{email1});
        this.onlyValidTLDs = onlyValidTLDs;
        if (onlyValidTLDs) {
            File file = new File(((Object)((Object)this)).getClass().getClassLoader().getResource("tlds-alpha-by-domain.txt").getFile());
            List<String> rawTlds = Files.readAllLines(file.toPath(), Charset.defaultCharset());
            this.tlds = rawTlds.stream().filter(str -> !str.startsWith("#")).map(String::toLowerCase).map(s -> "." + s).toList();
        }
    }

    public FilterResult filter(Policy policy, String context, String documentId, int piece, String input, Map<String, String> attributes) throws Exception {
        List spans = this.findSpans(policy, this.analyzer, input, context, documentId, attributes);
        if (this.onlyValidTLDs) {
            spans.removeIf(str -> this.tlds.stream().noneMatch(str.getText()::endsWith));
        }
        return new FilterResult(context, documentId, spans);
    }
}

