/*
 * Decompiled with CFR 0.152.
 */
package ai.philterd.phileas.services.filters.regex;

import ai.philterd.phileas.model.enums.FilterType;
import ai.philterd.phileas.model.filter.FilterConfiguration;
import ai.philterd.phileas.model.filter.rules.regex.RegexFilter;
import ai.philterd.phileas.model.objects.Analyzer;
import ai.philterd.phileas.model.objects.FilterPattern;
import ai.philterd.phileas.model.objects.FilterResult;
import ai.philterd.phileas.model.objects.Span;
import ai.philterd.phileas.model.policy.Policy;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.validator.routines.IBANValidator;

public class IbanCodeFilter
extends RegexFilter {
    private final boolean validate;

    public IbanCodeFilter(FilterConfiguration filterConfiguration, boolean validate, boolean allowSpaces) {
        super(FilterType.IBAN_CODE, filterConfiguration);
        this.validate = validate;
        Pattern ibanPattern = allowSpaces ? Pattern.compile("\\b[A-Z]{2}[0-9]{2}[\\s]?[A-Z0-9]{4}[\\s]{0,1}[A-Z0-9]{4}[\\s]?[A-Z0-9]{4}[\\s]?[A-Z0-9]{4}[\\s]?[A-Z0-9]{2}\\b", 2) : Pattern.compile("\\b[A-Z]{2}[0-9]{2}[A-Z0-9]{1,30}\\b", 2);
        FilterPattern iban = new FilterPattern.FilterPatternBuilder(ibanPattern, 0.9).build();
        this.contextualTerms = new HashSet();
        this.contextualTerms.add("iban");
        this.contextualTerms.add("bank");
        this.analyzer = new Analyzer(this.contextualTerms, new FilterPattern[]{iban});
    }

    public FilterResult filter(Policy policy, String context, String documentId, int piece, String input, Map<String, String> attributes) throws Exception {
        List spans = this.findSpans(policy, this.analyzer, input, context, documentId, attributes);
        LinkedList<Span> validSpans = new LinkedList<Span>();
        if (this.validate) {
            for (Span span : spans) {
                boolean valid = IBANValidator.getInstance().isValid(span.getText().replaceAll("\\s", ""));
                if (!valid) continue;
                validSpans.add(span);
            }
        } else {
            validSpans.addAll(spans);
        }
        return new FilterResult(context, documentId, spans);
    }
}

