/*
 * Decompiled with CFR 0.152.
 */
package ai.philterd.phileas.services.filters.regex;

import ai.philterd.phileas.model.enums.FilterType;
import ai.philterd.phileas.model.filter.FilterConfiguration;
import ai.philterd.phileas.model.filter.rules.regex.RegexFilter;
import ai.philterd.phileas.model.objects.Analyzer;
import ai.philterd.phileas.model.objects.FilterPattern;
import ai.philterd.phileas.model.objects.FilterResult;
import ai.philterd.phileas.model.policy.Policy;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;

public class IpAddressFilter
extends RegexFilter {
    public IpAddressFilter(FilterConfiguration filterConfiguration) {
        super(FilterType.IP_ADDRESS, filterConfiguration);
        Pattern ipv4Pattern = Pattern.compile("([01]?\\d\\d?|2[0-4]\\d|25[0-5])\\.([01]?\\d\\d?|2[0-4]\\d|25[0-5])\\.([01]?\\d\\d?|2[0-4]\\d|25[0-5])\\.([01]?\\d\\d?|2[0-4]\\d|25[0-5])");
        FilterPattern ipv4 = new FilterPattern.FilterPatternBuilder(ipv4Pattern, 0.9).build();
        Pattern ipv6StdPattern = Pattern.compile("(?:[\\da-fA-F]{1,4}:){7}[\\da-fA-F]{1,4}");
        FilterPattern ipv61 = new FilterPattern.FilterPatternBuilder(ipv6StdPattern, 0.9).build();
        Pattern ipv6HexCompressedPattern = Pattern.compile("((?:[\\dA-Fa-f]{1,4}(?::[\\dA-Fa-f]{1,4})*)?)::((?:[\\dA-Fa-f]{1,4}(?::[\\dA-Fa-f]{1,4})*)?)");
        FilterPattern ipv62 = new FilterPattern.FilterPatternBuilder(ipv6HexCompressedPattern, 0.9).build();
        Pattern ipv6MixedCompressedPattern = Pattern.compile("((?:[\\dA-Fa-f]{1,4}(?::[\\dA-Fa-f]{1,4})*)?)::((?:[\\dA-Fa-f]{1,4}:(?:[\\dA-Fa-f]{1,4}:)*)?)");
        FilterPattern ipv63 = new FilterPattern.FilterPatternBuilder(ipv6MixedCompressedPattern, 0.9).build();
        Pattern IPV6_MIXED_UNCOMPRESSED_REGEX = Pattern.compile("(?:[\\da-fA-F]{1,4}:){6}");
        FilterPattern ipv64 = new FilterPattern.FilterPatternBuilder(IPV6_MIXED_UNCOMPRESSED_REGEX, 0.9).build();
        this.contextualTerms = new HashSet();
        this.contextualTerms.add("ipv4");
        this.contextualTerms.add("ipv6");
        this.contextualTerms.add("ip");
        this.contextualTerms.add("ip address");
        this.analyzer = new Analyzer(this.contextualTerms, new FilterPattern[]{ipv4, ipv61, ipv62, ipv63, ipv64});
    }

    public FilterResult filter(Policy policy, String context, String documentId, int piece, String input, Map<String, String> attributes) throws Exception {
        List spans = this.findSpans(policy, this.analyzer, input, context, documentId, attributes);
        return new FilterResult(context, documentId, spans);
    }
}

