/*
 * Decompiled with CFR 0.152.
 */
package ai.philterd.phileas.services.filters.regex;

import ai.philterd.phileas.model.enums.FilterType;
import ai.philterd.phileas.model.filter.FilterConfiguration;
import ai.philterd.phileas.model.filter.rules.regex.RegexFilter;
import ai.philterd.phileas.model.objects.Analyzer;
import ai.philterd.phileas.model.objects.FilterPattern;
import ai.philterd.phileas.model.objects.FilterResult;
import ai.philterd.phileas.model.policy.Policy;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;

public class MacAddressFilter
extends RegexFilter {
    public MacAddressFilter(FilterConfiguration filterConfiguration) {
        super(FilterType.MAC_ADDRESS, filterConfiguration);
        Pattern macAddressPattern = Pattern.compile("\\b([0-9A-Fa-f]{2}[:-]){5}([0-9A-Fa-f]{2})\\b");
        FilterPattern macAddress1 = new FilterPattern.FilterPatternBuilder(macAddressPattern, 0.9).build();
        this.contextualTerms = new HashSet();
        this.contextualTerms.add("mac");
        this.contextualTerms.add("network");
        this.analyzer = new Analyzer(this.contextualTerms, new FilterPattern[]{macAddress1});
    }

    public FilterResult filter(Policy policy, String context, String documentId, int piece, String input, Map<String, String> attributes) throws Exception {
        List spans = this.findSpans(policy, this.analyzer, input, context, documentId, attributes);
        return new FilterResult(context, documentId, spans);
    }
}

