/*
 * Decompiled with CFR 0.152.
 */
package ai.philterd.phileas.services.filters.regex;

import ai.philterd.phileas.model.enums.FilterType;
import ai.philterd.phileas.model.filter.FilterConfiguration;
import ai.philterd.phileas.model.filter.rules.regex.RegexFilter;
import ai.philterd.phileas.model.objects.Analyzer;
import ai.philterd.phileas.model.objects.FilterPattern;
import ai.philterd.phileas.model.objects.FilterResult;
import ai.philterd.phileas.model.policy.Policy;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;

public class PhoneNumberExtensionFilter
extends RegexFilter {
    public PhoneNumberExtensionFilter(FilterConfiguration filterConfiguration) {
        super(FilterType.PHONE_NUMBER_EXTENSION, filterConfiguration);
        Pattern phoneNumberExtendionPattern = Pattern.compile("\\bx[0-9]+\\b");
        FilterPattern phoneExtension1 = new FilterPattern.FilterPatternBuilder(phoneNumberExtendionPattern, 0.75).build();
        this.contextualTerms = new HashSet();
        this.contextualTerms.add("phone");
        this.contextualTerms.add("extension");
        this.contextualTerms.add("ext");
        this.analyzer = new Analyzer(this.contextualTerms, new FilterPattern[]{phoneExtension1});
    }

    public FilterResult filter(Policy policy, String context, String documentId, int piece, String input, Map<String, String> attributes) throws Exception {
        List spans = this.findSpans(policy, this.analyzer, input, context, documentId, attributes);
        return new FilterResult(context, documentId, spans);
    }
}

