/*
 * Decompiled with CFR 0.152.
 */
package ai.philterd.phileas.services.filters.regex;

import ai.philterd.phileas.model.enums.FilterType;
import ai.philterd.phileas.model.filter.FilterConfiguration;
import ai.philterd.phileas.model.filter.rules.regex.RegexFilter;
import ai.philterd.phileas.model.objects.Analyzer;
import ai.philterd.phileas.model.objects.FilterPattern;
import ai.philterd.phileas.model.objects.FilterResult;
import ai.philterd.phileas.model.policy.Policy;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;

public class StateAbbreviationFilter
extends RegexFilter {
    public StateAbbreviationFilter(FilterConfiguration filterConfiguration) {
        super(FilterType.STATE_ABBREVIATION, filterConfiguration);
        LinkedList<String> states = new LinkedList<String>();
        states.add("AL");
        states.add("AK");
        states.add("AZ");
        states.add("AR");
        states.add("CA");
        states.add("CO");
        states.add("CT");
        states.add("DE");
        states.add("FL");
        states.add("GA");
        states.add("HI");
        states.add("ID");
        states.add("IL");
        states.add("IN");
        states.add("IA");
        states.add("KS");
        states.add("KY");
        states.add("LA");
        states.add("ME");
        states.add("MD");
        states.add("MA");
        states.add("MI");
        states.add("MN");
        states.add("MS");
        states.add("MO");
        states.add("MT");
        states.add("NE");
        states.add("NV");
        states.add("NH");
        states.add("NJ");
        states.add("NM");
        states.add("NY");
        states.add("NC");
        states.add("ND");
        states.add("OH");
        states.add("OK");
        states.add("OR");
        states.add("PA");
        states.add("RI");
        states.add("SC");
        states.add("SD");
        states.add("TN");
        states.add("TX");
        states.add("UT");
        states.add("VT");
        states.add("VA");
        states.add("WA");
        states.add("WV");
        states.add("WI");
        states.add("WY");
        LinkedList<FilterPattern> filterPatterns = new LinkedList<FilterPattern>();
        for (String state : states) {
            Pattern STATE_REGEX = Pattern.compile("(?i)\\b" + state + "\\b");
            filterPatterns.add(new FilterPattern.FilterPatternBuilder(STATE_REGEX, 0.25).build());
        }
        this.contextualTerms = new HashSet();
        this.contextualTerms.add("state");
        this.analyzer = new Analyzer(filterPatterns);
    }

    public FilterResult filter(Policy policy, String context, String documentId, int piece, String input, Map<String, String> attributes) throws Exception {
        List spans = this.findSpans(policy, this.analyzer, input, context, documentId, attributes);
        return new FilterResult(context, documentId, spans);
    }
}

