/*
 * Decompiled with CFR 0.152.
 */
package ai.philterd.phileas.services.filters.regex;

import ai.philterd.phileas.model.enums.FilterType;
import ai.philterd.phileas.model.filter.FilterConfiguration;
import ai.philterd.phileas.model.filter.rules.regex.RegexFilter;
import ai.philterd.phileas.model.objects.Analyzer;
import ai.philterd.phileas.model.objects.FilterPattern;
import ai.philterd.phileas.model.objects.FilterResult;
import ai.philterd.phileas.model.policy.Policy;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;

public class StreetAddressFilter
extends RegexFilter {
    public StreetAddressFilter(FilterConfiguration filterConfiguration) {
        super(FilterType.STREET_ADDRESS, filterConfiguration);
        Pattern addressPattern = Pattern.compile("(?i)\\b\\d{1,6} +.*?\\b(avenue|ave|av e|cir|court|ct|street|st|drive|dr|lane|ln|road|rd|blvd|boulevard|plaza|parkway|pkwy)[.]?(([,\\s]+)?\\b(suite|ste|apt|apartment)[\\s]+\\d{1,6})?", 2);
        FilterPattern filterPattern = new FilterPattern.FilterPatternBuilder(addressPattern, 0.9).build();
        this.contextualTerms = new HashSet();
        this.contextualTerms.add("address");
        this.contextualTerms.add("location");
        this.analyzer = new Analyzer(this.contextualTerms, new FilterPattern[]{filterPattern});
    }

    public FilterResult filter(Policy policy, String context, String documentId, int piece, String input, Map<String, String> attributes) throws Exception {
        List spans = this.findSpans(policy, this.analyzer, input, context, documentId, attributes);
        return new FilterResult(context, documentId, spans);
    }
}

