/*
 * Decompiled with CFR 0.152.
 */
package ai.philterd.phileas.services.filters.regex;

import ai.philterd.phileas.model.enums.FilterType;
import ai.philterd.phileas.model.filter.FilterConfiguration;
import ai.philterd.phileas.model.filter.rules.regex.RegexFilter;
import ai.philterd.phileas.model.objects.Analyzer;
import ai.philterd.phileas.model.objects.FilterPattern;
import ai.philterd.phileas.model.objects.FilterResult;
import ai.philterd.phileas.model.policy.Policy;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;

public class TrackingNumberFilter
extends RegexFilter {
    public TrackingNumberFilter(FilterConfiguration filterConfiguration, boolean ups, boolean fedex, boolean usps) {
        super(FilterType.TRACKING_NUMBER, filterConfiguration);
        LinkedList<FilterPattern> filterPatterns = new LinkedList<FilterPattern>();
        if (fedex) {
            Pattern fedex1 = Pattern.compile("\\b\\d{20}\\b", 2);
            FilterPattern fedex1FilterPattern = new FilterPattern.FilterPatternBuilder(fedex1, 0.75).withClassification("fedex").build();
            filterPatterns.add(fedex1FilterPattern);
            Pattern fedex2 = Pattern.compile("\\b\\d{15}\\b", 2);
            FilterPattern fedex2FilterPattern = new FilterPattern.FilterPatternBuilder(fedex2, 0.75).withClassification("fedex").build();
            filterPatterns.add(fedex2FilterPattern);
            Pattern fedex3 = Pattern.compile("\\b\\d{12}\\b", 2);
            FilterPattern fedex3FilterPattern = new FilterPattern.FilterPatternBuilder(fedex3, 0.75).withClassification("fedex").build();
            filterPatterns.add(fedex3FilterPattern);
            Pattern fedex4 = Pattern.compile("\\b\\d{22}\\b", 2);
            FilterPattern fedex4FilterPattern = new FilterPattern.FilterPatternBuilder(fedex4, 0.75).withClassification("fedex").build();
            filterPatterns.add(fedex4FilterPattern);
        }
        if (ups) {
            Pattern ups1 = Pattern.compile("\\b(1Z)[\\dA-Z]{16}\\b", 2);
            FilterPattern ups1FilterPattern = new FilterPattern.FilterPatternBuilder(ups1, 0.9).withClassification("ups").build();
            filterPatterns.add(ups1FilterPattern);
            Pattern ups2 = Pattern.compile("\\b(T)+[\\dA-Z]{10}\\b", 2);
            FilterPattern ups2FilterPattern = new FilterPattern.FilterPatternBuilder(ups2, 0.9).withClassification("ups").build();
            filterPatterns.add(ups2FilterPattern);
            Pattern ups3 = Pattern.compile("\\b\\d{9}\\b", 2);
            FilterPattern ups3FilterPattern = new FilterPattern.FilterPatternBuilder(ups3, 0.75).withClassification("ups").build();
            filterPatterns.add(ups3FilterPattern);
            Pattern ups4 = Pattern.compile("\\b\\d{26}\\b", 2);
            FilterPattern ups4FilterPattern = new FilterPattern.FilterPatternBuilder(ups4, 0.75).withClassification("ups").build();
            filterPatterns.add(ups4FilterPattern);
        }
        if (usps) {
            Pattern usps1 = Pattern.compile("\\b(94|93|92|94|95)\\d{20}\\b", 2);
            FilterPattern usps1FilterPattern = new FilterPattern.FilterPatternBuilder(usps1, 0.9).withClassification("usps").build();
            filterPatterns.add(usps1FilterPattern);
            Pattern usps2 = Pattern.compile("\\b(94|93|92|94|95)\\d{22}\\b", 2);
            FilterPattern usps2FilterPattern = new FilterPattern.FilterPatternBuilder(usps2, 0.9).withClassification("usps").build();
            filterPatterns.add(usps2FilterPattern);
            Pattern usps3 = Pattern.compile("\\b(70|14|23|03)\\d{14}\\b", 2);
            FilterPattern usps3FilterPattern = new FilterPattern.FilterPatternBuilder(usps3, 0.9).withClassification("usps").build();
            filterPatterns.add(usps3FilterPattern);
            Pattern usps4 = Pattern.compile("\\b([A-Z]{2})\\d{9}([A-Z]{2})\\b", 2);
            FilterPattern usps4FilterPattern = new FilterPattern.FilterPatternBuilder(usps4, 0.9).withClassification("usps").build();
            filterPatterns.add(usps4FilterPattern);
            Pattern usps5 = Pattern.compile("\\b\\d{34}\\b", 2);
            FilterPattern usps5FilterPattern = new FilterPattern.FilterPatternBuilder(usps5, 0.75).withClassification("usps").build();
            filterPatterns.add(usps5FilterPattern);
            Pattern usps6 = Pattern.compile("\\b\\d{30}\\b", 2);
            FilterPattern usps6FilterPattern = new FilterPattern.FilterPatternBuilder(usps6, 0.75).withClassification("usps").build();
            filterPatterns.add(usps6FilterPattern);
            Pattern usps7 = Pattern.compile("\\b\\d{28}\\b", 2);
            FilterPattern usps7FilterPattern = new FilterPattern.FilterPatternBuilder(usps7, 0.75).withClassification("usps").build();
            filterPatterns.add(usps7FilterPattern);
            Pattern usps8 = Pattern.compile("\\b\\d{26}\\b", 2);
            FilterPattern usps8FilterPattern = new FilterPattern.FilterPatternBuilder(usps8, 0.75).withClassification("usps").build();
            filterPatterns.add(usps8FilterPattern);
        }
        this.contextualTerms = new HashSet();
        this.contextualTerms.add("tracking");
        this.contextualTerms.add("shipment");
        this.contextualTerms.add("shipping");
        this.contextualTerms.add("mailing");
        this.contextualTerms.add("sent");
        this.contextualTerms.add("delivered");
        this.analyzer = new Analyzer(this.contextualTerms, filterPatterns);
    }

    public FilterResult filter(Policy policy, String context, String documentId, int piece, String input, Map<String, String> attributes) throws Exception {
        List spans = this.findSpans(policy, this.analyzer, input, context, documentId, attributes);
        return new FilterResult(context, documentId, spans);
    }
}

