/*
 * Decompiled with CFR 0.152.
 */
package ai.philterd.phileas.services.filters.regex;

import ai.philterd.phileas.model.enums.FilterType;
import ai.philterd.phileas.model.filter.FilterConfiguration;
import ai.philterd.phileas.model.filter.rules.regex.RegexFilter;
import ai.philterd.phileas.model.objects.Analyzer;
import ai.philterd.phileas.model.objects.FilterPattern;
import ai.philterd.phileas.model.objects.FilterResult;
import ai.philterd.phileas.model.policy.Policy;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;

public class UrlFilter
extends RegexFilter {
    public UrlFilter(FilterConfiguration filterConfiguration, boolean requireHttpWwwPrefix) {
        super(FilterType.URL, filterConfiguration);
        Pattern urlWithOptionalProtocolPattern = Pattern.compile("(http:\\/\\/www\\.|https:\\/\\/www\\.|http:\\/\\/|https:\\/\\/)?[a-z\\d]+([\\-\\.]{1}[a-z\\d]+)*\\.[a-z]{2,5}(:[\\d]{1,5})?(\\/.*)?", 2);
        FilterPattern url1 = new FilterPattern.FilterPatternBuilder(urlWithOptionalProtocolPattern, 0.1).build();
        Pattern urlWithProtocolPattern = Pattern.compile("(www\\.|http:\\/\\/www\\.|https:\\/\\/www\\.|http:\\/\\/|https:\\/\\/)[a-z\\d]+([\\-\\.]{1}[a-z\\d]+)*\\.[a-z]{2,5}(:[\\d]{1,5})?(\\/.*)?", 2);
        FilterPattern url2 = new FilterPattern.FilterPatternBuilder(urlWithProtocolPattern, 0.8).build();
        Pattern urlIpv4AddressPattern = Pattern.compile("(http:\\/\\/www\\.|https:\\/\\/www\\.|http:\\/\\/|https:\\/\\/)?(?:[\\d]{1,3}\\.){3}[\\d]{1,3}(:[\\d]{1,5})?(\\/.*)?", 2);
        FilterPattern url3 = new FilterPattern.FilterPatternBuilder(urlIpv4AddressPattern, 0.8).build();
        Pattern urlIpv6AddressPattern = Pattern.compile("(http:\\/\\/www\\.|https:\\/\\/www\\.|http:\\/\\/|https:\\/\\/)?(([\\da-fA-F]{1,4}:){7,7}[\\da-fA-F]{1,4}|([\\da-fA-F]{1,4}:){1,7}:|([\\da-fA-F]{1,4}:){1,6}:[\\da-fA-F]{1,4}|([\\da-fA-F]{1,4}:){1,5}(:[\\da-fA-F]{1,4}){1,2}|([\\da-fA-F]{1,4}:){1,4}(:[\\da-fA-F]{1,4}){1,3}|([\\da-fA-F]{1,4}:){1,3}(:[\\da-fA-F]{1,4}){1,4}|([\\da-fA-F]{1,4}:){1,2}(:[\\da-fA-F]{1,4}){1,5}|[\\da-fA-F]{1,4}:((:[\\da-fA-F]{1,4}){1,6})|:((:[\\da-fA-F]{1,4}){1,7}|:)|fe80:(:[\\da-fA-F]{0,4}){0,4}%[\\da-zA-Z]{1,}|::(ffff(:0{1,4}){0,1}:){0,1}((25[0-5]|(2[0-4]|1{0,1}[\\d]){0,1}[\\d])\\.){3,3}(25[0-5]|(2[0-4]|1{0,1}[\\d]){0,1}[\\d])|([\\da-fA-F]{1,4}:){1,4}:((25[0-5]|(2[0-4]|1{0,1}[\\d]){0,1}[\\d])\\.){3,3}(25[0-5]|(2[0-4]|1{0,1}[\\d]){0,1}[\\d]))(:[\\d]{1,5})?(\\/.*)?", 2);
        FilterPattern url4 = new FilterPattern.FilterPatternBuilder(urlIpv6AddressPattern, 0.8).build();
        this.contextualTerms = new HashSet();
        this.contextualTerms.add("web");
        this.contextualTerms.add("webpage");
        this.contextualTerms.add("website");
        this.contextualTerms.add("url");
        this.contextualTerms.add("uri");
        this.contextualTerms.add("address");
        this.analyzer = requireHttpWwwPrefix ? new Analyzer(this.contextualTerms, new FilterPattern[]{url2, url3, url4}) : new Analyzer(this.contextualTerms, new FilterPattern[]{url1, url3, url4});
    }

    public FilterResult filter(Policy policy, String context, String documentId, int piece, String input, Map<String, String> attributes) throws Exception {
        List spans = this.findSpans(policy, this.analyzer, input, context, documentId, attributes);
        return new FilterResult(context, documentId, spans);
    }
}

