/*
 * Decompiled with CFR 0.152.
 */
package ai.philterd.phileas.services.filters.regex;

import ai.philterd.phileas.model.enums.FilterType;
import ai.philterd.phileas.model.filter.FilterConfiguration;
import ai.philterd.phileas.model.filter.rules.regex.RegexFilter;
import ai.philterd.phileas.model.objects.Analyzer;
import ai.philterd.phileas.model.objects.FilterPattern;
import ai.philterd.phileas.model.objects.FilterResult;
import ai.philterd.phileas.model.objects.Span;
import ai.philterd.phileas.model.policy.Policy;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.collections.CollectionUtils;

public class VinFilter
extends RegexFilter {
    public VinFilter(FilterConfiguration filterConfiguration) {
        super(FilterType.VIN, filterConfiguration);
        Pattern vinPattern = Pattern.compile("\\b[A-HJ-NPR-Z0-9]{17}\\b", 2);
        FilterPattern vin1 = new FilterPattern.FilterPatternBuilder(vinPattern, 0.9).build();
        this.contextualTerms = new HashSet();
        this.contextualTerms.add("vin");
        this.contextualTerms.add("car");
        this.contextualTerms.add("truck");
        this.contextualTerms.add("vehicle");
        this.contextualTerms.add("automobile");
        this.analyzer = new Analyzer(this.contextualTerms, new FilterPattern[]{vin1});
    }

    public FilterResult filter(Policy policy, String context, String documentId, int piece, String input, Map<String, String> attributes) throws Exception {
        List spans = this.findSpans(policy, this.analyzer, input, context, documentId, attributes);
        CollectionUtils.filter((Collection)spans, object -> {
            Span s = (Span)object;
            return this.isVinValid(input.substring(s.getCharacterStart(), s.getCharacterEnd()));
        });
        return new FilterResult(context, documentId, spans);
    }

    private boolean isVinValid(String vin) {
        int[] values = new int[]{1, 2, 3, 4, 5, 6, 7, 8, 0, 1, 2, 3, 4, 5, 0, 7, 0, 9, 2, 3, 4, 5, 6, 7, 8, 9};
        int[] weights = new int[]{8, 7, 6, 5, 4, 3, 2, 10, 0, 9, 8, 7, 6, 5, 4, 3, 2};
        String s = vin;
        s = s.replaceAll("-", "");
        s = s.replaceAll(" ", "");
        if ((s = s.toUpperCase()).length() != 17) {
            return false;
        }
        int sum = 0;
        for (int i = 0; i < 17; ++i) {
            int value;
            char c = s.charAt(i);
            int weight = weights[i];
            if (c >= 'A' && c <= 'Z') {
                value = values[c - 65];
                if (value == 0) {
                    return false;
                }
            } else if (c >= '0' && c <= '9') {
                value = c - 48;
            } else {
                return false;
            }
            sum += weight * value;
        }
        char check = s.charAt(8);
        if ((sum %= 11) == 10 && check == 'X') {
            return true;
        }
        return sum == this.transliterate(check);
    }

    private int transliterate(char check) {
        if (check == 'A' || check == 'J') {
            return 1;
        }
        if (check == 'B' || check == 'K' || check == 'S') {
            return 2;
        }
        if (check == 'C' || check == 'L' || check == 'T') {
            return 3;
        }
        if (check == 'D' || check == 'M' || check == 'U') {
            return 4;
        }
        if (check == 'E' || check == 'N' || check == 'V') {
            return 5;
        }
        if (check == 'F' || check == 'W') {
            return 6;
        }
        if (check == 'G' || check == 'P' || check == 'X') {
            return 7;
        }
        if (check == 'H' || check == 'Y') {
            return 8;
        }
        if (check == 'R' || check == 'Z') {
            return 9;
        }
        if (Integer.valueOf(Character.getNumericValue(check)) != null) {
            return Character.getNumericValue(check);
        }
        return -1;
    }
}

