/*
 * Decompiled with CFR 0.152.
 */
package ai.philterd.phileas.services.filters.regex;

import ai.philterd.phileas.model.enums.FilterType;
import ai.philterd.phileas.model.filter.FilterConfiguration;
import ai.philterd.phileas.model.filter.rules.regex.RegexFilter;
import ai.philterd.phileas.model.metadata.zipcode.ZipCodeMetadataRequest;
import ai.philterd.phileas.model.metadata.zipcode.ZipCodeMetadataResponse;
import ai.philterd.phileas.model.metadata.zipcode.ZipCodeMetadataService;
import ai.philterd.phileas.model.objects.Analyzer;
import ai.philterd.phileas.model.objects.FilterPattern;
import ai.philterd.phileas.model.objects.FilterResult;
import ai.philterd.phileas.model.objects.Span;
import ai.philterd.phileas.model.policy.Policy;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;

public class ZipCodeFilter
extends RegexFilter {
    private final boolean validate;

    public ZipCodeFilter(FilterConfiguration filterConfiguration, boolean requireDelimiter, boolean validate) {
        super(FilterType.ZIP_CODE, filterConfiguration);
        this.validate = validate;
        this.contextualTerms = new HashSet();
        this.contextualTerms.add("zip");
        this.contextualTerms.add("zipcode");
        this.contextualTerms.add("postal");
        if (requireDelimiter) {
            Pattern zipCodePattern = Pattern.compile("\\b[0-9]{5}(?:-[0-9]{4})?\\b");
            FilterPattern zipCode = new FilterPattern.FilterPatternBuilder(zipCodePattern, 0.9).build();
            this.analyzer = new Analyzer(this.contextualTerms, new FilterPattern[]{zipCode});
        } else {
            Pattern zipCodePattern = Pattern.compile("\\b[0-9]{5}(?:-?[0-9]{4})?\\b");
            FilterPattern zipCode = new FilterPattern.FilterPatternBuilder(zipCodePattern, 0.5).build();
            this.analyzer = new Analyzer(this.contextualTerms, new FilterPattern[]{zipCode});
        }
    }

    public FilterResult filter(Policy policy, String context, String documentId, int piece, String input, Map<String, String> attributes) throws Exception {
        List spans = this.findSpans(policy, this.analyzer, input, context, documentId, attributes);
        if (this.validate) {
            ZipCodeMetadataService zipCodeMetadataService = new ZipCodeMetadataService();
            for (Span span : spans) {
                String zipCode = span.getText().substring(0, 5);
                ZipCodeMetadataResponse zipCodeMetadataResponse = zipCodeMetadataService.getMetadata(new ZipCodeMetadataRequest(zipCode));
                if (zipCodeMetadataResponse.isExists()) continue;
                span.setApplied(false);
            }
        }
        return new FilterResult(context, documentId, spans);
    }
}

