/*
 * Decompiled with CFR 0.152.
 */
package ai.philterd.phileas.services.postfilters;

import ai.philterd.phileas.model.objects.PostFilterResult;
import ai.philterd.phileas.model.objects.Span;
import ai.philterd.phileas.model.policy.IgnoredPattern;
import ai.philterd.phileas.model.services.PostFilter;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class IgnoredPatternsFilter
extends PostFilter {
    private static final Logger LOGGER = LogManager.getLogger(IgnoredPatternsFilter.class);
    private final List<IgnoredPattern> ignoredPatterns;

    public IgnoredPatternsFilter(List<IgnoredPattern> ignoredPatterns) {
        this.ignoredPatterns = ignoredPatterns;
    }

    protected PostFilterResult process(String text, Span span) {
        String spanText = span.getText(text);
        for (IgnoredPattern pattern : this.ignoredPatterns) {
            boolean ignored = spanText.matches(pattern.getPattern());
            if (!ignored) continue;
            return new PostFilterResult(span, true);
        }
        return new PostFilterResult(span, false);
    }
}

