/*
 * Decompiled with CFR 0.152.
 */
package ai.philterd.phileas.services.postfilters;

import ai.philterd.phileas.model.objects.PostFilterResult;
import ai.philterd.phileas.model.objects.Span;
import ai.philterd.phileas.model.policy.Ignored;
import ai.philterd.phileas.model.services.PostFilter;
import ai.philterd.phileas.model.utils.BloomFilter;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class IgnoredTermsFilter
extends PostFilter {
    private static final Logger LOGGER = LogManager.getLogger(IgnoredTermsFilter.class);
    private final BloomFilter<String> bloomFilter;
    private final Set<String> ignoredTerms = new HashSet<String>();
    private final Ignored ignored;

    public IgnoredTermsFilter(Ignored ignored) throws IOException {
        this.ignored = ignored;
        HashSet ignoredTermsFromFiles = new HashSet();
        for (String file : ignored.getFiles()) {
            ignoredTermsFromFiles.addAll(FileUtils.readLines((File)new File(file), (Charset)Charset.defaultCharset()));
        }
        if (ignored.isCaseSensitive()) {
            this.ignoredTerms.addAll(ignored.getTerms());
            this.ignoredTerms.addAll(ignoredTermsFromFiles);
        } else {
            LOGGER.debug("Ignore terms is not case sensitive.");
            this.ignoredTerms.addAll(ignored.getTerms().stream().map(String::toLowerCase).toList());
            this.ignoredTerms.addAll(ignoredTermsFromFiles.stream().map(String::toLowerCase).toList());
        }
        this.bloomFilter = new BloomFilter(this.ignoredTerms);
        LOGGER.info("Added {} terms to ignore.", (Object)this.ignoredTerms.size());
    }

    protected PostFilterResult process(String text, Span span) {
        boolean mightContain;
        String spanText = span.getText(text);
        if (!this.ignored.isCaseSensitive()) {
            spanText = spanText.toLowerCase();
        }
        boolean ignored = (mightContain = this.bloomFilter.mightContain((Object)spanText)) ? this.ignoredTerms.contains(spanText) : false;
        return new PostFilterResult(span, ignored);
    }
}

