/*
 * Decompiled with CFR 0.152.
 */
package ai.philterd.phileas.services.validators;

import ai.philterd.phileas.model.objects.Span;
import ai.philterd.phileas.model.services.SpanValidator;
import java.time.DateTimeException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.ResolverStyle;
import java.util.Locale;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DateSpanValidator
implements SpanValidator {
    private static final Logger LOGGER = LogManager.getLogger(DateSpanValidator.class);
    private static SpanValidator spanValidator;

    public static SpanValidator getInstance() {
        if (spanValidator == null) {
            spanValidator = new DateSpanValidator();
        }
        return spanValidator;
    }

    private DateSpanValidator() {
    }

    public boolean validate(Span span) {
        boolean valid;
        try {
            LOGGER.info("Date {} : Pattern {}", (Object)span.getText(), (Object)span.getPattern());
            DateTimeFormatter dtf = DateTimeFormatter.ofPattern(span.getPattern(), Locale.US).withResolverStyle(ResolverStyle.STRICT);
            LocalDateTime localDateTime = LocalDate.parse(span.getText(), dtf).atStartOfDay();
            int length = String.valueOf(localDateTime.getYear()).length();
            int year = localDateTime.getYear();
            if (length == 2) {
                year += 2000;
            }
            valid = year >= 1800 && year <= 2200;
        }
        catch (DateTimeException ex) {
            valid = false;
            LOGGER.error(ex.getMessage());
        }
        LOGGER.debug("Validated date span {} against pattern {}: Valid = {}", (Object)span.getText(), (Object)span.getPattern(), (Object)valid);
        return valid;
    }
}

