/*
 * Decompiled with CFR 0.152.
 */
package ai.philterd.phileas.model.cache;

import ai.philterd.phileas.model.enums.FilterType;
import ai.philterd.phileas.model.objects.Alert;
import ai.philterd.phileas.model.objects.Span;
import ai.philterd.phileas.model.objects.SpanVector;
import ai.philterd.phileas.model.services.CacheService;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.StringUtils;

public class InMemoryCache
implements CacheService {
    private final Map<String, Map<FilterType, SpanVector>> vectorCache = new HashMap<String, Map<FilterType, SpanVector>>();
    private final Map<String, String> policyCache = new HashMap<String, String>();
    private final Map<String, String> anonymizationCache = new ConcurrentHashMap<String, String>();
    private final List<Alert> alerts = new LinkedList<Alert>();

    @Override
    public void generateAlert(String policy, String strategyId, String context, String documentId, FilterType filterType) {
        this.alerts.add(new Alert(policy, strategyId, context, documentId, filterType.getType()));
    }

    @Override
    public List<Alert> getAlerts() {
        return this.alerts;
    }

    @Override
    public void deleteAlert(String alertId) {
        this.alerts.removeIf(alert -> StringUtils.equalsIgnoreCase((CharSequence)alert.getId(), (CharSequence)alertId));
    }

    @Override
    public void clearAlerts() {
        this.alerts.clear();
    }

    @Override
    public String generateAnonymizationCacheKey(String context, String token) {
        return DigestUtils.md5Hex((String)(context + "|" + token));
    }

    @Override
    public void putAnonymizedToken(String context, String token, String replacement) {
        this.anonymizationCache.put(this.generateAnonymizationCacheKey(context, token), replacement);
    }

    @Override
    public String getAnonymizedToken(String context, String token) {
        return this.anonymizationCache.get(this.generateAnonymizationCacheKey(context, token));
    }

    @Override
    public void removeAnonymizedToken(String context, String token) {
        this.anonymizationCache.remove(this.generateAnonymizationCacheKey(context, token));
    }

    @Override
    public boolean containsAnonymizedToken(String context, String token) {
        return this.anonymizationCache.containsKey(this.generateAnonymizationCacheKey(context, token));
    }

    @Override
    public boolean containsAnonymizedTokenValue(String context, String replacement) {
        return this.anonymizationCache.containsValue(replacement);
    }

    @Override
    public List<String> getPolicies() {
        return new ArrayList<String>(this.policyCache.keySet());
    }

    @Override
    public String getPolicy(String policyName) throws IOException {
        return this.policyCache.get(policyName);
    }

    @Override
    public Map<String, String> getAllPolicies() {
        return this.policyCache;
    }

    @Override
    public void insertPolicy(String policyName, String policy) {
        this.policyCache.put(policyName, policy);
    }

    @Override
    public void removePolicy(String policyName) {
        this.policyCache.remove(policyName);
    }

    @Override
    public void clearPolicyCache() {
        this.policyCache.clear();
    }

    @Override
    public void hashAndInsert(String context, double[] hashes, Span span, int vectorSize) {
        this.initializeVectorCache(context);
        for (double i = 0.0; i < (double)hashes.length; i += 1.0) {
            if (hashes[(int)i] == 0.0) continue;
            if (this.vectorCache.get(context).get((Object)span.getFilterType()).getVectorIndexes().get(i) == null) {
                this.vectorCache.get(context).get((Object)span.getFilterType()).getVectorIndexes().putIfAbsent(i, 0.0);
            }
            double value = this.vectorCache.get(context).get((Object)span.getFilterType()).getVectorIndexes().get(i);
            this.vectorCache.get(context).get((Object)span.getFilterType()).getVectorIndexes().put(i, value + 1.0);
        }
    }

    @Override
    public Map<Double, Double> getVectorRepresentation(String context, FilterType filterType) {
        this.initializeVectorCache(context);
        return this.vectorCache.get(context).get((Object)filterType).getVectorIndexes();
    }

    private void initializeVectorCache(String context) {
        if (this.vectorCache.get(context) == null) {
            HashMap<FilterType, SpanVector> vector = new HashMap<FilterType, SpanVector>();
            for (FilterType filterType : FilterType.values()) {
                vector.put(filterType, new SpanVector());
            }
            this.vectorCache.put(context, vector);
        }
    }
}

