/*
 * Decompiled with CFR 0.152.
 */
package ai.philterd.phileas.model.conditions;

import ai.philterd.phileas.model.conditions.ParsedCondition;
import ai.philterd.phileas.model.conditions.parser.FilterConditionBaseListener;
import ai.philterd.phileas.model.conditions.parser.FilterConditionLexer;
import ai.philterd.phileas.model.conditions.parser.FilterConditionParser;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.LinkedBlockingQueue;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CodePointCharStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.ParseTreeListener;
import org.antlr.v4.runtime.tree.ParseTreeWalker;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ParserListener
extends FilterConditionBaseListener {
    protected static final Logger LOGGER = LogManager.getLogger(ParserListener.class);
    private final List<ParsedCondition> conditions = new LinkedList<ParsedCondition>();
    private final Queue<String> terminals = new LinkedBlockingQueue<String>();

    @Override
    public void visitTerminal(TerminalNode node) {
        this.terminals.add(node.getText());
        LOGGER.debug("Processing terminal node: [{}]", (Object)node.getText());
    }

    public static List<ParsedCondition> getTerminals(String condition) {
        CodePointCharStream codePointCharStream = CharStreams.fromString((String)condition);
        FilterConditionLexer lexer = new FilterConditionLexer((CharStream)codePointCharStream);
        CommonTokenStream tokens = new CommonTokenStream((TokenSource)lexer);
        FilterConditionParser parser = new FilterConditionParser((TokenStream)tokens);
        FilterConditionParser.ExpressionContext tree = parser.expression();
        ParserListener parserListener = new ParserListener();
        ParseTreeWalker walker = new ParseTreeWalker();
        walker.walk((ParseTreeListener)parserListener, (ParseTree)tree);
        return parserListener.getConditions();
    }

    private List<ParsedCondition> getConditions() {
        ParsedCondition parsedCondition = new ParsedCondition();
        parsedCondition.setField(this.terminals.poll());
        parsedCondition.setOperator(this.terminals.poll());
        parsedCondition.setValue(this.terminals.poll());
        this.conditions.add(parsedCondition);
        if (StringUtils.equalsIgnoreCase((CharSequence)this.terminals.poll(), (CharSequence)"AND")) {
            this.getConditions();
        }
        return this.conditions;
    }
}

