/*
 * Decompiled with CFR 0.152.
 */
package ai.philterd.phileas.model.filter;

import ai.philterd.phileas.model.enums.FilterType;
import ai.philterd.phileas.model.filter.FilterConfiguration;
import ai.philterd.phileas.model.objects.FilterPattern;
import ai.philterd.phileas.model.objects.FilterResult;
import ai.philterd.phileas.model.objects.Position;
import ai.philterd.phileas.model.objects.Replacement;
import ai.philterd.phileas.model.policy.Crypto;
import ai.philterd.phileas.model.policy.FPE;
import ai.philterd.phileas.model.policy.IgnoredPattern;
import ai.philterd.phileas.model.policy.Policy;
import ai.philterd.phileas.model.policy.filters.Identifier;
import ai.philterd.phileas.model.policy.filters.strategies.AbstractFilterStrategy;
import ai.philterd.phileas.model.services.AlertService;
import ai.philterd.phileas.model.services.AnonymizationService;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class Filter {
    protected static final Logger LOGGER = LogManager.getLogger(Filter.class);
    protected final FilterType filterType;
    protected final AlertService alertService;
    protected final AnonymizationService anonymizationService;
    protected final List<? extends AbstractFilterStrategy> strategies;
    protected String classification;
    protected Set<String> ignored;
    protected List<IgnoredPattern> ignoredPatterns;
    protected final Crypto crypto;
    protected final FPE fpe;
    protected int windowSize;
    protected int priority;

    public abstract FilterResult filter(Policy var1, String var2, String var3, int var4, String var5, Map<String, String> var6) throws Exception;

    public abstract int getOccurrences(Policy var1, String var2, Map<String, String> var3) throws Exception;

    public Filter(FilterType filterType, FilterConfiguration filterConfiguration) {
        this.filterType = filterType;
        this.strategies = filterConfiguration.getStrategies();
        this.anonymizationService = filterConfiguration.getAnonymizationService();
        this.alertService = filterConfiguration.getAlertService();
        this.ignoredPatterns = filterConfiguration.getIgnoredPatterns();
        this.ignored = filterConfiguration.getIgnored();
        this.crypto = filterConfiguration.getCrypto();
        this.fpe = filterConfiguration.getFPE();
        this.windowSize = filterConfiguration.getWindowSize();
        this.priority = filterConfiguration.getPriority();
        if (this.ignored == null) {
            this.ignored = new LinkedHashSet<String>();
        }
        if (this.ignoredPatterns == null) {
            this.ignoredPatterns = new LinkedList<IgnoredPattern>();
        }
        if (CollectionUtils.isNotEmpty(filterConfiguration.getIgnoredFiles())) {
            for (String fileName : filterConfiguration.getIgnoredFiles()) {
                File file = new File(fileName);
                if (file.exists()) {
                    try {
                        List words = FileUtils.readLines((File)file, (Charset)Charset.defaultCharset());
                        this.ignored.addAll(words);
                    }
                    catch (IOException ex) {
                        LOGGER.error("Unable to process file of ignored terms: {}", (Object)fileName, (Object)ex);
                    }
                    continue;
                }
                LOGGER.error("Ignore list file specified in policy does not exist: {}", (Object)fileName);
            }
        }
        if (CollectionUtils.isNotEmpty(this.ignored)) {
            this.ignored = this.ignored.stream().map(String::toLowerCase).collect(Collectors.toSet());
        }
    }

    public String[] getWindow(String text, int characterStart, int characterEnd) {
        int finalEnd;
        int finalStart;
        if (characterStart < 0) {
            characterStart = 0;
        }
        if (characterEnd > text.length()) {
            characterEnd = text.length();
        }
        int spacesSeen = 0;
        for (finalStart = characterStart; finalStart != 0 && spacesSeen <= this.windowSize; --finalStart) {
            if (finalStart >= text.length() || !Character.isWhitespace(text.charAt(finalStart))) continue;
            ++spacesSeen;
        }
        spacesSeen = 0;
        for (finalEnd = characterEnd; finalEnd != text.length() && spacesSeen <= this.windowSize; ++finalEnd) {
            if (!Character.isWhitespace(text.charAt(finalEnd))) continue;
            ++spacesSeen;
        }
        String[] tokens = text.substring(finalStart + 1, finalEnd).trim().split("\\s");
        for (int i = 0; i < tokens.length; ++i) {
            tokens[i] = tokens[i].replaceAll("\\p{Punct}", "");
        }
        return tokens;
    }

    public Replacement getReplacement(Policy policy, String context, String documentId, String token, String[] window, double confidence, String classification, Map<String, String> attributes, FilterPattern filterPattern) throws Exception {
        if (this.strategies != null && !this.strategies.isEmpty()) {
            for (AbstractFilterStrategy abstractFilterStrategy : this.strategies) {
                String condition = abstractFilterStrategy.getCondition();
                boolean hasCondition = StringUtils.isNotEmpty((CharSequence)condition);
                if (hasCondition) {
                    boolean evaluates = abstractFilterStrategy.evaluateCondition(policy, context, documentId, token, window, condition, confidence, attributes);
                    if (!evaluates) continue;
                    if (abstractFilterStrategy.isAlert()) {
                        LOGGER.info("Generating alert for strategy ID {}", (Object)abstractFilterStrategy.getId());
                        this.alertService.generateAlert(policy.getName(), abstractFilterStrategy.getId(), documentId, context, this.filterType);
                    }
                    return abstractFilterStrategy.getReplacement(classification, context, documentId, token, window, this.crypto, this.fpe, this.anonymizationService, filterPattern);
                }
                return abstractFilterStrategy.getReplacement(classification, context, documentId, token, window, this.crypto, this.fpe, this.anonymizationService, filterPattern);
            }
        } else {
            LOGGER.warn("No filter strategies found for filter type {}. Defaulting to redaction.", (Object)this.filterType.getType());
            return new Replacement("{{{REDACTED-%t}}}".replaceAll("%t", this.filterType.getType()));
        }
        return new Replacement(token, false);
    }

    public boolean isIgnored(String token) {
        boolean isIgnored = this.ignored.contains(token.toLowerCase());
        if (!isIgnored) {
            for (IgnoredPattern ignoredPattern : this.ignoredPatterns) {
                if (!token.matches(ignoredPattern.getPattern())) continue;
                isIgnored = true;
                break;
            }
        }
        return isIgnored;
    }

    public static List<? extends AbstractFilterStrategy> getIdentifierFilterStrategies(Policy policy, String name) {
        List<Identifier> identifiers = policy.getIdentifiers().getIdentifiers();
        Identifier identifier = identifiers.stream().filter(p -> p.getClassification().equalsIgnoreCase(name)).findFirst().get();
        return identifier.getIdentifierFilterStrategies();
    }

    public Map<Position, String> splitWithIndexes(String text, String delimiter) {
        HashMap<Position, String> splitsWithIndexes = new HashMap<Position, String>();
        String[] tokens = text.split(delimiter);
        int index = 0;
        for (String token : tokens) {
            splitsWithIndexes.put(new Position(index, index + token.length()), token);
            index += token.length() + delimiter.length();
        }
        return splitsWithIndexes;
    }

    public FilterType getFilterType() {
        return this.filterType;
    }

    public String getClassification() {
        return this.classification;
    }

    public Crypto getCrypto() {
        return this.crypto;
    }

    public List<IgnoredPattern> getIgnoredPatterns() {
        return this.ignoredPatterns;
    }

    public int getWindowSize() {
        return this.windowSize;
    }

    public int getPriority() {
        return this.priority;
    }
}

