/*
 * Decompiled with CFR 0.152.
 */
package ai.philterd.phileas.model.filter;

import ai.philterd.phileas.model.policy.Crypto;
import ai.philterd.phileas.model.policy.FPE;
import ai.philterd.phileas.model.policy.IgnoredPattern;
import ai.philterd.phileas.model.policy.filters.strategies.AbstractFilterStrategy;
import ai.philterd.phileas.model.services.AlertService;
import ai.philterd.phileas.model.services.AnonymizationService;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class FilterConfiguration {
    private final List<? extends AbstractFilterStrategy> strategies;
    private final AnonymizationService anonymizationService;
    private final AlertService alertService;
    private final Set<String> ignored;
    private final Set<String> ignoredFiles;
    private final List<IgnoredPattern> ignoredPatterns;
    private final Crypto crypto;
    private final FPE fpe;
    private int windowSize = 5;
    private int priority;

    private FilterConfiguration(List<? extends AbstractFilterStrategy> strategies, AnonymizationService anonymizationService, AlertService alertService, Set<String> ignored, Set<String> ignoredFiles, List<IgnoredPattern> ignoredPatterns, Crypto crypto, FPE fpe, int windowSize, int priority) {
        this.strategies = strategies;
        this.anonymizationService = anonymizationService;
        this.alertService = alertService;
        this.ignored = ignored;
        this.ignoredFiles = ignoredFiles;
        this.ignoredPatterns = ignoredPatterns;
        this.crypto = crypto;
        this.fpe = fpe;
        this.windowSize = windowSize;
        this.priority = priority;
    }

    public List<? extends AbstractFilterStrategy> getStrategies() {
        return this.strategies;
    }

    public AnonymizationService getAnonymizationService() {
        return this.anonymizationService;
    }

    public AlertService getAlertService() {
        return this.alertService;
    }

    public Set<String> getIgnored() {
        return this.ignored;
    }

    public Set<String> getIgnoredFiles() {
        return this.ignoredFiles;
    }

    public List<IgnoredPattern> getIgnoredPatterns() {
        return this.ignoredPatterns;
    }

    public Crypto getCrypto() {
        return this.crypto;
    }

    public FPE getFPE() {
        return this.fpe;
    }

    public int getWindowSize() {
        return this.windowSize;
    }

    public int getPriority() {
        return this.priority;
    }

    public static class FilterConfigurationBuilder {
        private List<? extends AbstractFilterStrategy> strategies;
        private AnonymizationService anonymizationService;
        private AlertService alertService;
        private Set<String> ignored;
        private Set<String> ignoredFiles;
        private List<IgnoredPattern> ignoredPatterns;
        private Crypto crypto;
        private FPE fpe;
        private int windowSize;
        private int priority;

        public FilterConfiguration build() {
            this.validate();
            return new FilterConfiguration(this.strategies, this.anonymizationService, this.alertService, this.ignored, this.ignoredFiles, this.ignoredPatterns, this.crypto, this.fpe, this.windowSize, this.priority);
        }

        private void validate() {
            if (CollectionUtils.isNotEmpty(this.strategies)) {
                for (AbstractFilterStrategy abstractFilterStrategy : this.strategies) {
                    if (StringUtils.equalsIgnoreCase((CharSequence)"FPE_ENCRYPT_REPLACE", (CharSequence)abstractFilterStrategy.getStrategy())) {
                        if (this.fpe != null) {
                            if (StringUtils.isEmpty((CharSequence)this.fpe.getKey())) {
                                throw new RuntimeException("Invalid configuration for filter: Missing FPE encryption key.");
                            }
                            if (!StringUtils.isEmpty((CharSequence)this.fpe.getTweak())) continue;
                            throw new RuntimeException("Invalid configuration for filter: Missing FPE encryption tweak value.");
                        }
                        throw new RuntimeException("Invalid configuration for filter: Missing FPE encryption property.");
                    }
                    if (!StringUtils.equalsIgnoreCase((CharSequence)"CRYPTO_REPLACE", (CharSequence)abstractFilterStrategy.getStrategy())) continue;
                    if (this.crypto != null) {
                        if (StringUtils.isEmpty((CharSequence)this.crypto.getKey())) {
                            throw new RuntimeException("Invalid configuration for filter: Missing crypto encryption key.");
                        }
                        if (!StringUtils.isEmpty((CharSequence)this.crypto.getIv())) continue;
                        throw new RuntimeException("Invalid configuration for filter: Missing crypto encryption IV value.");
                    }
                    throw new RuntimeException("Invalid configuration for filter: Missing crypto encryption property.");
                }
            }
        }

        public FilterConfigurationBuilder withStrategies(List<? extends AbstractFilterStrategy> strategies) {
            this.strategies = strategies;
            return this;
        }

        public FilterConfigurationBuilder withAnonymizationService(AnonymizationService anonymizationService) {
            this.anonymizationService = anonymizationService;
            return this;
        }

        public FilterConfigurationBuilder withAlertService(AlertService alertService) {
            this.alertService = alertService;
            return this;
        }

        public FilterConfigurationBuilder withIgnored(Set<String> ignored) {
            this.ignored = ignored;
            return this;
        }

        public FilterConfigurationBuilder withIgnoredFiles(Set<String> ignoredFiles) {
            this.ignoredFiles = ignoredFiles;
            return this;
        }

        public FilterConfigurationBuilder withIgnoredPatterns(List<IgnoredPattern> ignoredPatterns) {
            this.ignoredPatterns = ignoredPatterns;
            return this;
        }

        public FilterConfigurationBuilder withCrypto(Crypto crypto) {
            this.crypto = crypto;
            return this;
        }

        public FilterConfigurationBuilder withFPE(FPE fpe) {
            this.fpe = fpe;
            return this;
        }

        public FilterConfigurationBuilder withWindowSize(int windowSize) {
            this.windowSize = windowSize;
            return this;
        }

        public FilterConfigurationBuilder withPriority(int priority) {
            this.priority = priority;
            return this;
        }
    }
}

