/*
 * Decompiled with CFR 0.152.
 */
package ai.philterd.phileas.model.filter.rules;

import ai.philterd.phileas.model.enums.FilterType;
import ai.philterd.phileas.model.filter.Filter;
import ai.philterd.phileas.model.filter.FilterConfiguration;
import ai.philterd.phileas.model.objects.Analyzer;
import ai.philterd.phileas.model.objects.ConfidenceModifier;
import ai.philterd.phileas.model.objects.FilterPattern;
import ai.philterd.phileas.model.objects.Position;
import ai.philterd.phileas.model.objects.Replacement;
import ai.philterd.phileas.model.objects.Span;
import ai.philterd.phileas.model.policy.Policy;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public abstract class RulesFilter
extends Filter {
    protected Set<String> contextualTerms;

    public RulesFilter(FilterType filterType, FilterConfiguration filterConfiguration) {
        super(filterType, filterConfiguration);
    }

    public List<Span> postFilter(List<Span> spans) {
        return spans;
    }

    protected List<Span> findSpans(Policy policy, Analyzer analyzer, String input, String context, String documentId, Map<String, String> attributes) throws Exception {
        LinkedList<Span> spans = new LinkedList<Span>();
        if (policy.getIdentifiers().hasFilter(this.filterType)) {
            for (FilterPattern filterPattern : analyzer.getFilterPatterns()) {
                Matcher matcher = filterPattern.getPattern().matcher(input);
                while (matcher.find()) {
                    int characterEnd;
                    String token = matcher.group(filterPattern.getGroupNumber());
                    int characterStart = matcher.start(filterPattern.getGroupNumber());
                    if (Span.doesSpanExist(characterStart, characterEnd = matcher.end(filterPattern.getGroupNumber()), spans)) continue;
                    boolean ignored = this.isIgnored(token);
                    double initialConfidence = filterPattern.getInitialConfidence();
                    if (CollectionUtils.isNotEmpty(filterPattern.getConfidenceModifiers())) {
                        for (ConfidenceModifier modifier : filterPattern.getConfidenceModifiers()) {
                            if (modifier.getConfidenceCondition() == ConfidenceModifier.ConfidenceCondition.CHARACTER_SEQUENCE_BEFORE && characterStart > 0 && StringUtils.equalsIgnoreCase((CharSequence)String.valueOf(input.charAt(characterStart - 1)), (CharSequence)modifier.getCharacters())) {
                                initialConfidence = modifier.getConfidenceDelta() != 0.0 ? (initialConfidence += modifier.getConfidenceDelta()) : modifier.getConfidence();
                            }
                            if (modifier.getConfidenceCondition() == ConfidenceModifier.ConfidenceCondition.CHARACTER_SEQUENCE_AFTER && characterEnd < input.length() && StringUtils.equalsIgnoreCase((CharSequence)String.valueOf(input.charAt(characterEnd)), (CharSequence)modifier.getCharacters())) {
                                initialConfidence = modifier.getConfidenceDelta() != 0.0 ? (initialConfidence += modifier.getConfidenceDelta()) : modifier.getConfidence();
                            }
                            if (modifier.getConfidenceCondition() == ConfidenceModifier.ConfidenceCondition.CHARACTER_SEQUENCE_SURROUNDING && characterStart > 0 && characterEnd < input.length() && StringUtils.equalsIgnoreCase((CharSequence)String.valueOf(input.charAt(characterStart - 1)), (CharSequence)modifier.getCharacters()) && StringUtils.equalsIgnoreCase((CharSequence)String.valueOf(input.charAt(characterEnd)), (CharSequence)modifier.getCharacters())) {
                                initialConfidence = modifier.getConfidenceDelta() != 0.0 ? (initialConfidence += modifier.getConfidenceDelta()) : modifier.getConfidence();
                            }
                            if (modifier.getConfidenceCondition() != ConfidenceModifier.ConfidenceCondition.CHARACTER_REGEX_SURROUNDING || characterStart <= 0 || characterEnd >= input.length() || !modifier.getMatchingPattern().matcher(input.substring(characterStart - 1, characterStart)).matches() || !modifier.getMatchingPattern().matcher(input.substring(characterEnd, characterEnd + 1)).matches()) continue;
                            if (modifier.getConfidenceDelta() != 0.0) {
                                initialConfidence += modifier.getConfidenceDelta();
                                continue;
                            }
                            initialConfidence = modifier.getConfidence();
                        }
                        if (initialConfidence < 0.0) {
                            initialConfidence = 0.0;
                        }
                        if (initialConfidence > 1.0) {
                            initialConfidence = 1.0;
                        }
                    }
                    String[] window = this.getWindow(input, characterStart, characterEnd);
                    Replacement replacement = this.getReplacement(policy, context, documentId, token, window, initialConfidence, this.classification, attributes, filterPattern);
                    Span span = Span.make(characterStart, characterEnd, this.getFilterType(), context, documentId, initialConfidence, token, replacement.getReplacement(), replacement.getSalt(), ignored, replacement.isApplied(), window, this.priority);
                    span.setPattern(filterPattern.getFormat());
                    span.setAlwaysValid(filterPattern.isAlwaysValid());
                    span.setClassification(filterPattern.getClassification());
                    spans.add(span);
                }
            }
        }
        return this.postFilter(spans);
    }

    @Override
    public int getOccurrences(Policy policy, String input, Map<String, String> attributes) throws Exception {
        return this.filter(policy, "none", "none", 0, input, attributes).getSpans().size();
    }

    public Map<Position, String> getNgramsUpToLength(String text, int length) {
        HashMap<Position, String> ngrams = new HashMap<Position, String>();
        for (int n = length; n > 0; --n) {
            ngrams.putAll(this.getNgramsOfLength(text, n));
        }
        return ngrams;
    }

    public Map<Position, String> getNgramsOfLength(String text, int length) {
        String delimiter = " ";
        HashMap<Position, String> ngramsWithIndexes = new HashMap<Position, String>();
        String[] words = text.split(" ");
        int lastLocation = 0;
        for (int i = 0; i <= words.length - length; ++i) {
            int newLocation;
            StringBuilder ngram = new StringBuilder();
            for (int j = 0; j < length; ++j) {
                ngram.append(words[i + j]);
                if (j >= length - 1) continue;
                ngram.append(" ");
            }
            lastLocation = newLocation = text.indexOf(ngram.toString(), lastLocation);
            Position position = new Position(newLocation, newLocation + ngram.toString().length());
            ngramsWithIndexes.put(position, ngram.toString());
        }
        return ngramsWithIndexes;
    }
}

