/*
 * Decompiled with CFR 0.152.
 */
package ai.philterd.phileas.model.filter.rules.dictionary;

import ai.philterd.phileas.model.enums.FilterType;
import ai.philterd.phileas.model.filter.FilterConfiguration;
import ai.philterd.phileas.model.filter.rules.dictionary.DictionaryFilter;
import ai.philterd.phileas.model.objects.FilterResult;
import ai.philterd.phileas.model.objects.Position;
import ai.philterd.phileas.model.objects.Replacement;
import ai.philterd.phileas.model.objects.Span;
import ai.philterd.phileas.model.policy.Policy;
import ai.philterd.phileas.model.utils.BloomFilter;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BloomFilterDictionaryFilter
extends DictionaryFilter {
    private static final Logger LOGGER = LogManager.getLogger(BloomFilterDictionaryFilter.class);
    private final BloomFilter<String> bloomFilter;
    private final Set<String> lowerCaseTerms = new HashSet<String>();
    private int maxNgramSize = 0;

    public BloomFilterDictionaryFilter(FilterType filterType, FilterConfiguration filterConfiguration, Set<String> terms, String classification) {
        super(filterType, filterConfiguration);
        this.bloomFilter = new BloomFilter(terms.size());
        this.classification = classification;
        for (String term : terms) {
            String[] split = term.split("\\s");
            if (split.length <= this.maxNgramSize) continue;
            this.maxNgramSize = split.length;
        }
        for (String term : terms) {
            this.lowerCaseTerms.add(term.toLowerCase());
            this.bloomFilter.put(term.toLowerCase());
        }
    }

    @Override
    public FilterResult filter(Policy policy, String context, String documentId, int piece, String text, Map<String, String> attributes) throws Exception {
        LinkedList<Span> spans = new LinkedList<Span>();
        Map<Position, String> ngrams = this.getNgramsUpToLength(text, this.maxNgramSize);
        for (Position position : ngrams.keySet()) {
            String ngram = ngrams.get(position);
            if (!this.bloomFilter.mightContain(ngram.toLowerCase()) || !this.lowerCaseTerms.contains(ngram.toLowerCase())) continue;
            boolean isIgnored = this.ignored.contains(ngram);
            int characterStart = position.getStart();
            int characterEnd = position.getEnd();
            double confidence = 1.0;
            String[] window = this.getWindow(text, characterStart, characterEnd);
            String originalToken = text.substring(characterStart, characterEnd);
            Replacement replacement = this.getReplacement(policy, context, documentId, originalToken, window, 1.0, this.classification, attributes, null);
            spans.add(Span.make(characterStart, characterEnd, this.getFilterType(), context, documentId, 1.0, originalToken, replacement.getReplacement(), replacement.getSalt(), isIgnored, replacement.isApplied(), window, this.priority));
        }
        return new FilterResult(context, documentId, spans);
    }
}

