/*
 * Decompiled with CFR 0.152.
 */
package ai.philterd.phileas.model.filter.rules.dictionary;

import ai.philterd.phileas.model.enums.FilterType;
import ai.philterd.phileas.model.enums.SensitivityLevel;
import ai.philterd.phileas.model.filter.FilterConfiguration;
import ai.philterd.phileas.model.filter.rules.dictionary.DictionaryFilter;
import ai.philterd.phileas.model.objects.FilterResult;
import ai.philterd.phileas.model.objects.Position;
import ai.philterd.phileas.model.objects.Replacement;
import ai.philterd.phileas.model.objects.Span;
import ai.philterd.phileas.model.policy.Policy;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.similarity.LevenshteinDistance;

public class FuzzyDictionaryFilter
extends DictionaryFilter
implements Serializable {
    private final SensitivityLevel sensitivityLevel;
    private final Map<String, Pattern> dictionary;
    private final int maxNgrams;
    private final boolean requireCapitalization;

    public FuzzyDictionaryFilter(FilterType filterType, FilterConfiguration filterConfiguration, SensitivityLevel sensitivityLevel, boolean requireCapitalization) throws IOException {
        super(filterType, filterConfiguration);
        this.sensitivityLevel = sensitivityLevel;
        this.dictionary = this.loadData(filterType);
        this.maxNgrams = this.getMaxNgrams();
        this.requireCapitalization = requireCapitalization;
    }

    public FuzzyDictionaryFilter(FilterType filterType, FilterConfiguration filterConfiguration, SensitivityLevel sensitivityLevel, Set<String> terms, boolean requireCapitalization) {
        super(filterType, filterConfiguration);
        this.sensitivityLevel = sensitivityLevel;
        this.dictionary = this.loadData(terms);
        this.maxNgrams = this.getMaxNgrams();
        this.requireCapitalization = requireCapitalization;
    }

    @Override
    public FilterResult filter(Policy policy, String context, String documentId, int piece, String input, Map<String, String> attributes) throws Exception {
        LinkedList<Span> spans = new LinkedList<Span>();
        if (policy.getIdentifiers().hasFilter(this.filterType)) {
            HashMap<Integer, Map<Position, String>> ngrams = new HashMap<Integer, Map<Position, String>>();
            ngrams.put(0, this.splitWithIndexes(input, " "));
            for (int x = 1; x < this.maxNgrams; ++x) {
                ngrams.put(x, this.getNgramsOfLength(input, x));
            }
            for (String entry : this.dictionary.keySet()) {
                Matcher matcher = this.dictionary.get(entry).matcher(input);
                if (matcher.find()) {
                    int startPosition = matcher.start();
                    spans.add(this.createSpan(input, startPosition, startPosition + entry.length(), 1.0, context, documentId, entry, policy, attributes));
                    continue;
                }
                if (this.sensitivityLevel == SensitivityLevel.OFF) continue;
                int spacesInEntry = StringUtils.countMatches((CharSequence)entry, (CharSequence)" ");
                for (Position position : ((Map)ngrams.get(spacesInEntry)).keySet()) {
                    String ngram = (String)((Map)ngrams.get(spacesInEntry)).get(position);
                    if (ngram.length() <= 2 || !this.requireCapitalization || !Character.isUpperCase(ngram.charAt(0))) continue;
                    int start = position.getStart();
                    int end = position.getEnd();
                    LevenshteinDistance levenshteinDistance = LevenshteinDistance.getDefaultInstance();
                    int distance = levenshteinDistance.apply((CharSequence)entry, (CharSequence)ngram);
                    if (this.sensitivityLevel == SensitivityLevel.HIGH && distance < 1) {
                        spans.add(this.createSpan(input, start, end, 0.9, context, documentId, entry, policy, attributes));
                        continue;
                    }
                    if (this.sensitivityLevel == SensitivityLevel.MEDIUM && distance <= 2) {
                        spans.add(this.createSpan(input, start, end, 0.7, context, documentId, entry, policy, attributes));
                        continue;
                    }
                    if (this.sensitivityLevel != SensitivityLevel.LOW || distance >= 3) continue;
                    spans.add(this.createSpan(input, start, end, 0.5, context, documentId, entry, policy, attributes));
                }
            }
        }
        return new FilterResult(context, documentId, spans);
    }

    private Span createSpan(String text, int characterStart, int characterEnd, double confidence, String context, String documentId, String token, Policy policy, Map<String, String> attributes) throws Exception {
        boolean ignored = this.isIgnored(text);
        String[] window = this.getWindow(text, characterStart, characterEnd);
        Replacement replacement = this.getReplacement(policy, context, documentId, token, window, confidence, this.classification, attributes, null);
        return Span.make(characterStart, characterEnd, this.getFilterType(), context, documentId, confidence, token, replacement.getReplacement(), replacement.getSalt(), ignored, replacement.isApplied(), window, this.priority);
    }

    private int getMaxNgrams() {
        int maxNgrams = 0;
        for (String key : this.dictionary.keySet()) {
            int n = key.split(" ").length;
            if (n > maxNgrams) {
                maxNgrams = n;
            }
            if (n < 20) continue;
            break;
        }
        return maxNgrams;
    }

    private Map<String, Pattern> loadData(Set<String> terms) {
        HashMap<String, Pattern> dictionary = new HashMap<String, Pattern>();
        for (String term : terms) {
            Pattern pattern = Pattern.compile("\\b" + term + "\\b", 2);
            dictionary.put(term, pattern);
        }
        return dictionary;
    }

    private Map<String, Pattern> loadData(FilterType filterType) throws IOException {
        String fileName;
        HashMap<String, Pattern> dictionary = new HashMap<String, Pattern>();
        if (filterType == FilterType.LOCATION_CITY) {
            fileName = "cities";
        } else if (filterType == FilterType.LOCATION_COUNTY) {
            fileName = "counties";
        } else if (filterType == FilterType.LOCATION_STATE) {
            fileName = "states";
        } else if (filterType == FilterType.HOSPITAL) {
            fileName = "hospitals";
        } else if (filterType == FilterType.HOSPITAL_ABBREVIATION) {
            fileName = "hospital-abbreviations";
        } else if (filterType == FilterType.FIRST_NAME) {
            fileName = "names";
        } else if (filterType == FilterType.SURNAME) {
            fileName = "surnames";
        } else {
            throw new IllegalArgumentException("Invalid filter type.");
        }
        try (InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream(fileName);
             BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));){
            String line;
            while ((line = reader.readLine()) != null) {
                Pattern pattern = Pattern.compile("\\b" + line + "\\b", 2);
                dictionary.put(line, pattern);
            }
        }
        return dictionary;
    }
}

