/*
 * Decompiled with CFR 0.152.
 */
package ai.philterd.phileas.model.metadata.zipcode;

import ai.philterd.phileas.model.metadata.MetadataService;
import ai.philterd.phileas.model.metadata.zipcode.ZipCodeMetadataRequest;
import ai.philterd.phileas.model.metadata.zipcode.ZipCodeMetadataResponse;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;

public class ZipCodeMetadataService
implements MetadataService<ZipCodeMetadataRequest, ZipCodeMetadataResponse> {
    private final HashMap<String, Integer> zipCodesFromCensus = this.loadZipCodesFromCensus();
    private final String zipCodeCensusFileName = "zip-code-population.csv";

    @Override
    public ZipCodeMetadataResponse getMetadata(ZipCodeMetadataRequest request) {
        int population = this.zipCodesFromCensus.getOrDefault(request.getZipCode(), -1);
        if (population == -1) {
            return new ZipCodeMetadataResponse(-1, false);
        }
        return new ZipCodeMetadataResponse(population);
    }

    private HashMap<String, Integer> loadZipCodesFromCensus() throws IOException {
        HashMap<String, Integer> zipcodes = new HashMap<String, Integer>();
        try (InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream("zip-code-population.csv");
             InputStreamReader inputStreamReader = new InputStreamReader(inputStream);){
            String line;
            BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
            while ((line = bufferedReader.readLine()) != null) {
                if (line.startsWith("#")) continue;
                String[] zipCodePopulation = line.split(",");
                String zipCode = zipCodePopulation[0];
                int population = Integer.parseInt(zipCodePopulation[1]);
                zipcodes.put(zipCode, population);
            }
        }
        return zipcodes;
    }
}

