/*
 * Decompiled with CFR 0.152.
 */
package ai.philterd.phileas.model.objects;

import ai.philterd.phileas.model.objects.ConfidenceModifier;
import java.util.List;
import java.util.regex.Pattern;

public class FilterPattern {
    private final Pattern pattern;
    private final String format;
    private final double initialConfidence;
    private final String classification;
    private final boolean alwaysValid;
    private final int groupNumber;
    private final List<ConfidenceModifier> confidenceModifiers;

    private FilterPattern(Pattern pattern, double initialConfidence, String format, String classification, boolean alwaysValid, int groupNumber, List<ConfidenceModifier> confidenceModifiers) {
        this.pattern = pattern;
        this.initialConfidence = initialConfidence;
        this.format = format;
        this.classification = classification;
        this.alwaysValid = alwaysValid;
        this.groupNumber = groupNumber;
        this.confidenceModifiers = confidenceModifiers;
    }

    public boolean isAlwaysValid() {
        return this.alwaysValid;
    }

    public Pattern getPattern() {
        return this.pattern;
    }

    public String getFormat() {
        return this.format;
    }

    public double getInitialConfidence() {
        return this.initialConfidence;
    }

    public String getClassification() {
        return this.classification;
    }

    public int getGroupNumber() {
        return this.groupNumber;
    }

    public List<ConfidenceModifier> getConfidenceModifiers() {
        return this.confidenceModifiers;
    }

    public static class FilterPatternBuilder {
        private final Pattern pattern;
        private final double initialConfidence;
        private String format;
        private String classification;
        private boolean alwaysValid = false;
        private int groupNumber = 0;
        private List<ConfidenceModifier> confidenceModifiers;

        public FilterPatternBuilder(Pattern pattern, double initialConfidence) {
            this.pattern = pattern;
            this.initialConfidence = initialConfidence;
        }

        public FilterPatternBuilder(Pattern pattern, double initialConfidence, List<ConfidenceModifier> confidenceModifiers) {
            this.pattern = pattern;
            this.initialConfidence = initialConfidence;
            this.confidenceModifiers = confidenceModifiers;
        }

        public FilterPatternBuilder withConfidenceModifiers(List<ConfidenceModifier> confidenceModifiers) {
            this.confidenceModifiers = confidenceModifiers;
            return this;
        }

        public FilterPatternBuilder withFormat(String format) {
            this.format = format;
            return this;
        }

        public FilterPatternBuilder withClassification(String classification) {
            this.classification = classification;
            return this;
        }

        public FilterPatternBuilder withAlwaysValid(boolean alwaysValid) {
            this.alwaysValid = alwaysValid;
            return this;
        }

        public FilterPatternBuilder withGroupNumber(int groupNumber) {
            this.groupNumber = groupNumber;
            return this;
        }

        public FilterPattern build() {
            return new FilterPattern(this.pattern, this.initialConfidence, this.format, this.classification, this.alwaysValid, this.groupNumber, this.confidenceModifiers);
        }
    }
}

