/*
 * Decompiled with CFR 0.152.
 */
package ai.philterd.phileas.model.objects;

import ai.philterd.phileas.model.enums.FilterType;
import ai.philterd.phileas.model.formats.lapps.Annotation;
import ai.philterd.phileas.model.formats.lapps.Lapps;
import ai.philterd.phileas.model.formats.lapps.View;
import com.google.gson.Gson;
import com.google.gson.annotations.Expose;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang3.Range;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class Span {
    private static final Logger LOGGER = LogManager.getLogger(Span.class);
    @Expose
    private int characterStart;
    @Expose
    private int characterEnd;
    @Expose
    private FilterType filterType;
    @Expose
    private String context;
    @Expose
    private String documentId;
    @Expose
    private String classification;
    @Expose
    private double confidence;
    @Expose
    private String text;
    @Expose
    private String replacement;
    @Expose
    private String salt;
    @Expose
    private boolean ignored;
    @Expose
    private boolean applied;
    @Expose
    private int priority;
    private transient Range<Integer> range;
    private transient String pattern;
    private transient String[] window;
    private transient boolean alwaysValid = false;

    public Span() {
    }

    private Span(int characterStart, int characterEnd, FilterType filterType, String context, String documentId, double confidence, String text, String replacement, String salt, boolean ignored, boolean applied, String[] window, int priority) {
        this.characterStart = characterStart;
        this.characterEnd = characterEnd;
        this.filterType = filterType;
        this.context = context;
        this.documentId = documentId;
        this.confidence = confidence;
        this.text = text;
        this.replacement = replacement;
        this.salt = salt;
        this.ignored = ignored;
        this.applied = applied;
        this.window = window;
        this.priority = priority;
    }

    public static Span make(int characterStart, int characterEnd, FilterType filterType, String context, String documentId, double confidence, String text, String replacement, String salt, boolean ignored, boolean applied, String[] window, int priority) {
        Span span = new Span(characterStart, characterEnd, filterType, context, documentId, confidence, text, replacement, salt, ignored, applied, window, priority);
        span.range = Range.of((Comparable)Integer.valueOf(characterStart), (Comparable)Integer.valueOf(characterEnd));
        return span;
    }

    public Span copy() {
        Span clone = Span.make(this.characterStart, this.characterEnd, this.filterType, this.context, this.documentId, this.confidence, this.text, this.replacement, this.salt, this.ignored, this.applied, this.window, this.priority);
        clone.range = this.range;
        return clone;
    }

    public static List<Span> shiftSpans(int shift, Span ignoreSpan, List<Span> spans) {
        LinkedList<Span> shiftedSpans = new LinkedList<Span>();
        for (Span span : spans) {
            if (span == ignoreSpan) continue;
            int start = span.getCharacterStart() + shift;
            int end = span.getCharacterEnd() + shift;
            shiftedSpans.add(Span.make(start, end, span.filterType, span.context, span.documentId, span.confidence, span.text, span.replacement, span.salt, span.ignored, span.applied, span.window, span.priority));
        }
        return shiftedSpans;
    }

    public static List<Span> shiftSpans(int shift, List<Span> spans) {
        LinkedList<Span> shiftedSpans = new LinkedList<Span>();
        for (Span span : spans) {
            int start = span.getCharacterStart() + shift;
            int end = span.getCharacterEnd() + shift;
            shiftedSpans.add(Span.make(start, end, span.filterType, span.context, span.documentId, span.confidence, span.text, span.replacement, span.salt, span.ignored, span.applied, span.window, span.priority));
        }
        return shiftedSpans;
    }

    public static Span doesIndexStartSpan(int index, List<Span> spans) {
        for (Span span : spans) {
            if (index != span.getCharacterStart()) continue;
            return span;
        }
        return null;
    }

    public static boolean doesSpanExist(int startIndex, int endIndex, List<Span> spans) {
        for (Span span : spans) {
            if (startIndex != span.getCharacterStart() || endIndex != span.getCharacterEnd()) continue;
            return true;
        }
        return false;
    }

    public String getText(String text) {
        return text.substring(this.characterStart, this.characterEnd);
    }

    public static List<Span> getIdenticalSpans(Span span, List<Span> spans) {
        LinkedHashSet<Span> identicalSpans = new LinkedHashSet<Span>();
        for (Span span1 : spans) {
            if (span1.getCharacterStart() != span.getCharacterStart() || span1.getCharacterEnd() != span.getCharacterEnd() || span1.getFilterType() == span.getFilterType() || span1.getConfidence() != span.getConfidence() || span1.equals(span)) continue;
            identicalSpans.add(span1);
        }
        return new LinkedList<Span>(identicalSpans);
    }

    public static boolean areSpansAdjacent(Span span1, Span span2, String text) {
        if (span1.getCharacterStart() > span2.getCharacterStart()) {
            return false;
        }
        if (span1.getCharacterEnd() == span1.getCharacterStart() + 1) {
            return true;
        }
        String separators = text.substring(span1.getCharacterEnd(), span2.getCharacterStart() - 1);
        return StringUtils.isWhitespace((CharSequence)separators) || StringUtils.equals((CharSequence)",", (CharSequence)separators.trim());
    }

    public static List<Span> fromLappsJson(String lappsJson) {
        LinkedList<Span> spans = new LinkedList<Span>();
        Gson gson = new Gson();
        Lapps lapps = (Lapps)gson.fromJson(lappsJson, Lapps.class);
        for (View view : lapps.getViews()) {
            for (Annotation annotation : view.getAnnotations()) {
                if (!StringUtils.equalsIgnoreCase((CharSequence)"http://vocab.lappsgrid.org/NamedEntity", (CharSequence)annotation.getType()) || annotation.getFeatures() == null) continue;
                Span span = new Span();
                span.setCharacterStart(annotation.getStart());
                span.setCharacterEnd(annotation.getEnd());
                span.setText(lapps.getText().getValue().substring(annotation.getStart(), annotation.getEnd()));
                if (StringUtils.equalsIgnoreCase((CharSequence)"PER", (CharSequence)annotation.getFeatures().getCategory())) {
                    span.setFilterType(FilterType.PERSON);
                    span.setClassification("PER");
                } else {
                    span.setFilterType(FilterType.valueOf(annotation.getFeatures().getCategory()));
                }
                spans.add(span);
            }
        }
        return spans;
    }

    public static List<Span> dropOverlappingSpans(List<Span> spans) {
        List<Span> nonOverlappingSpans = new LinkedList<Span>();
        spans.sort((s1, s2) -> s1.length());
        Collections.reverse(spans);
        for (Span span : spans) {
            boolean overlapping = false;
            for (Span span2 : spans) {
                if (span.equals(span2) || !span.range.isOverlappedBy(span2.range)) continue;
                int spanLength = span.getCharacterEnd() - span.getCharacterStart();
                int span2Length = span2.getCharacterEnd() - span2.getCharacterStart();
                if (span2Length > spanLength) {
                    overlapping = true;
                    nonOverlappingSpans.add(span2);
                    continue;
                }
                if (span2Length == spanLength && span2.confidence > span.confidence) {
                    overlapping = true;
                    continue;
                }
                if (span2Length != spanLength || span2.confidence != span.confidence || span2.getPriority() <= span.getPriority()) continue;
                overlapping = true;
                nonOverlappingSpans.add(span2);
            }
            if (overlapping) continue;
            nonOverlappingSpans.add(span);
        }
        HashSet seen = new HashSet();
        nonOverlappingSpans.removeIf(e -> !seen.add(e.getCharacterStart()));
        int removed = spans.size() - nonOverlappingSpans.size();
        if (removed > 0) {
            nonOverlappingSpans = Span.dropOverlappingSpans(nonOverlappingSpans);
        }
        return nonOverlappingSpans;
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).append(this.characterStart).append(this.characterEnd).append((Object)this.filterType).append(this.confidence).append((Object)this.context).append((Object)this.documentId).append((Object)this.text).append((Object)this.replacement).append((Object)this.salt).append(this.ignored).append(this.applied).append((Object)this.classification).append(this.priority).toHashCode();
    }

    public boolean equals(Object o) {
        return EqualsBuilder.reflectionEquals((Object)this, (Object)o, (String[])new String[0]);
    }

    public String toString() {
        return "characterStart: " + this.characterStart + ";  characterEnd: " + this.characterEnd + ";  filterType: " + this.filterType.getType() + ";  context: " + this.context + ";  documentId: " + this.documentId + ";  confidence: " + this.confidence + ";  text: " + this.text + ";  replacement: " + this.replacement + ";  salt: " + this.salt + ";  ignored: " + this.ignored + ";  applied: " + this.applied + ";  classification: " + this.classification + ";  priority: " + this.priority + "; ";
    }

    public int length() {
        return this.characterEnd - this.characterStart;
    }

    public int getCharacterStart() {
        return this.characterStart;
    }

    public void setCharacterStart(int characterStart) {
        this.characterStart = characterStart;
    }

    public int getCharacterEnd() {
        return this.characterEnd;
    }

    public void setCharacterEnd(int characterEnd) {
        this.characterEnd = characterEnd;
    }

    public FilterType getFilterType() {
        return this.filterType;
    }

    public void setFilterType(FilterType filterType) {
        this.filterType = filterType;
    }

    public String getContext() {
        return this.context;
    }

    public void setContext(String context) {
        this.context = context;
    }

    public String getDocumentId() {
        return this.documentId;
    }

    public void setDocumentId(String documentId) {
        this.documentId = documentId;
    }

    public double getConfidence() {
        return this.confidence;
    }

    public void setConfidence(double confidence) {
        this.confidence = confidence;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public String getReplacement() {
        return this.replacement;
    }

    public void setReplacement(String replacement) {
        this.replacement = replacement;
    }

    public boolean isIgnored() {
        return this.ignored;
    }

    public void setIgnored(boolean ignored) {
        this.ignored = ignored;
    }

    public boolean isApplied() {
        return this.applied;
    }

    public void setApplied(boolean applied) {
        this.applied = applied;
    }

    public String getPattern() {
        return this.pattern;
    }

    public void setPattern(String pattern) {
        this.pattern = pattern;
    }

    public String[] getWindow() {
        return this.window;
    }

    public void setWindow(String[] window) {
        this.window = window;
    }

    public String getClassification() {
        return this.classification;
    }

    public void setClassification(String classification) {
        this.classification = classification;
    }

    public String getSalt() {
        return this.salt;
    }

    public void setSalt(String salt) {
        this.salt = salt;
    }

    public boolean isAlwaysValid() {
        return this.alwaysValid;
    }

    public void setAlwaysValid(boolean alwaysValid) {
        this.alwaysValid = alwaysValid;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    public int getPriority() {
        return this.priority;
    }
}

