/*
 * Decompiled with CFR 0.152.
 */
package ai.philterd.phileas.model.policy.filters.strategies;

import ai.philterd.phileas.model.conditions.ParsedCondition;
import ai.philterd.phileas.model.enums.FilterType;
import ai.philterd.phileas.model.objects.FilterPattern;
import ai.philterd.phileas.model.objects.Replacement;
import ai.philterd.phileas.model.policy.Crypto;
import ai.philterd.phileas.model.policy.FPE;
import ai.philterd.phileas.model.policy.Policy;
import ai.philterd.phileas.model.services.AnonymizationService;
import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import java.io.IOException;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;

public abstract class AbstractFilterStrategy {
    public static final String DEFAULT_REDACTION = "{{{REDACTED-%t}}}";
    public static final String REDACT = "REDACT";
    public static final String RANDOM_REPLACE = "RANDOM_REPLACE";
    public static final String STATIC_REPLACE = "STATIC_REPLACE";
    public static final String CRYPTO_REPLACE = "CRYPTO_REPLACE";
    public static final String FPE_ENCRYPT_REPLACE = "FPE_ENCRYPT_REPLACE";
    public static final String HASH_SHA256_REPLACE = "HASH_SHA256_REPLACE";
    public static final String LAST_4 = "LAST_4";
    public static final String MASK = "MASK";
    public static final String SAME = "SAME";
    public static final String TRUNCATE = "TRUNCATE";
    public static final String LEADING = "LEADING";
    public static final String TRAILING = "TRAILING";
    public static final String ABBREVIATE = "ABBREVIATE";
    public static final String TRUNCATE_TO_YEAR = "TRUNCATE_TO_YEAR";
    public static final String SHIFT = "SHIFT";
    public static final String RELATIVE = "RELATIVE";
    public static final String REPLACEMENT_SCOPE_DOCUMENT = "DOCUMENT";
    public static final String REPLACEMENT_SCOPE_CONTEXT = "CONTEXT";
    public static final String TOKEN = "token";
    public static final String CONTEXT = "context";
    public static final String TYPE = "type";
    public static final String CONFIDENCE = "confidence";
    public static final String SENTIMENT = "sentiment";
    public static final String CLASSIFICATION = "classification";
    public static final String BIRTHDATE = "birthdate";
    public static final String DEATHDATE = "deathdate";
    public static final String BIRTHDATE_OR_DEATHDATE = "birthdate or deathdate";
    public static final String STARTSWITH = "startswith";
    public static final String EQUALS = "==";
    public static final String NOT_EQUALS = "!=";
    public static final String GREATER_THAN = ">";
    public static final String LESS_THAN = "<";
    public static final String GREATER_THAN_EQUALS = ">=";
    public static final String LESS_THAN_EQUALS = "<=";
    public static final String IS = "is";
    public static final String IS_NOT = "is not";
    @SerializedName(value="id")
    @Expose
    protected String id = UUID.randomUUID().toString();
    @SerializedName(value="strategy")
    @Expose
    protected String strategy = "REDACT";
    @SerializedName(value="redactionFormat")
    @Expose
    protected String redactionFormat = "{{{REDACTED-%t}}}";
    @SerializedName(value="replacementScope")
    @Expose
    protected String replacementScope = "DOCUMENT";
    @SerializedName(value="staticReplacement")
    @Expose
    protected String staticReplacement = "";
    @SerializedName(value="maskCharacter")
    @Expose
    protected String maskCharacter = "*";
    @SerializedName(value="maskLength")
    @Expose
    protected String maskLength = "SAME";
    @SerializedName(value="truncateDigits")
    @Expose
    @Deprecated
    protected Integer truncateDigits;
    @SerializedName(value="truncateLeaveCharacters")
    @Expose
    protected Integer truncateLeaveCharacters;
    @SerializedName(value="truncateCharacter")
    @Expose
    protected String truncateCharacter = "*";
    @SerializedName(value="truncateDirection")
    @Expose
    protected String truncateDirection = "LEADING";
    @SerializedName(value="condition")
    @Expose
    protected String condition = "";
    @SerializedName(value="alert")
    @Expose
    protected boolean alert = false;
    @SerializedName(value="salt")
    @Expose
    protected boolean salt;

    public abstract Replacement getReplacement(String var1, String var2, String var3, String var4, String[] var5, Crypto var6, FPE var7, AnonymizationService var8, FilterPattern var9) throws Exception;

    public abstract boolean evaluateCondition(Policy var1, String var2, String var3, String var4, String[] var5, String var6, double var7, Map<String, String> var9);

    public abstract FilterType getFilterType();

    protected String getRedactedToken(String token, String label, FilterType filterType) {
        String replacement = AbstractFilterStrategy.getValueOrDefault(this.redactionFormat, DEFAULT_REDACTION).replaceAll("%t", filterType.getType());
        if (StringUtils.isNotEmpty((CharSequence)label)) {
            replacement = replacement.replaceAll("%l", label);
        }
        replacement = replacement.replaceAll("%v", token);
        return replacement;
    }

    protected boolean evaluateTokenCondition(ParsedCondition parsedCondition, String token, String[] window) {
        boolean conditionSatisfied = false;
        String value = parsedCondition.getValue().replace("\"", "");
        switch (parsedCondition.getOperator().toLowerCase()) {
            case "startswith": {
                conditionSatisfied = token.startsWith(value);
                break;
            }
            case "==": {
                conditionSatisfied = token.equalsIgnoreCase(value);
                break;
            }
            case "is": {
                if (value.equalsIgnoreCase(BIRTHDATE)) {
                    conditionSatisfied = this.isBirthdate(window);
                    break;
                }
                if (value.equalsIgnoreCase(DEATHDATE)) {
                    conditionSatisfied = this.isDeathdate(window);
                    break;
                }
                if (!value.equalsIgnoreCase(BIRTHDATE_OR_DEATHDATE)) break;
                conditionSatisfied = this.isBirthdate(window) || this.isDeathdate(window);
                break;
            }
            case "is not": {
                if (value.equalsIgnoreCase(BIRTHDATE)) {
                    conditionSatisfied = !this.isBirthdate(window);
                    break;
                }
                if (value.equalsIgnoreCase(DEATHDATE)) {
                    conditionSatisfied = !this.isDeathdate(window);
                    break;
                }
                if (!value.equalsIgnoreCase(BIRTHDATE_OR_DEATHDATE)) break;
                conditionSatisfied = !this.isBirthdate(window) && !this.isDeathdate(window);
            }
        }
        return conditionSatisfied;
    }

    protected boolean isBirthdate(String[] window) {
        String joinedWindow = StringUtils.join((Object[])window, (String)" ").replaceAll("[^a-zA-Z ]", "").toLowerCase();
        return joinedWindow.contains("dob") || joinedWindow.contains("birthday") || joinedWindow.contains("birth day") || joinedWindow.contains(BIRTHDATE) || joinedWindow.contains("date of birth") || joinedWindow.contains("birth") || joinedWindow.contains("born") || joinedWindow.contains("born on");
    }

    protected boolean isDeathdate(String[] window) {
        String joinedWindow = StringUtils.join((Object[])window, (String)" ").replaceAll("[^a-zA-Z ]", "").toLowerCase();
        return joinedWindow.contains(DEATHDATE) || joinedWindow.contains("death date") || joinedWindow.contains("death anniversary") || joinedWindow.contains("passed away") || joinedWindow.contains("died on") || joinedWindow.contains("died") || joinedWindow.contains("death");
    }

    protected static <T> T getValueOrDefault(T value, T defaultValue) {
        return value == null ? defaultValue : value;
    }

    protected String getAnonymizedToken(String context, String token, AnonymizationService anonymizationService) throws IOException {
        String replacement = null;
        if (anonymizationService.getCacheService().containsAnonymizedToken(context, token)) {
            replacement = anonymizationService.getCacheService().getAnonymizedToken(context, token);
        } else if (anonymizationService.getCacheService().containsAnonymizedTokenValue(context, token)) {
            replacement = null;
        } else {
            replacement = anonymizationService.anonymize(token);
            anonymizationService.getCacheService().putAnonymizedToken(context, token, replacement);
        }
        return replacement;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getStrategy() {
        return this.strategy;
    }

    public void setStrategy(String strategy) {
        this.strategy = strategy;
    }

    public String getRedactionFormat() {
        return this.redactionFormat;
    }

    public void setRedactionFormat(String redactionFormat) {
        this.redactionFormat = redactionFormat;
    }

    public String getReplacementScope() {
        return this.replacementScope;
    }

    public void setReplacementScope(String replacementScope) {
        this.replacementScope = replacementScope;
    }

    public String getStaticReplacement() {
        return this.staticReplacement;
    }

    public void setStaticReplacement(String staticReplacement) {
        this.staticReplacement = staticReplacement;
    }

    public void setMaskCharacter(String maskCharacter) {
        this.maskCharacter = maskCharacter;
    }

    public String getMaskCharacter() {
        return this.maskCharacter;
    }

    public void setMaskLength(String maskLength) {
        this.maskLength = maskLength;
    }

    public String getMaskLength() {
        return this.maskLength;
    }

    @Deprecated
    public void setTruncateDigits(Integer truncateDigits) {
        this.setTruncateLeaveCharacters(truncateDigits);
    }

    public void setTruncateLeaveCharacters(Integer truncateLeaveCharacters) {
        if (truncateLeaveCharacters < 1) {
            throw new IllegalArgumentException("Truncate leave characters must be greater than or equal to 1");
        }
        this.truncateLeaveCharacters = truncateLeaveCharacters;
    }

    public Integer getTruncateLeaveCharacters() {
        return this.truncateLeaveCharacters;
    }

    public String getTruncateCharacter() {
        return this.truncateCharacter;
    }

    public void setTruncateCharacter(String truncateCharacter) {
        this.truncateCharacter = truncateCharacter;
    }

    public String getTruncateDirection() {
        return this.truncateDirection;
    }

    public void setTruncateDirection(String truncateDirection) {
        this.truncateDirection = truncateDirection;
    }

    public void setConditions(String condition) {
        this.condition = condition;
    }

    public String getCondition() {
        return this.condition;
    }

    public boolean isAlert() {
        return this.alert;
    }

    public void setAlert(boolean alert) {
        this.alert = alert;
    }

    public boolean isSalt() {
        return this.salt;
    }

    public void setSalt(boolean salt) {
        this.salt = salt;
    }
}

