/*
 * Decompiled with CFR 0.152.
 */
package ai.philterd.phileas.model.policy.filters.strategies;

import ai.philterd.phileas.model.enums.FilterType;
import ai.philterd.phileas.model.objects.FilterPattern;
import ai.philterd.phileas.model.objects.Replacement;
import ai.philterd.phileas.model.policy.Crypto;
import ai.philterd.phileas.model.policy.FPE;
import ai.philterd.phileas.model.policy.filters.strategies.AbstractFilterStrategy;
import ai.philterd.phileas.model.services.AnonymizationService;
import ai.philterd.phileas.model.utils.Encryption;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.StringUtils;

public abstract class StandardFilterStrategy
extends AbstractFilterStrategy {
    public Replacement getStandardReplacement(String label, String context, String documentId, String token, String[] window, Crypto crypto, FPE fpe, AnonymizationService anonymizationService, FilterPattern filterPattern, FilterType filterType) throws Exception {
        Object replacement;
        String salt = "";
        if (StringUtils.equalsIgnoreCase((CharSequence)this.strategy, (CharSequence)"REDACT")) {
            replacement = this.getRedactedToken(token, label, filterType);
        } else if (StringUtils.equalsIgnoreCase((CharSequence)this.strategy, (CharSequence)"MASK")) {
            int characters = token.length();
            if (this.maskLength != null && !this.maskLength.equals("null") && !StringUtils.equalsIgnoreCase((CharSequence)this.maskLength, (CharSequence)"SAME")) {
                characters = Integer.parseInt(this.maskLength);
            }
            if (characters < 1) {
                characters = 5;
            }
            replacement = this.maskCharacter.repeat(characters);
        } else if (StringUtils.equalsIgnoreCase((CharSequence)this.strategy, (CharSequence)"TRUNCATE")) {
            int leaveCharacters = StandardFilterStrategy.getValueOrDefault(StandardFilterStrategy.getValueOrDefault(this.truncateLeaveCharacters, this.truncateDigits), 4);
            if (leaveCharacters < 1) {
                leaveCharacters = 1;
            }
            replacement = StringUtils.equalsIgnoreCase((CharSequence)this.truncateDirection, (CharSequence)"LEADING") ? token.substring(0, leaveCharacters) + StringUtils.repeat((String)this.truncateCharacter, (int)(token.length() - leaveCharacters)) : StringUtils.repeat((String)this.truncateCharacter, (int)(token.length() - leaveCharacters)) + token.substring(token.length() - leaveCharacters);
        } else if (StringUtils.equalsIgnoreCase((CharSequence)this.strategy, (CharSequence)"RANDOM_REPLACE")) {
            String scope = "DOCUMENT";
            if (StringUtils.equalsIgnoreCase((CharSequence)this.replacementScope, (CharSequence)"CONTEXT")) {
                scope = "CONTEXT";
            }
            replacement = this.getAnonymizedToken(scope, token, anonymizationService);
        } else if (StringUtils.equalsIgnoreCase((CharSequence)this.strategy, (CharSequence)"STATIC_REPLACE")) {
            replacement = this.staticReplacement;
        } else if (StringUtils.equalsIgnoreCase((CharSequence)this.strategy, (CharSequence)"CRYPTO_REPLACE")) {
            replacement = "{{" + Encryption.encrypt(token, crypto) + "}}";
        } else if (StringUtils.equalsIgnoreCase((CharSequence)this.strategy, (CharSequence)"FPE_ENCRYPT_REPLACE")) {
            replacement = Encryption.formatPreservingEncrypt(fpe, token);
        } else if (StringUtils.equalsIgnoreCase((CharSequence)this.strategy, (CharSequence)"LAST_4")) {
            replacement = token.substring(token.length() - 4);
        } else if (StringUtils.equalsIgnoreCase((CharSequence)this.strategy, (CharSequence)"HASH_SHA256_REPLACE")) {
            if (this.isSalt()) {
                salt = RandomStringUtils.randomAlphanumeric((int)16);
            }
            replacement = DigestUtils.sha256Hex((String)(token + salt));
        } else {
            replacement = this.getRedactedToken(token, label, filterType);
        }
        return new Replacement((String)replacement, salt);
    }
}

