/*
 * Decompiled with CFR 0.152.
 */
package ai.philterd.phileas.model.policy.filters.strategies.ai;

import ai.philterd.phileas.model.conditions.ParsedCondition;
import ai.philterd.phileas.model.conditions.ParserListener;
import ai.philterd.phileas.model.enums.FilterType;
import ai.philterd.phileas.model.objects.FilterPattern;
import ai.philterd.phileas.model.objects.Replacement;
import ai.philterd.phileas.model.policy.Crypto;
import ai.philterd.phileas.model.policy.FPE;
import ai.philterd.phileas.model.policy.Policy;
import ai.philterd.phileas.model.policy.filters.strategies.AbstractFilterStrategy;
import ai.philterd.phileas.model.services.AnonymizationService;
import ai.philterd.phileas.model.utils.Encryption;
import java.util.List;
import java.util.Map;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.WordUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PhEyeFilterStrategy
extends AbstractFilterStrategy {
    private static final Logger LOGGER = LogManager.getLogger(PhEyeFilterStrategy.class);
    private static final FilterType filterType = FilterType.PERSON;

    @Override
    public FilterType getFilterType() {
        return filterType;
    }

    @Override
    public boolean evaluateCondition(Policy policy, String context, String documentId, String token, String[] window, String condition, double confidence, Map<String, String> attributes) {
        List<ParsedCondition> parsedConditions = ParserListener.getTerminals(condition);
        boolean conditionsSatisfied = false;
        for (ParsedCondition parsedCondition : parsedConditions) {
            if (StringUtils.equalsIgnoreCase((CharSequence)"token", (CharSequence)parsedCondition.getField())) {
                conditionsSatisfied = this.evaluateTokenCondition(parsedCondition, token, window);
            } else {
                if (StringUtils.equalsIgnoreCase((CharSequence)"classification", (CharSequence)parsedCondition.getField()) || StringUtils.equalsIgnoreCase((CharSequence)"type", (CharSequence)parsedCondition.getField())) {
                    String entityType = attributes.getOrDefault("classification", "");
                    if (parsedCondition.getOperator().equalsIgnoreCase("==")) {
                        conditionsSatisfied = StringUtils.equalsIgnoreCase((CharSequence)entityType, (CharSequence)parsedCondition.getValue());
                        break;
                    }
                    if (parsedCondition.getOperator().equalsIgnoreCase("!=")) {
                        conditionsSatisfied = !StringUtils.equalsIgnoreCase((CharSequence)entityType, (CharSequence)parsedCondition.getValue());
                        break;
                    }
                    LOGGER.warn("Invalid comparator on NER filter strategy condition: {}", (Object)condition);
                    break;
                }
                if (StringUtils.equalsIgnoreCase((CharSequence)"confidence", (CharSequence)parsedCondition.getField())) {
                    double threshold = Double.parseDouble(parsedCondition.getValue());
                    conditionsSatisfied = switch (parsedCondition.getOperator()) {
                        case ">" -> {
                            if (confidence > threshold) {
                                yield true;
                            }
                            yield false;
                        }
                        case "<" -> {
                            if (confidence < threshold) {
                                yield true;
                            }
                            yield false;
                        }
                        case ">=" -> {
                            if (confidence >= threshold) {
                                yield true;
                            }
                            yield false;
                        }
                        case "<=" -> {
                            if (confidence <= threshold) {
                                yield true;
                            }
                            yield false;
                        }
                        case "==" -> {
                            if (confidence == threshold) {
                                yield true;
                            }
                            yield false;
                        }
                        case "!=" -> {
                            if (confidence != threshold) {
                                yield true;
                            }
                            yield false;
                        }
                        default -> conditionsSatisfied;
                    };
                } else if (StringUtils.equalsIgnoreCase((CharSequence)"context", (CharSequence)parsedCondition.getField())) {
                    String conditionContext = parsedCondition.getValue();
                    conditionsSatisfied = switch (parsedCondition.getOperator()) {
                        case "==" -> StringUtils.equalsIgnoreCase((CharSequence)("\"" + context + "\""), (CharSequence)conditionContext);
                        case "!=" -> {
                            if (!StringUtils.equalsIgnoreCase((CharSequence)("\"" + context + "\""), (CharSequence)conditionContext)) {
                                yield true;
                            }
                            yield false;
                        }
                        default -> conditionsSatisfied;
                    };
                } else if (StringUtils.equalsIgnoreCase((CharSequence)"sentiment", (CharSequence)parsedCondition.getField())) {
                    if (attributes.containsKey("sentiment")) {
                        int documentSentiment = Integer.parseInt(attributes.get("sentiment"));
                        int sentimentCondition = Integer.parseInt(parsedCondition.getValue());
                        conditionsSatisfied = switch (parsedCondition.getOperator()) {
                            case ">" -> {
                                if (documentSentiment > sentimentCondition) {
                                    yield true;
                                }
                                yield false;
                            }
                            case "<" -> {
                                if (documentSentiment < sentimentCondition) {
                                    yield true;
                                }
                                yield false;
                            }
                            case ">=" -> {
                                if (documentSentiment >= sentimentCondition) {
                                    yield true;
                                }
                                yield false;
                            }
                            case "<=" -> {
                                if (documentSentiment <= sentimentCondition) {
                                    yield true;
                                }
                                yield false;
                            }
                            case "==" -> {
                                if (documentSentiment == sentimentCondition) {
                                    yield true;
                                }
                                yield false;
                            }
                            case "!=" -> {
                                if (documentSentiment != sentimentCondition) {
                                    yield true;
                                }
                                yield false;
                            }
                            default -> conditionsSatisfied;
                        };
                    } else {
                        conditionsSatisfied = false;
                    }
                }
            }
            if (conditionsSatisfied) continue;
            break;
        }
        return conditionsSatisfied;
    }

    @Override
    public Replacement getReplacement(String label, String context, String documentId, String token, String[] window, Crypto crypto, FPE fpe, AnonymizationService anonymizationService, FilterPattern filterPattern) throws Exception {
        Object replacement = null;
        String salt = "";
        if (StringUtils.equalsIgnoreCase((CharSequence)this.strategy, (CharSequence)"REDACT")) {
            replacement = this.getRedactedToken(token, label, filterType);
        } else if (StringUtils.equalsIgnoreCase((CharSequence)this.strategy, (CharSequence)"MASK")) {
            int characters = token.length();
            if (!StringUtils.equalsIgnoreCase((CharSequence)this.maskLength, (CharSequence)"SAME")) {
                characters = Integer.parseInt(this.maskLength);
            }
            if (characters < 1) {
                characters = 5;
            }
            replacement = this.maskCharacter.repeat(characters);
        } else if (StringUtils.equalsIgnoreCase((CharSequence)this.strategy, (CharSequence)"TRUNCATE")) {
            int leaveCharacters = PhEyeFilterStrategy.getValueOrDefault(PhEyeFilterStrategy.getValueOrDefault(this.truncateDigits, this.truncateLeaveCharacters), 4);
            if (leaveCharacters < 1) {
                leaveCharacters = 1;
            }
            replacement = StringUtils.equalsIgnoreCase((CharSequence)this.truncateDirection, (CharSequence)"LEADING") ? token.substring(0, leaveCharacters) + StringUtils.repeat((String)this.truncateCharacter, (int)(token.length() - leaveCharacters)) : StringUtils.repeat((String)this.truncateCharacter, (int)(token.length() - leaveCharacters)) + token.substring(token.length() - leaveCharacters);
        } else if (StringUtils.equalsIgnoreCase((CharSequence)this.strategy, (CharSequence)"RANDOM_REPLACE")) {
            String scope = "DOCUMENT";
            if (StringUtils.equalsIgnoreCase((CharSequence)this.replacementScope, (CharSequence)"CONTEXT")) {
                scope = "CONTEXT";
            }
            replacement = this.getAnonymizedToken(scope, token, anonymizationService);
        } else if (StringUtils.equalsIgnoreCase((CharSequence)this.strategy, (CharSequence)"STATIC_REPLACE")) {
            replacement = this.staticReplacement;
        } else if (StringUtils.equalsIgnoreCase((CharSequence)this.strategy, (CharSequence)"CRYPTO_REPLACE")) {
            replacement = "{{" + Encryption.encrypt(token, crypto) + "}}";
        } else if (StringUtils.equalsIgnoreCase((CharSequence)this.strategy, (CharSequence)"FPE_ENCRYPT_REPLACE")) {
            replacement = Encryption.formatPreservingEncrypt(fpe, token);
        } else if (StringUtils.equalsIgnoreCase((CharSequence)this.strategy, (CharSequence)"HASH_SHA256_REPLACE")) {
            if (this.isSalt()) {
                salt = RandomStringUtils.randomAlphanumeric((int)16);
            }
            replacement = DigestUtils.sha256Hex((String)(token + salt));
        } else if (StringUtils.equalsIgnoreCase((CharSequence)this.strategy, (CharSequence)"ABBREVIATE")) {
            if (StringUtils.equalsIgnoreCase((CharSequence)label, (CharSequence)"PER")) {
                replacement = WordUtils.initials((String)token, null);
            }
        } else {
            replacement = this.getRedactedToken(token, label, filterType);
        }
        return new Replacement((String)replacement, salt);
    }
}

