/*
 * Decompiled with CFR 0.152.
 */
package ai.philterd.phileas.model.policy.filters.strategies.rules;

import ai.philterd.phileas.model.conditions.ParsedCondition;
import ai.philterd.phileas.model.conditions.ParserListener;
import ai.philterd.phileas.model.enums.FilterType;
import ai.philterd.phileas.model.objects.FilterPattern;
import ai.philterd.phileas.model.objects.Replacement;
import ai.philterd.phileas.model.policy.Crypto;
import ai.philterd.phileas.model.policy.FPE;
import ai.philterd.phileas.model.policy.Policy;
import ai.philterd.phileas.model.policy.filters.strategies.StandardFilterStrategy;
import ai.philterd.phileas.model.services.AnonymizationService;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BankRoutingNumberFilterStrategy
extends StandardFilterStrategy {
    private static final Logger LOGGER = LogManager.getLogger(BankRoutingNumberFilterStrategy.class);
    private static final FilterType filterType = FilterType.BANK_ROUTING_NUMBER;

    @Override
    public FilterType getFilterType() {
        return filterType;
    }

    @Override
    public boolean evaluateCondition(Policy policy, String context, String documentId, String token, String[] window, String condition, double confidence, Map<String, String> attributes) {
        boolean conditionsSatisfied = false;
        List<ParsedCondition> parsedConditions = ParserListener.getTerminals(condition);
        for (ParsedCondition parsedCondition : parsedConditions) {
            if (StringUtils.equalsIgnoreCase((CharSequence)"token", (CharSequence)parsedCondition.getField())) {
                conditionsSatisfied = this.evaluateTokenCondition(parsedCondition, token, window);
            } else if (StringUtils.equalsIgnoreCase((CharSequence)"context", (CharSequence)parsedCondition.getField())) {
                String conditionContext = parsedCondition.getValue();
                conditionsSatisfied = switch (parsedCondition.getOperator()) {
                    case "==" -> StringUtils.equalsIgnoreCase((CharSequence)("\"" + context + "\""), (CharSequence)conditionContext);
                    case "!=" -> {
                        if (!StringUtils.equalsIgnoreCase((CharSequence)("\"" + context + "\""), (CharSequence)conditionContext)) {
                            yield true;
                        }
                        yield false;
                    }
                    default -> conditionsSatisfied;
                };
            } else if (StringUtils.equalsIgnoreCase((CharSequence)"confidence", (CharSequence)parsedCondition.getField())) {
                double threshold = Double.parseDouble(parsedCondition.getValue());
                conditionsSatisfied = switch (parsedCondition.getOperator()) {
                    case ">" -> {
                        if (confidence > threshold) {
                            yield true;
                        }
                        yield false;
                    }
                    case "<" -> {
                        if (confidence < threshold) {
                            yield true;
                        }
                        yield false;
                    }
                    case ">=" -> {
                        if (confidence >= threshold) {
                            yield true;
                        }
                        yield false;
                    }
                    case "<=" -> {
                        if (confidence <= threshold) {
                            yield true;
                        }
                        yield false;
                    }
                    case "==" -> {
                        if (confidence == threshold) {
                            yield true;
                        }
                        yield false;
                    }
                    case "!=" -> {
                        if (confidence != threshold) {
                            yield true;
                        }
                        yield false;
                    }
                    default -> conditionsSatisfied;
                };
            } else if (StringUtils.equalsIgnoreCase((CharSequence)"sentiment", (CharSequence)parsedCondition.getField())) {
                if (attributes.containsKey("sentiment")) {
                    int documentSentiment = Integer.parseInt(attributes.get("sentiment"));
                    int sentimentCondition = Integer.parseInt(parsedCondition.getValue());
                    conditionsSatisfied = switch (parsedCondition.getOperator()) {
                        case ">" -> {
                            if (documentSentiment > sentimentCondition) {
                                yield true;
                            }
                            yield false;
                        }
                        case "<" -> {
                            if (documentSentiment < sentimentCondition) {
                                yield true;
                            }
                            yield false;
                        }
                        case ">=" -> {
                            if (documentSentiment >= sentimentCondition) {
                                yield true;
                            }
                            yield false;
                        }
                        case "<=" -> {
                            if (documentSentiment <= sentimentCondition) {
                                yield true;
                            }
                            yield false;
                        }
                        case "==" -> {
                            if (documentSentiment == sentimentCondition) {
                                yield true;
                            }
                            yield false;
                        }
                        case "!=" -> {
                            if (documentSentiment != sentimentCondition) {
                                yield true;
                            }
                            yield false;
                        }
                        default -> conditionsSatisfied;
                    };
                } else {
                    conditionsSatisfied = false;
                }
            }
            LOGGER.debug("Condition for [{}] satisfied: {}", (Object)condition, (Object)conditionsSatisfied);
            if (conditionsSatisfied) continue;
            break;
        }
        return conditionsSatisfied;
    }

    @Override
    public Replacement getReplacement(String label, String context, String documentId, String token, String[] window, Crypto crypto, FPE fpe, AnonymizationService anonymizationService, FilterPattern filterPattern) throws Exception {
        return this.getStandardReplacement(label, context, documentId, token, window, crypto, fpe, anonymizationService, filterPattern, filterType);
    }
}

