/*
 * Decompiled with CFR 0.152.
 */
package ai.philterd.phileas.model.policy.filters.strategies.rules;

import ai.philterd.phileas.model.conditions.ParsedCondition;
import ai.philterd.phileas.model.conditions.ParserListener;
import ai.philterd.phileas.model.enums.FilterType;
import ai.philterd.phileas.model.objects.FilterPattern;
import ai.philterd.phileas.model.objects.Replacement;
import ai.philterd.phileas.model.policy.Crypto;
import ai.philterd.phileas.model.policy.FPE;
import ai.philterd.phileas.model.policy.Policy;
import ai.philterd.phileas.model.policy.filters.strategies.AbstractFilterStrategy;
import ai.philterd.phileas.model.services.AnonymizationService;
import ai.philterd.phileas.model.utils.Encryption;
import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.Period;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.DateTimeParseException;
import java.time.format.ResolverStyle;
import java.time.temporal.ChronoField;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.RandomUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DateFilterStrategy
extends AbstractFilterStrategy {
    private static final Logger LOGGER = LogManager.getLogger(DateFilterStrategy.class);
    private static final FilterType filterType = FilterType.DATE;
    @SerializedName(value="shiftRandom")
    @Expose
    private boolean shiftRandom = false;
    @SerializedName(value="shiftDays")
    @Expose
    private Integer shiftDays = 0;
    @SerializedName(value="shiftMonths")
    @Expose
    private Integer shiftMonths = 0;
    @SerializedName(value="shiftYears")
    @Expose
    private Integer shiftYears = 0;
    @SerializedName(value="futureDates")
    @Expose
    private boolean futureDates = false;

    @Override
    public FilterType getFilterType() {
        return filterType;
    }

    @Override
    public boolean evaluateCondition(Policy policy, String context, String documentId, String token, String[] window, String condition, double confidence, Map<String, String> attributes) {
        boolean conditionsSatisfied = false;
        List<ParsedCondition> parsedConditions = ParserListener.getTerminals(condition);
        for (ParsedCondition parsedCondition : parsedConditions) {
            if (StringUtils.equalsIgnoreCase((CharSequence)"token", (CharSequence)parsedCondition.getField())) {
                conditionsSatisfied = this.evaluateTokenCondition(parsedCondition, token, window);
            } else if (StringUtils.equalsIgnoreCase((CharSequence)"context", (CharSequence)parsedCondition.getField())) {
                String conditionContext = parsedCondition.getValue();
                conditionsSatisfied = switch (parsedCondition.getOperator()) {
                    case "==" -> StringUtils.equalsIgnoreCase((CharSequence)("\"" + context + "\""), (CharSequence)conditionContext);
                    case "!=" -> {
                        if (!StringUtils.equalsIgnoreCase((CharSequence)("\"" + context + "\""), (CharSequence)conditionContext)) {
                            yield true;
                        }
                        yield false;
                    }
                    default -> conditionsSatisfied;
                };
            } else if (StringUtils.equalsIgnoreCase((CharSequence)"confidence", (CharSequence)parsedCondition.getField())) {
                double threshold = Double.parseDouble(parsedCondition.getValue());
                conditionsSatisfied = switch (parsedCondition.getOperator()) {
                    case ">" -> {
                        if (confidence > threshold) {
                            yield true;
                        }
                        yield false;
                    }
                    case "<" -> {
                        if (confidence < threshold) {
                            yield true;
                        }
                        yield false;
                    }
                    case ">=" -> {
                        if (confidence >= threshold) {
                            yield true;
                        }
                        yield false;
                    }
                    case "<=" -> {
                        if (confidence <= threshold) {
                            yield true;
                        }
                        yield false;
                    }
                    case "==" -> {
                        if (confidence == threshold) {
                            yield true;
                        }
                        yield false;
                    }
                    case "!=" -> {
                        if (confidence != threshold) {
                            yield true;
                        }
                        yield false;
                    }
                    default -> conditionsSatisfied;
                };
            } else if (StringUtils.equalsIgnoreCase((CharSequence)"sentiment", (CharSequence)parsedCondition.getField())) {
                if (attributes.containsKey("sentiment")) {
                    int documentSentiment = Integer.parseInt(attributes.get("sentiment"));
                    int sentimentCondition = Integer.parseInt(parsedCondition.getValue());
                    conditionsSatisfied = switch (parsedCondition.getOperator()) {
                        case ">" -> {
                            if (documentSentiment > sentimentCondition) {
                                yield true;
                            }
                            yield false;
                        }
                        case "<" -> {
                            if (documentSentiment < sentimentCondition) {
                                yield true;
                            }
                            yield false;
                        }
                        case ">=" -> {
                            if (documentSentiment >= sentimentCondition) {
                                yield true;
                            }
                            yield false;
                        }
                        case "<=" -> {
                            if (documentSentiment <= sentimentCondition) {
                                yield true;
                            }
                            yield false;
                        }
                        case "==" -> {
                            if (documentSentiment == sentimentCondition) {
                                yield true;
                            }
                            yield false;
                        }
                        case "!=" -> {
                            if (documentSentiment != sentimentCondition) {
                                yield true;
                            }
                            yield false;
                        }
                        default -> conditionsSatisfied;
                    };
                } else {
                    conditionsSatisfied = false;
                }
            }
            LOGGER.debug("Condition for [{}] satisfied: {}", (Object)condition, (Object)conditionsSatisfied);
            if (conditionsSatisfied) continue;
            break;
        }
        return conditionsSatisfied;
    }

    @Override
    public Replacement getReplacement(String label, String context, String documentId, String token, String[] window, Crypto crypto, FPE fpe, AnonymizationService anonymizationService, FilterPattern filterPattern) throws Exception {
        String salt;
        Object replacement;
        block32: {
            replacement = null;
            salt = "";
            if (StringUtils.equalsIgnoreCase((CharSequence)this.strategy, (CharSequence)"REDACT")) {
                replacement = this.getRedactedToken(token, label, filterType);
            } else if (StringUtils.equalsIgnoreCase((CharSequence)this.strategy, (CharSequence)"MASK")) {
                int characters = token.length();
                if (!StringUtils.equalsIgnoreCase((CharSequence)this.maskLength, (CharSequence)"SAME")) {
                    characters = Integer.parseInt(this.maskLength);
                }
                if (characters < 1) {
                    characters = 5;
                }
                replacement = this.maskCharacter.repeat(characters);
            } else if (StringUtils.equalsIgnoreCase((CharSequence)this.strategy, (CharSequence)"TRUNCATE")) {
                int leaveCharacters = DateFilterStrategy.getValueOrDefault(DateFilterStrategy.getValueOrDefault(this.truncateDigits, this.truncateLeaveCharacters), 4);
                if (leaveCharacters < 1) {
                    leaveCharacters = 1;
                }
                replacement = StringUtils.equalsIgnoreCase((CharSequence)this.truncateDirection, (CharSequence)"LEADING") ? token.substring(0, leaveCharacters) + StringUtils.repeat((String)this.truncateCharacter, (int)(token.length() - leaveCharacters)) : StringUtils.repeat((String)this.truncateCharacter, (int)(token.length() - leaveCharacters)) + token.substring(token.length() - leaveCharacters);
            } else if (StringUtils.equalsIgnoreCase((CharSequence)this.strategy, (CharSequence)"RANDOM_REPLACE")) {
                String scope = "DOCUMENT";
                if (StringUtils.equalsIgnoreCase((CharSequence)this.replacementScope, (CharSequence)"CONTEXT")) {
                    scope = "CONTEXT";
                }
                replacement = this.getAnonymizedToken(scope, token, anonymizationService);
            } else if (StringUtils.equalsIgnoreCase((CharSequence)this.strategy, (CharSequence)"STATIC_REPLACE")) {
                replacement = this.staticReplacement;
            } else if (StringUtils.equalsIgnoreCase((CharSequence)this.strategy, (CharSequence)"CRYPTO_REPLACE")) {
                replacement = "{{" + Encryption.encrypt(token, crypto) + "}}";
            } else if (StringUtils.equalsIgnoreCase((CharSequence)this.strategy, (CharSequence)"HASH_SHA256_REPLACE")) {
                if (this.isSalt()) {
                    salt = RandomStringUtils.randomAlphanumeric((int)16);
                }
                replacement = DigestUtils.sha256Hex((String)(token + salt));
            } else if (StringUtils.equalsIgnoreCase((CharSequence)this.strategy, (CharSequence)"TRUNCATE_TO_YEAR")) {
                try {
                    DateTimeFormatter dtf = DateTimeFormatter.ofPattern(filterPattern.getFormat(), Locale.US).withResolverStyle(ResolverStyle.STRICT);
                    LocalDateTime parsedDate = LocalDate.parse(token, dtf).atStartOfDay();
                    replacement = String.valueOf(parsedDate.getYear());
                }
                catch (DateTimeParseException ex) {
                    LOGGER.error("Unable to parse date with format " + filterPattern.getFormat() + ". Falling back to redaction.", (Throwable)ex);
                    replacement = this.getRedactedToken(token, label, filterType);
                }
            } else if (StringUtils.equalsIgnoreCase((CharSequence)this.strategy, (CharSequence)"SHIFT")) {
                try {
                    DateTimeFormatter dtf = DateTimeFormatter.ofPattern(filterPattern.getFormat(), Locale.US).withResolverStyle(ResolverStyle.STRICT);
                    LocalDateTime parsedDate = LocalDate.parse(token, dtf).atStartOfDay();
                    if (this.shiftRandom) {
                        int randomShiftDays = RandomUtils.nextInt((int)1, (int)30);
                        int randomShiftMonths = RandomUtils.nextInt((int)1, (int)12);
                        int randomShiftYears = 0 - RandomUtils.nextInt((int)1, (int)3);
                        LocalDateTime shiftedDate = parsedDate.plusDays(randomShiftDays).plusMonths(randomShiftMonths).plusYears(randomShiftYears);
                        replacement = shiftedDate.format(dtf);
                        break block32;
                    }
                    LocalDateTime shiftedDate = parsedDate.plusDays(this.shiftDays.intValue()).plusMonths(this.shiftMonths.intValue()).plusYears(this.shiftYears.intValue());
                    replacement = shiftedDate.format(dtf);
                }
                catch (DateTimeParseException ex) {
                    LOGGER.error("Unable to parse date with format " + filterPattern.getFormat() + ". Falling back to redaction.", (Throwable)ex);
                    replacement = this.getRedactedToken(token, label, filterType);
                }
            } else if (StringUtils.equalsIgnoreCase((CharSequence)this.strategy, (CharSequence)"RELATIVE")) {
                try {
                    DateTimeFormatter dtf = new DateTimeFormatterBuilder().appendPattern(filterPattern.getFormat()).parseDefaulting(ChronoField.DAY_OF_MONTH, 1L).toFormatter();
                    LocalDateTime parsedDate = LocalDate.parse(token, dtf).atStartOfDay();
                    LocalDateTime currentDate = LocalDateTime.now();
                    replacement = this.getReadableDate(parsedDate, currentDate, token, label, filterType);
                }
                catch (DateTimeParseException ex) {
                    LOGGER.error("Unable to parse date. Falling back to redaction.", (Throwable)ex);
                    replacement = this.getRedactedToken(token, label, filterType);
                }
            } else {
                replacement = this.getRedactedToken(token, label, filterType);
            }
        }
        return new Replacement((String)replacement, salt);
    }

    public String getReadableDate(LocalDateTime parsedDate, LocalDateTime currentDate, String token, String label, FilterType filterType) {
        Object replacement;
        Period period = Period.between(parsedDate.toLocalDate(), currentDate.toLocalDate());
        if (!period.isNegative()) {
            int months = Math.abs(period.getMonths());
            if (period.getDays() >= 15) {
                ++months;
            }
            int years = Math.abs(period.getYears());
            String relative = years + " years " + months + " months ago";
            if (years == 0) {
                relative = months + " months ago";
            }
            replacement = relative;
        } else if (this.futureDates) {
            int months = Math.abs(period.getMonths());
            if (period.getDays() >= 15) {
                ++months;
            }
            int years = Math.abs(period.getYears());
            String relative = "in " + years + " years " + months + " months";
            if (years == 0) {
                relative = "in " + months + " months";
            }
            replacement = relative;
        } else {
            replacement = this.getRedactedToken(token, label, filterType);
        }
        return replacement;
    }

    public Integer getShiftDays() {
        return this.shiftDays;
    }

    public void setShiftDays(Integer shiftDays) {
        this.shiftDays = shiftDays;
    }

    public Integer getShiftMonths() {
        return this.shiftMonths;
    }

    public void setShiftMonths(Integer shiftMonths) {
        this.shiftMonths = shiftMonths;
    }

    public Integer getShiftYears() {
        return this.shiftYears;
    }

    public void setShiftYears(Integer shiftYears) {
        this.shiftYears = shiftYears;
    }

    public boolean getFutureDates() {
        return this.futureDates;
    }

    public void setFutureDates(boolean futureDates) {
        this.futureDates = futureDates;
    }

    public void setShiftRandom(boolean shiftRandom) {
        this.shiftRandom = shiftRandom;
    }

    public boolean isShiftRandom() {
        return this.shiftRandom;
    }
}

